/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.par;

import java.awt.Color;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.cur.units;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.paramMenu;
import jcm.gui.nav.paramOption;
import jcm.gui.nav.paramValueChooser;
import jcm.script.calcscript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class param<T>
extends interacob {
    public Type type;
    public T[] menulist;
    public T chosen;
    public T defchosen;
    public int numitems;
    Class listtype;
    public complexity[] itemcomplexity;
    public boolean flag;
    public boolean defflag;
    public double val;
    public double defval;
    public double max;
    public double min;
    public units units;
    public int dp = 2;
    public param pair;
    public static boolean reportchange = true;
    static float pc = 0.0f;

    public param(Object ... args) {
        int dc = 0;
        int sc = 0;
        this.mycomplexity = complexity.normal;
        for (Object a : args) {
            if ((a instanceof Object[] || a instanceof Collection) && this.menulist == null) {
                this.type = Type.menu;
                Object[] o = a instanceof Object[] ? (Object[])a : ((Collection)a).toArray();
                this.menulist = o;
                this.numitems = this.menulist.length;
                this.itemcomplexity = new complexity[this.menulist.length];
                this.listtype = a.getClass().getComponentType();
                continue;
            }
            if (this.menulist != null && this.chosen == null && (this.listtype == null || this.listtype.isInstance(a))) {
                this.chosen = a;
                this.defchosen = a;
                continue;
            }
            if (a instanceof Type) {
                this.type = (Type)((Object)a);
            }
            if (a instanceof Color) {
                this.color = (Color)a;
            }
            if (a instanceof Boolean) {
                this.defflag = this.flag = ((Boolean)a).booleanValue();
                this.type = Type.option;
            }
            if (a instanceof param) {
                this.pair = (param)a;
            }
            if (a instanceof complexity) {
                this.mycomplexity = (complexity)((Object)a);
            }
            if (a instanceof complexity[]) {
                this.itemcomplexity = (complexity[])a;
            }
            if (a instanceof Number) {
                if (this.type == null) {
                    this.type = Type.value;
                }
                double d = ((Number)a).doubleValue();
                if (dc == 0) {
                    this.defval = this.val = d;
                    this.min = Double.MAX_VALUE;
                    this.max = Double.MAX_VALUE;
                }
                if (dc == 1) {
                    this.min = d;
                }
                if (dc == 2) {
                    this.max = d;
                }
                if (dc == 3) {
                    this.units.scales = d;
                }
                if (dc == 4) {
                    this.units.scaleu = d;
                }
                ++dc;
            }
            if (a instanceof String) {
                String s = a.toString();
                if (sc == 0) {
                    this.name = s;
                }
                if (sc >= 1) {
                    this.units = new units(s);
                }
                ++sc;
            }
            if (!(a instanceof curveset)) continue;
            ((curveset)a).associate(this);
        }
        if (this.units != null) {
            this.units.checkunitcancel();
            this.units.checkunitfac(this.max - this.min);
        }
        this.register();
        this.addAction(filter.filtertype.Doc);
        this.priority = 1.0f + pc;
        pc = (float)((double)pc - 0.001);
    }

    public String save() {
        return this.getFullName() + "\t" + (this.type == Type.menu ? this.getchosenindex() + "\t" + this.chosen : (this.type == Type.option ? Boolean.valueOf(this.flag) : (this.type == Type.value ? Double.valueOf(this.val) : ""))) + "\n";
    }

    public void load(String s) {
        if (this.type == Type.menu) {
            this.choose(Integer.parseInt(s));
        }
        if (this.type == Type.option) {
            this.flag = s.equals("true");
        }
        if (this.type == Type.value) {
            this.val = Double.valueOf(s);
        }
        this.changed = true;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean allchange) {
        if (this.type == Type.menu && (allchange || this.chosen != this.defchosen)) {
            this.chosen = this.defchosen;
            this.changed = true;
        }
        if (this.type == Type.option && (allchange || this.flag != this.defflag)) {
            this.flag = this.defflag;
            this.changed = true;
        }
        if (this.type == Type.value && (allchange || this.val != this.defval)) {
            this.val = this.defval;
            this.changed = true;
        }
        if (this.type == Type.trigger) {
            this.flag = this.defflag;
        }
    }

    public void next() {
        this.choose((this.getchosenindex() + 1) % this.numitems);
    }

    public void prev() {
        this.choose((this.numitems + this.getchosenindex() - 1) % this.numitems);
    }

    public void choose(int i) {
        if (this.type == Type.menu) {
            int j = 0;
            for (T o : this.menulist) {
                if (!this.checkcomplexity(o)) continue;
                if (i == j) {
                    this.chosen = o;
                    return;
                }
                ++j;
            }
        }
    }

    public void choose(T c) {
        for (T o : this.menulist) {
            if (!c.equals(o)) continue;
            this.chosen = o;
        }
    }

    public void putval(double val) {
        this.val = val;
    }

    public void setcomplexity(T o, complexity c) {
        for (int j = 0; j < this.menulist.length; ++j) {
            if (!o.equals(this.menulist[j])) continue;
            this.itemcomplexity[j] = c;
        }
    }

    public void setlist(T[] newlist) {
        int n = newlist.length;
        this.itemcomplexity = new complexity[n];
        for (int j = 0; j < n; ++j) {
            this.itemcomplexity[j] = this.mycomplexity;
        }
        this.menulist = newlist;
    }

    public void set(double d) {
        this.val = d;
        if (this.val < this.min) {
            this.val = this.min;
        } else if (this.val > this.max) {
            this.val = this.max;
        }
        this.respond();
    }

    public void set(boolean b) {
        this.flag = b;
        this.respond();
    }

    public void set(T o) {
        this.choose(o);
        this.respond();
    }

    public void set(int i) {
        if (this.type == Type.value) {
            this.set((double)i);
        } else {
            this.choose(i);
            this.respond();
        }
    }

    public void set(String s) {
        if (this.type == Type.option) {
            this.flag = !s.equals("false") && !s.equals("f") && !s.equals("F") && !s.equals("off") && !s.equals("dis") && !s.equals("disabled");
        }
        if (this.type == Type.menu) {
            try {
                this.choose(s);
            }
            catch (Exception e) {
                report.deb("param " + this.name + " not same type as " + s);
            }
        }
        if (this.type == Type.value) {
            this.putval(Double.valueOf(s));
        }
        this.respond();
    }

    public void respond() {
        this.respond(!calcscript.delayloop());
    }

    public void respond(boolean domodloop) {
        this.report();
        this.changed = true;
        if (domodloop) {
            loop.golater("Change " + this.name, this.type != Type.value);
        }
    }

    public void report() {
        if (reportchange) {
            report.log(this.getFullName() + " set to: " + this.getstringval());
        }
    }

    public void precalc() {
    }

    public boolean checkneededforplot() {
        return register.checkneededforplotexcept(this, jcmTree.class);
    }

    public boolean isdefault() {
        if (this.type == Type.menu) {
            return this.chosen == this.defchosen;
        }
        if (this.type == Type.option) {
            return this.flag == this.defflag;
        }
        if (this.type == Type.value) {
            return this.val == this.defval;
        }
        return true;
    }

    public T getchosen() {
        return this.chosen;
    }

    public String getstringval() {
        return "" + (this.type == Type.option ? "" + this.flag : (this.type == Type.menu ? this.chosen.toString() : (this.type == Type.value ? "" + this.units.round(this.val) : "")));
    }

    public complexity getItemComplexity(T o) {
        if (this.itemcomplexity != null) {
            try {
                for (int j = 0; j < this.menulist.length; ++j) {
                    if (!o.equals(this.menulist[j])) continue;
                    return this.itemcomplexity[j] != null ? this.itemcomplexity[j] : complexity.simplest;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                report.deb("param item complexity error");
            }
        }
        return this.mycomplexity;
    }

    public boolean checkcomplexity(T o) {
        return complexity.check(this.getItemComplexity(o));
    }

    public double getval() {
        return this.val;
    }

    public double getdef() {
        return this.defval;
    }

    public double getfrac() {
        return this.val / this.defval;
    }

    public boolean istrue() {
        return this.flag;
    }

    public boolean isfalse() {
        return !this.flag;
    }

    public float min() {
        return (float)this.min;
    }

    public float max() {
        return (float)this.max;
    }

    public float range() {
        return (float)(this.max - this.min);
    }

    public boolean isnotdefault() {
        if (this.type == Type.menu) {
            return this.chosen != this.defchosen;
        }
        if (this.type == Type.value) {
            return this.val != this.defval;
        }
        if (this.type == Type.option) {
            return this.flag != this.defflag;
        }
        return false;
    }

    public String chosenname() {
        return this.chosen.toString();
    }

    public String getname(int i) {
        return this.menulist[i].toString();
    }

    public String getname(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        try {
            return o.getClass().getField("name").get(o).toString();
        }
        catch (Exception e) {
            try {
                return o.getClass().getMethod("getName", new Class[0]).invoke(o, new Object[0]).toString();
            }
            catch (Exception exception) {
                if (o instanceof interacob) {
                    return ((interacob)o).name;
                }
                if (o instanceof Enum) {
                    return ((Enum)o).name();
                }
                return o.getClass().getSimpleName();
            }
        }
    }

    public int getchosenindex() {
        int i = 0;
        for (T o : this.menulist) {
            if (this.chosen.equals(o)) {
                return i;
            }
            if (!this.checkcomplexity(o)) continue;
            ++i;
        }
        return -1;
    }

    public String getinfo() {
        return this.getLabel() + this.getstate() + this.addunits();
    }

    public String addunits() {
        return this.type == Type.value ? " \t\t" + labman.getShort(this.units.units) : "";
    }

    public String getstate() {
        block7: {
            block6: {
                if (this.type == Type.menu) {
                    return " \t\t" + labman.getTitle(this.chosen.toString()) + " (def=" + labman.getTitle(this.defchosen.toString()) + ") \n";
                }
                if (this.type == Type.option) {
                    return " \t\t: " + (this.flag ? labman.getTitle("ena") : labman.getTitle("dis")) + " (def=" + (this.defflag ? labman.getTitle("ena") : labman.getTitle("dis")) + ") \n";
                }
                if (this.type == Type.value) {
                    return " val=" + this.units.round(this.val, this.dp) + " (def=" + this.units.round(this.defval, this.dp) + ") \n";
                }
                if (this.type == Type.Xscale) break block6;
                if (this.type != Type.Yscale) break block7;
            }
            return (Object)((Object)this.type) + ": " + this.units.round(this.min) + " - " + this.units.round(this.max) + " " + labman.getShort(this.units.units) + labman.getTitleIfDifferent(this.units.units);
        }
        return "";
    }

    @Override
    public String docSummary() {
        return this.hashcolor() + (this.checkenabled(filter.filtertype.AllParams) ? "" : " //(inactive)// ") + autodoc.link(this) + "</font> " + "\u00a3%" + labman.convertkey(this.name) + "<br>";
    }

    @Override
    public String getExtraDoc() {
        block3: {
            block2: {
                if (this.type == Type.Xscale) break block2;
                if (this.type != Type.Yscale) break block3;
            }
            return this.getinfo();
        }
        return this.getInput() + this.moreinfo() + this.docNotes() + "<hr>" + this.docInteracs() + autodoc.javacode(this);
    }

    public String getInput() {
        return " <object classid=jcm.gui.nav." + (this.type == Type.option ? "paramOption" : (this.type == Type.menu ? "paramMenu" : "paramValueChooser")) + "><param name=paramName value='" + this.name + "'></param></option><br>";
    }

    public String moreinfo() {
        if (this.type == Type.menu) {
            String info2 = "";
            for (int i = 0; i < this.numitems; ++i) {
                String n = labman.convertkey(this.getname(i));
                info2 = info2 + "<li>" + autodoc.link(n) + " \u00a3%" + n;
            }
            return "<hr> \u00a3`moreinfo <ul>" + info2 + "</ul>";
        }
        if (this.type == Type.value && this.pair != null) {
            return "<hr>" + this.pair.getInput() + this.pair.moreinfo();
        }
        return "";
    }

    @Override
    public JComponent getComponent(Object ... args) {
        if (this.type == Type.menu) {
            return new paramMenu(this, args);
        }
        if (this.type == Type.value) {
            return new paramValueChooser(this, args);
        }
        if (this.type == Type.option) {
            return new paramOption(this, args);
        }
        return super.getComponent(new Object[0]);
    }

    public JMenuItem getMenuItem() {
        if (this.type == Type.menu) {
            jcmMenu pm = new jcmMenu(new Object[]{this.name});
            ButtonGroup group = new ButtonGroup();
            for (final T o : this.menulist) {
                if (!complexity.check(this.getItemComplexity(o))) continue;
                JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(new jcmAction(this.getname(o), this.getItemComplexity(o)){

                    public void act() {
                        param.this.set(o);
                    }
                });
                group.add(rbmi);
                pm.add(rbmi);
                if (o != this.chosen) continue;
                rbmi.setSelected(true);
            }
            return pm;
        }
        if (this.type == Type.option) {
            return new cb(this);
        }
        if (this.type == Type.value) {
            JMenuItem jm = new JMenuItem();
            JComponent c = this.getComponent("menu");
            jm.setLayout(null);
            jm.setEnabled(true);
            jm.add(c);
            c.revalidate();
            c.setLocation(0, 0);
            c.setSize(c.getPreferredSize());
            jm.setPreferredSize(c.getPreferredSize());
            return jm;
        }
        return null;
    }

    class cb
    extends JCheckBoxMenuItem
    implements plotlink,
    ChangeListener {
        public cb(param p) {
            this.setText(param.this.name);
            this.setSelected(param.this.istrue());
            this.setForeground(param.this.getColor());
            this.addChangeListener(this);
            register.addlink(this, p);
        }

        public void doplot() {
            if (param.this.changed) {
                loop.golater("CB doplot");
            }
            this.setSelected(param.this.istrue());
            this.setToolTipText(param.this.getinfo());
        }

        public void stateChanged(ChangeEvent e) {
            if (param.this.istrue() != this.isSelected()) {
                param.this.set(this.isSelected());
            }
            this.setText(param.this.getLabel());
            this.setToolTipText(param.this.getinfo());
        }

        public void addNotify() {
            super.addNotify();
            this.doplot();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        menu,
        option,
        value,
        Xscale,
        Yscale,
        trigger;

    }
}

