/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.cur;

import java.awt.Color;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;

public class curve
extends infob {
    public int sy;
    public int ey;
    public int xstep;
    public static final float dud = Float.NaN;
    public Type type;
    private float[] a;
    private curve qa;
    private curve qb;
    public linestyle style;
    public static param<smoothopt> smoothtype = new param(new Object[]{"smooth type", smoothopt.values(), smoothopt.triangular});
    public static param smoothinterval = new param("smooth spread", "", 4, 0, 7);

    public curve(Object ... args) {
        boolean clone;
        block23: {
            block24: {
                this.sy = module.gsy;
                this.ey = module.gey;
                this.xstep = 1;
                this.type = Type.normal;
                this.style = linestyle.line;
                int ic = 0;
                this.mycomplexity = complexity.normal;
                clone = false;
                this.color = curve.rcol();
                for (Object o : args) {
                    if (o instanceof curve) {
                        if (this.qa == null) {
                            this.qa = (curve)o;
                            this.color = this.qa.color;
                            this.name = this.qa.name;
                            this.sy = this.qa.sy;
                            this.ey = this.qa.ey;
                            this.xstep = this.qa.xstep;
                            continue;
                        }
                        this.qb = (curve)o;
                        continue;
                    }
                    if (o instanceof Boolean) {
                        clone = (Boolean)o;
                    }
                    if (o instanceof interacob) {
                        this.owner = (interacob)o;
                    }
                    if (o instanceof float[]) {
                        this.a = (float[])o;
                    }
                    if (o instanceof Color) {
                        this.color = (Color)o;
                    }
                    if (o instanceof complexity) {
                        this.mycomplexity = (complexity)((Object)o);
                    }
                    if (o instanceof String) {
                        this.name = (String)o;
                    }
                    if (o instanceof Number) {
                        int i = ((Number)o).intValue();
                        switch (ic) {
                            case 0: {
                                this.sy = i;
                                break;
                            }
                            case 1: {
                                this.ey = i;
                                break;
                            }
                            case 2: {
                                this.xstep = i;
                            }
                        }
                        ++ic;
                    }
                    if (!(o instanceof Type)) continue;
                    this.type = (Type)((Object)o);
                }
                if (this.a != null) break block23;
                if (this.type == Type.normal || this.type == Type.total) break block24;
                if (this.type != Type.integral) break block23;
            }
            this.a = new float[1 + (this.ey - this.sy) / this.xstep];
        }
        if (this.type == Type.integral) {
            this.calcintegral();
        }
        if (clone) {
            if ((this.type == Type.normal || this.type == Type.total) && this.qa.xstep == this.xstep) {
                System.arraycopy(this.qa.a, (this.sy - this.qa.sy) / this.xstep, this.a, 0, this.a.length);
            } else {
                for (int y = this.sy; y <= this.ey; y += this.xstep) {
                    this.set(y, this.qa.get(y));
                }
            }
        }
    }

    public curve cloneIndependent(Object ... args) {
        Object[] args2 = new Object[args.length + 2];
        args2[0] = true;
        args2[1] = this;
        System.arraycopy(args, 0, args2, 2, args.length);
        return new curve(args2);
    }

    public void changeendyear(int oldey, int newey) {
        if (this.ey == oldey) {
            if (this.a != null) {
                float[] b = new float[1 + (newey - this.sy) / this.xstep];
                System.arraycopy(this.a, 0, b, 0, Math.min(this.a.length, b.length));
                this.a = b;
            }
            this.ey = newey;
        }
        if (this.qa != null) {
            this.qa.changeendyear(oldey, newey);
        }
        if (this.qb != null) {
            this.qb.changeendyear(oldey, newey);
        }
    }

    public static boolean ok(float f) {
        return !Float.isNaN(f);
    }

    public boolean gotdata(int year) {
        return year >= this.sy && year <= this.ey && !Float.isNaN(this.get(year)) && !Float.isNaN(this.get(year)) && !Float.isInfinite(this.get(year));
    }

    public float get() {
        return this.get(module.year);
    }

    public float get(int year) {
        switch (this.type) {
            case difference: {
                return this.qa != null && this.qb != null && curve.ok(this.qa.get(year)) && curve.ok(this.qb.get(year)) ? this.qa.get(year) - this.qb.get(year) : Float.NaN;
            }
            case sum: {
                return this.qa != null && this.qb != null && curve.ok(this.qa.get(year)) && curve.ok(this.qb.get(year)) ? this.qa.get(year) + this.qb.get(year) : Float.NaN;
            }
            case ratio: {
                return this.qa != null && this.qb != null && curve.ok(this.qa.get(year)) && curve.ok(this.qb.get(year)) && this.qb.get(year) != 0.0f ? this.qa.get(year) / this.qb.get(year) : Float.NaN;
            }
            case frac: {
                return curve.ok(this.qa.get(year)) ? 100.0f * this.qa.get(year) / ((curveset)this.owner).calctot(year) : Float.NaN;
            }
            case rate: {
                return curve.ok(this.qa.get(year)) && curve.ok(this.qa.get(year - this.xstep)) ? (this.qa.get(year) - this.qa.get(year - this.xstep)) / (float)this.xstep : Float.NaN;
            }
            case ratefrac: {
                return curve.ok(this.qa.get(year)) && curve.ok(this.qa.get(year - this.xstep)) && this.qa.get(year - this.xstep) != 0.0f ? (100.0f * this.qa.get(year) / this.qa.get(year - this.xstep) - 100.0f) / (float)this.xstep : Float.NaN;
            }
            case smooth: {
                float result = Float.NaN;
                int num = 0;
                int q = (int)smoothinterval.getval();
                int w = 1;
                for (int i = -q; i <= q; ++i) {
                    float next;
                    if (curve.smoothtype.chosen == smoothopt.triangular) {
                        w = (int)smoothinterval.getval() + 1 - Math.abs(i);
                    }
                    if (!curve.ok(next = this.qa.get(year + i))) continue;
                    num += w;
                    result = curve.ok(result) ? result + next * (float)w : next * (float)w;
                }
                return num > 0 ? result / (float)num : Float.NaN;
            }
        }
        if (year >= this.sy && year <= this.ey) {
            float f;
            if (this.xstep == 1) {
                return curve.ok(this.a[year - this.sy]) ? this.a[year - this.sy] : Float.NaN;
            }
            int n = (year - this.sy) / this.xstep;
            int r = (year - this.sy) % this.xstep;
            float f2 = f = r == 0 ? this.a[n] : this.a[n] + (this.a[n + 1] - this.a[n]) * ((float)r / (float)this.xstep);
            if (curve.ok(f)) {
                return f;
            }
        }
        return Float.NaN;
    }

    public void set(float f) {
        this.set(module.year, f);
    }

    public void set(int year, float f) {
        if (year >= this.sy && year <= this.ey) {
            this.a[(year - this.sy) / this.xstep] = f;
        }
    }

    public float[] geta() {
        return this.a;
    }

    public int getyear(int n) {
        return this.sy + this.xstep * n;
    }

    public int getlength() {
        return this.type == Type.normal || this.type == Type.total ? this.a.length : this.qa.a.length;
    }

    void calcintegral() {
        float tot = 0.0f;
        int isy = this.sy;
        int iey = this.ey;
        for (int y = isy; y <= iey; y += this.xstep) {
            this.a[(y - this.sy) / this.xstep] = tot += curve.ok(this.qa.get(y)) ? this.qa.get(y) : 0.0f;
        }
    }

    public float getmax() {
        float max = Float.MIN_VALUE;
        for (int y = this.sy; y < this.ey; y += this.xstep) {
            if (!curve.ok(this.get(y)) || !(this.get(y) > max)) continue;
            max = this.get(y);
        }
        return max;
    }

    public float getmin() {
        float min = Float.MAX_VALUE;
        for (int y = this.sy; y < this.ey; y += this.xstep) {
            if (!curve.ok(this.get(y)) || !(this.get(y) < min)) continue;
            min = this.get(y);
        }
        return min;
    }

    public String getLabel() {
        return labman.getTitle(this.name);
    }

    public String docSummary() {
        String name2 = labman.convertkey(this.name);
        return this.hashcolor() + autodoc.link(name2, this.getTitle() + labman.getShortIfDifferent(name2)) + "</font> " + "\u00a3%" + name2 + "<br>";
    }

    public String getExtraDoc() {
        return this.docNotes() + this.docOwner() + autodoc.javacode(this.owner);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum smoothopt {
        even,
        triangular;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum linestyle {
        line,
        dotted,
        dashed,
        dotdash;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        normal,
        difference,
        sum,
        ratio,
        ratefrac,
        rate,
        frac,
        total,
        integral,
        smooth,
        extra;

    }
}

