/*
 * plot_contribtemp_1.java
 *
 * Created on 7 février 2006, 11:49
 */

package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jcm.core.cur.curveset;
import jcm.gui.gen.imagesaver;
import jcm.gui.plot.lineplot;
import jcm.gui.nav.showpan;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import static jcm.core.report.*;

public class plot_contribtemp_1 extends calcscript{
    
    Map<String, curveset> regionCurves  = new HashMap();
    //String[] regionsChosen= contribtemp_1.regionsChosen;
    static String[] regionsChosen = new String[]{"United States", "Japan", "China", "India", "Canada", "Oceania", "North Europe", "South EU +France", "East Europe +Ukraine", "Russia", "Central Asia Stans", "Turkey", "Arabia", "Iran Pakn Afgn", "Other East Asia", "South East Asia", "Indonesia", "Central America", "Bolivia to Guiana", "Argta Chile Pgy Ugy", "Brazil.", "North Africa", "Sahel (Africa)", "Central Africa", "Southern Africa"};
    Map<String, Float> prob = new HashMap();
    boolean storeprob=true;
    
    public void run() {
        
        lineplot.thin = 500;
       
        for (final String s : regionsChosen){
            checkbut();
            regionCurves.put(s, new curveset(s, 1850, 2005, 5));
            log(s);
            File f=new File("results"+fs+s+".tab");
            
            String[][] s1 = fileio.loadtab(f, "\t");
            
            for (int r=0; r<s1.length; r++) {
                String line = "";
                if (r==0) {
                    for (int c=1; c<s1[0].length; c++) {
                        regionCurves.get(s).getOrAddCurve(s1[0][c]);
                        String[] parts=txt.split(s1[0][c], new String[] {" ", "_"});
                        if(storeprob) prob.put(s1[0][c], Float.parseFloat(parts[parts.length-1])-440);
                        try {
                            Color col=new Color(
//parts[0].equals("IVIGmodel-A_") ? 150 : 0, parts[0].equals("IVIGmodel-B_") ? 150 : 0, parts[0].equals("IVIGmodel-B/ISAM_") ? 150 : 0,                                    
//parts[0].equals("IVIGmodel-A_") ? 0 : parts[0].equals("IVIGmodel-B_") ? 75 : parts[0].equals("IVIGmodel-B/ISAM_") ? 150 : 225,
//(Float.parseFloat(parts[parts.length-4]) > 0.5) ? 200 : (Float.parseFloat(parts[parts.length-4]) > 0.2 && Float.parseFloat(parts[parts.length-4]) < 0.5) ? 100 : 0,
//(Float.parseFloat(parts[parts.length-3]) > 1.0 && (Float.parseFloat(parts[parts.length-3]) < 1.5)) ? 150 : (Float.parseFloat(parts[parts.length-3]) > 1.5) ? 75 : 0,
(Float.parseFloat(parts[parts.length-4]) > 0.5) ? 200 : (Float.parseFloat(parts[parts.length-4]) > 0.2 && Float.parseFloat(parts[parts.length-4]) < 0.5) ? 100 : 0,
parts[0].equals("IVIGmodel-A_") ? 225 : parts[0].equals("IVIGmodel-B_") ? 150 : parts[0].equals("IVIGmodel-B/ISAM_") ? 75 : 0,
parts[0].equals("Houghton_") ? 225 : 0,
(int)(4000 / (Float.parseFloat(parts[parts.length-1])-430))
                                    );
                            regionCurves.get(s).getOrAddCurve(s1[0][c]).color=col;
                        } catch (Exception e) { String sss=""; for (String ss : parts) sss+=ss+"\t"; log("color out of range "+sss); }
                    }
                    storeprob = false;
                } else {
                    for (int c=1; c<s1[0].length; c++) regionCurves.get(s).set(s1[0][c], (int)Float.parseFloat(s1[r][0]) , Float.parseFloat(s1[r][c]));
                }
            }//row
            
            //plotandsave(s);
            System.gc();
        } //s
        log("All tables loaded");
        
        pdf();
        
        end();
    } //end run
    
    void pdf() {
        curveset pdf = new curveset("pdf", "%", 0 ,300, 1), cumf = new curveset("cumf", "%", 0 ,300, 1);
        
        for (final String s : regionsChosen){
            for (int z=0; z<=1000; z++) { pdf.set(s,z,0); cumf.set(s,z,0); }
            pdf.getOrAddCurve(s).color=regman.allreg.findreg(s).color;  cumf.getOrAddCurve(s).color=regman.allreg.findreg(s).color;
            for (String n : prob.keySet()){
                int z=(int)(regionCurves.get(s).get(n, 2000)*10); //rel cont 0/00
                pdf.set(s, z, pdf.get(s,z)+ prob.get(n) );
            }//n
            for (int z=1; z<=1000; z++) cumf.set(s, z, cumf.get(s,z-1)+pdf.get(s,z-1));
            
        }//s
        
        JComponent c1 = plot(pdf);
        //resize(c1, 0, 0, 800, 600);
        ((lineplot)c1).xscale.min=0;
        
        ((lineplot)c1).xscale.max=300;
        ((lineplot)c1).xscale.changed=true;
        ((lineplot)c1).doplot();
        imagesaver.saveimage(c1, "png", new File("results"+fs+pdf+".png"));
        
        JComponent c2 = plot(cumf);
        //resize(c2, 0, 0, 800, 600);
        ((lineplot)c2).xscale.min=0;
        ((lineplot)c2).xscale.max=300;
        ((lineplot)c2).xscale.changed=true;
        ((lineplot)c2).doplot();
        
        imagesaver.saveimage(c2, "png", new File("results"+fs+cumf+".png"));
        
    }
        
    void plotandsave(final String s) {
//        SwingUtilities.invokeLater(new Runnable() { public void run() {
            //try {
                JComponent c1 = plot(regionCurves.get(s));
                //resize(c1, 0, 0, 800, 600);
                //((lineplot)c1).doplot();
                imagesaver.saveimage(c1, "png", new File("results"+fs+s+".png"));
                log("results"+fs+s+".png");
                showpan.dispose(c1);
            //} catch (Exception ex) {	log("Error plotting figure"); };
//        }});
    }
        
} //end class


