/*  module containing curvesets of  regional population, gdp, energy use, 
and methods to extrapolate these data from national historical data and future scenario data
 */
package jcm.mod.socio;

import java.util.HashMap;
import java.util.Map;
import jcm.mod.obj.regset;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.*;
import jcm.mod.obj.controller;
import jcm.mod.obj.sresext;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static jcm.mod.obj.sresdata.*;
import static java.lang.Math.*;


public class popgdp extends module {
    public void initsetup() {
        history.setaffectedby(gm(regset.class).regions);
        future.follows(history);
        future.setaffectedby(gm(controller.class).scenario);
        setaffectedby(gm(sresext.class)); //only the curves are affected, not the calcn
	future.setaffectedby(socconv);
    }
    public curveset pop = new curveset("population", "mega&person", simplest), //
            //energy =new qtset("energy", "tera&joule&per&year"), removed since data is old / low res and plays no role in calculations
             gdp_ppp = new curveset("gdp_ppp", "mega&dollar&(2000)&per&year", 1950), //
             gdp_mer = new curveset("gdp_mer", "mega&dollar&(2000)&per&year", 1950) //
            ;    //*****************

     public param socconv = new param("socioconv", "percent&per&year", dkgreen, 2f, 0f, 100f, expert);    //
     public param ppp_convfac = new param("ppp_convfac", "%&per&yr", 2, 0, 100, experimental);
     public param ppp_powfac = new param("ppp_powfac", "", 0.3, 0.1, 1, experimental);

     
     //=========== ref variables ===============================
     region regset;
    
    //==========================================
    
    /* History and Future are separate loopcalcs to enable 
    different interactions (don't always need to recalc history if change future) 
    and different calculation order in loop: bottom-up history and top-down future
     */
    //*************** HISTORY *************
    public loopcalc history = new loopcalc("socio-history") {
        public void precalc() {

             regset = (region) gm(regset.class).regions.chosen;
            gm(regset.class).clearoldregions(this);
            interpolator.fillregdata(histsocdata.histpop, pop, regset, 0.001f);
            interpolator.fillregdata(histsocdata.GDP_MER, gdp_mer, regset, 1f);
            interpolator.fillregdata(histsocdata.GDP_PPP, gdp_ppp, regset, 1f);

            for (int y = gsy; y < fsypop; y++) pop.calctot(y);
            for (int y = gsy; y < fsygdp; y++) {
                gdp_mer.calctot(y);
                gdp_ppp.calctot(y);
            }
        }
    }; //end history 
    //************** FUTURE **********
    public loopcalc future = new loopcalc("socio-future") {
        public void precalc() {
        controller co=gm(controller.class);
	
            new interpolator(sres_image_popn.get(co.scpop)).fill(pop, regset, fsypop, 2100, histsocdata.histpop, (float) socconv.getval());
            for (int y = fsypop; y <= 2100; y++) pop.calctot(y);

            //note:  IMAGE was based on 1995$ , whilst the PWT_MER is based on 2000$, 0.9211 is the deflator from WEO (see histregdata)
            float inflator = 1f / 0.9211f;
            new interpolator(sres_image_gdp.get(co.scgdp), inflator).fill(gdp_mer, regset, fsygdp, 2100, histsocdata.GDP_MER, (float) socconv.getval());
            futureppp();
            for (int y = fsygdp; y <= 2100; y++) {
                gdp_mer.calctot(y);
                gdp_ppp.calctot(y);
            }
        }
    };
    
    
    /**
    Calculate the future GDP in Purchasing Power Parity
    There is not yet any accepted way to estimate future PPP rates, and few SRES models reported them
    So we assume:
    p/m = (m/u)^beta
    where
    p =gdp-ppp/cap, m=gdp-mer/cap  and u  =gapUS/cap (same for both mer and ppp)
    intitial factors beta (negative) are taken from initial data (see below),
    
    in future use dm/m.dt and du/u.dt from image data, but don't constrain the totals
    if r=p/m = (m/u)^b
    => p = m^(1+b) / u^b
    => dp/dt = (1+b) (m/u)^b dm/dt  - b (m/u)(m/u)^b du/dt
    = p ( (1+b) dm/m.dt  - b  du/u.dt )
        
    P2 this formula is problematic for Japan: m>u but p<u => p/m < u/m => beta <-1 i.e. the richer Japan gets wrt US, the lower the ppp wrt  US
    Also, problem if m and u are almost same => log (1)/log(1) = 0/0...
    
    could solve with an additional factor alpha?
    
    r=p/m = a.(m/u)^b
    (note: if b = -1, all countries equally rich, if b=0 ppp=mer)
    
    => p =  a. m^(1+b) / u^b
    => dp/dt = a. (1+b) (m/u)^b dm/dt  - a.b (m/u)(m/u)^b du/dt +da/dt . p/a
    => dp/dt  = p ( (1+b) dm/m.dt  - b  du/u.dt + da/a.dt )
    
    but then need more info to calibrate
    maybe alpha should be country specific and beta global (based on regression?),
    then gradually fade out the alphas...? (in which case above algebra needs adjusting to account for da/dt)
    
    start with beta = - 0.3 ? or -0.5
    and da/dt = 0.02(1-a)
    
    Alternative approach: could calculate PPP for image regions and then use interpolator for others, but would give poorer continuity (betas would no longer compensate for smaller countries)
     */
    public void futureppp() {
        //note: this will only work for regionsets containing USA - i.e. not SRES4 or Kyoto!!
        curveset mer = gm(popgdp.class).gdp_mer, ppp = gm(popgdp.class).gdp_ppp, pop = gm(popgdp.class).pop;
        region USA = regman.nations.find("USA");
        if (!mer.map.keySet().contains(USA)) {
            deb("\nCan't calculate future PPP without USA in the chosen regionset!! ");
            return;
        }

        Map<region, Float> alpha = new HashMap();
        float a, p, m, u, dm, du, dp, da;
        float acf = (float) ppp_convfac.getval() / 100f;
        float b = (float) -ppp_powfac.getval();


        for (int y = fsygdp-1; y < 2100; y++) {
            u = mer.get(USA, y) / pop.get(USA, y);
            du = (mer.get(USA, y + 1) / pop.get(USA, y + 1) - u) / u;
            ppp.set(USA, y + 1, mer.get(USA, y + 1));

            for (region r : gm(regset.class).regions.chosen.reg) if (r != USA) {
                    m = mer.get(r, y) / pop.get(r, y);
                    dm = (mer.get(r, y + 1) / pop.get(r, y + 1) - m) / m;
                    p = ppp.get(r, y) / pop.get(r, y);


                    if (y == fsygdp-1) {
                        a = (float) ((p / m) / pow((m / u), b));   /* deb(r.name+"gdp a= "+a); */ } else a = alpha.get(r);

                    da = acf * (1f - a); //converge alphas towards 1 by convfac% per year
                    alpha.put(r, a + da);

                    dp = p * (dm * (1f + b) - b * du + da / a);
                    ppp.set(r, y + 1, pop.get(r, y + 1) * (p + dp));
                } //r
        }//y



    } //fppp
    /* OLD method
    //Map<region, Float> beta=new HashMap();
    //float sumbeta=0; int nb=0; // for checking
    
    if (y==2008) {
    b=(float)( log(p/m) / log(m/u ));
    beta.put(r, b);
    deb(r.name+" b= "+b);
    if (!Float.isNaN(b)) { sumbeta+=b; nb+=1; }
    } else b=beta.get(r);
    //end of loop ... deb("avg beta="+sumbeta/nb);
    */
} // end class
    
