/*
 * Historical Socioeconomic Data 
 * created from part of old histregdata, jan09
 * The data is kept here in the original countries - the conversion to larger regions is done using seperate curvesets in socio.java
 * This national data is never changed after startup, so there are no interactions and the curvesets are static
 * Their contents can be viewed in expert complexity level
 */
package jcm.mod.socio;

import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.cur.*;
import jcm.core.reg.*;
import static jcm.core.data.loadtable.*;
import static jcm.core.report.*;


public class histsocdata extends module implements dataholder {
    
    // GDP deflator  to convert current US$ to 2000 US$, from WEOOct2008, field USA-NGDP_D, 1980-2013, 
    static double[] deflator = {
        54.04, 59.12, 62.73, 65.21, 67.66, 69.71, 71.25, 73.2, 75.69, 78.56,
        81.59, 84.44, 86.39, 88.38, 90.26, 92.11, 93.85, 95.41, 96.47, 97.87,
        100, 102.4, 104.19, 106.4, 109.46, 
        113.03,	116.68,	119.82,	122.46,	124.42,	126.28,	128.66,	131.14,	133.67
        // old April 08 data ended with: 113, 116.57, 119.68, 122.09, 124.3, 126.6, 129.28, 131.76, 134.09
    };
    
    public static curveset //
             histpop = new curveset("pop", "kilo&person", 1700, 2004, complexity.expert), // histpopHYDE=new qtset("pop", "kilo&person", 1700, 1995, complexity.expert),
             GDP_PPP = new curveset("GDP_PPP", "mega&dollar&(2000)&-PPP", 1950, 2013, 1, complexity.expert), //mixed sources in 2000 dollars
             GDP_MER = new curveset("GDP_MER", "mega&dollar&(2000)&-MER", 1950, 2013, 1, complexity.expert), //ditto
             WEOGDP_PPP = new curveset("WEO_GDP_PPP", "mega&dollar&(current)&-PPP", 1980, 2013, 1, complexity.expert), // note - in "current international dollars", not 2000
             WEOGDP_MER = new curveset("WEO_GDP_MER", "mega&dollar&-PPP", 1980, 2013, 1, complexity.expert), // note - in "current US dollars", not 2000
             PWTCGDP = new curveset("PWTGDP", "dollar&2000&-PPP&per&person", 1950, 2004, 1, complexity.expert),  PWTpop = new curveset("PWTpop", "kilo&perso", 1950, 2004, 1, complexity.expert),  PWTppprate = new curveset("PWTppp_rate", "localcurrency&per&ppp_dollar", 1950, 2004, 1, complexity.expert),  PWTmerate = new curveset("PWTmex_rate", "localcurrency&per&dollar", 1950, 2004, 1, complexity.expert);


//this is called from histemitdata to ensure that GDP data is complete before extrapolating emissions 
    public static void fillhistdata() {
         loaddata(histpop, "data/hist/HYDE_pop_kkg.csv", "\t", true, 1f, 1700, 1995, 1700);

             // the second false below means that names will not be converted to regions
        loaddata(PWTpop, "data/hist/PWTpop.csv", "\t", false, false, 1f, 1950, 2004, 1950, 1);
        loaddata(PWTCGDP, "data/hist/PWTcgdp.csv", "\t", false, false, 1f, 1950, 2004, 1950, 1);    // per capita, ppp
        loaddata(PWTppprate, "data/hist/PWTppp.csv", "\t", false, false, 1f, 1950, 2004, 1950, 1);    // local currency / $ppp
        loaddata(PWTmerate, "data/hist/PWTxrat.csv", "\t", false, false, 1f, 1950, 2004, 1950, 1);    // local currency / $mex
        loaddata(WEOGDP_MER, "data/hist/WEOgdp_mer.csv", "\t", false, 1000f, 1980, 2013, 1980);
        loaddata(WEOGDP_PPP, "data/hist/WEOgdp_ppp.csv", "\t", false, 1000f, 1980, 2013, 1980);
        fixpop();
        combinePWT();
        blend(WEOGDP_MER, GDP_MER);
        blend(WEOGDP_PPP, GDP_PPP);
  
        
        }
    
    
     static void fixpop() { //fix missing data after break of S&M
         for (int y=2002; y<=2004; y++) PWTpop.set("Serbia and Montenegro", y, PWTpop.get("Serbia and Montenegro", 2001));
     } 
      
    /*************** GDP *******************
     * The PWT GDP data is per capita, and the rates are per $.
     * These need to be converted to absolute quantities before they can be added, particularly for combining small countries and  islands.
     * check ok : mex/ppp is >1 for all except richest countries  => gdp mer will be less than gdp ppp
     * check ok: all 4 files have same number rows x columns
     */
    static void combinePWT() {
        float pop, gdp_p, gdp_m, ppper, mer;

        for (region r : regman.nations.reg) {
            for (int y = 1950; y <= 2004; y++) {
                if (r!=regman.nations.findreg("East Timor")) histpop.set(r, y, 0f); //note PWTpop doesn't have East Timor
                GDP_PPP.set(r, y, curve.dud);
                GDP_MER.set(r, y, curve.dud);
            }    // need to wipe out the HYDE data
        }

        pwtloop:
        for (Object o : PWTpop.map.keySet()) {
            region r = regman.allreg.findreg(o.toString());

            if (r == null) {
                deb("PWT data: can't find region " + o + ": ignored ");
                continue pwtloop;
            }

            for (int y = 1950; y <= 2004; y++) {
                pop = PWTpop.get(o, y);
                histpop.add(r, y, pop);

                if (PWTCGDP.gotdata(o, y)) {
                    gdp_p = 0.001f * pop * PWTCGDP.get(o, y);
                    GDP_PPP.add(r, y, gdp_p);

                    if (PWTppprate.gotdata(o, y)) {
                        ppper = PWTppprate.get(o, y);
                        mer = PWTmerate.get(o, y);
                        gdp_m = gdp_p * ppper / mer;    // note: the fraction is this way up, because the two exchange rates are local currency / $ppp and local currency / $mex
                        GDP_MER.add(r, y, gdp_m);
                    }
                }
            }
        }
    }

    /*
     * WEO PPP data used after 2000, and as base for 2000 to correct PWT before that
     * //P3 try alternative - use WEO from 1980, and 1980 as basis for correction?
     * PWT data retained if WEO missing
     * linear extrapolation (based on 5yr trend) after 2003/4 for a few small countries, if growth is positive, otherwise constant
     * Note: French Guyana, Palestine, Burma and East-Timor have no GDP data in 2000
     */
    static void blend(curveset extrasource, curveset gdp) {
        String lackdata="";
        for (region r : regman.nations.reg) {
            if (!(gdp.get(r, 2000) > 0)) { lackdata+=r.name+" "; continue; }
            float corrfac =  extrasource.get(r, 2000) / gdp.get(r, 2000);

            //corrected to use WEO PPPs as base, PWT corrected
            for (int y = 1950; y < 2000; y++) {
                gdp.set(r, y, ((gdp.get(r, y) > 0) ? (gdp.get(r, y) * corrfac) : 0));
            }
            for (int y = 2000; y < 2014; y++) {
                gdp.set(r, y, //
                        (extrasource.get(r, y) > 0) ? //
                        (100f / (float) deflator[y - 1980]) * extrasource.get(r, y) //
                        : (gdp.get(r, y) > 0) ? gdp.get(r, y) * corrfac //
                        : (gdp.get(r, y - 1) > gdp.get(r, y - 6)) ? gdp.get(r, y - 1) + 0.2f * (gdp.get(r, y - 1) - gdp.get(r, y - 6)) //
                        : gdp.get(r, y - 1)); //
            }
        }
        if (lackdata.length()>0) deb(gdp.name+" lacks data in 2000 for: "+lackdata); 
    }
    //original before july08 - PWT as base in 2000, WEO corrected
        /*
    for (int y = 2001; y < 2014; y++) {
    gdp.set(r, y, //
    (extrasource.get(r, y) > 0) ? //
    corrfac * (100f / (float) deflator[y - 1980]) * extrasource.get(r, y) //
    : (gdp.get(r, y) > 0) ? gdp.get(r, y) : (gdp.get(r, y - 1) > gdp.get(r, y - 6)) //
    ? gdp.get(r, y - 1) + 0.2f * (gdp.get(r, y - 1) - gdp.get(r, y - 6)) : gdp.get(r, y - 1)); //
    }
     */
    
        
    } //end class