package jcm.mod.regimp;

import jcm.mod.obj.regset;
import jcm.mod.socio.popgdp;
import java.util.*;
import jcm.core.*;
import jcm.core.tls.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.ob.*;
import jcm.core.cur.*;
import jcm.core.par.*;
import jcm.mod.cli.*;
import jcm.mod.math.interp1D;
import jcm.mod.math.runAverage;
import static jcm.core.complexity.*;
import static jcm.core.report.*;

/*
 note: this module is for experiments with impacts formulae.
 you have to set complexity level to experimental to find it in the tree
 */

/*
 hints: in netbeans, use right-click over names of objects/classes in the code.
 goto source, fix imports, find usages and refactor are especially useful
 show javadoc should work for sun java classes, not yet for JCM classes (sorry)
 you can also click on lines in the error trace (output) to jump to the relevant source code
 */


public class SLRimpacts extends module {
    
    public curveset slrimpact_phz  =new curveset("slrimpact_phz" , "people at risk");
    public curveset slrimpact_pc   =new curveset("slrimpact_pc"  , "protection class");
    public curveset slrimpact_aapf =new curveset("slrimpact_aapf", "person&per&year");
    // public curveset slrimpact_tmp  =new curveset("slrimpact_tmp", "tmp counter"); // use this for experiments only
    
    public static String[] listadapt={"none","mini","average","full"};
    public static param typeadapt=new param("adaptmenu", listadapt, "none", simplest);
    
    
    /*
     note:    JCM will automatically find all modules and all public curvesets and params declared within modules,
     and make them available in the tree, with a package structure reflecting the java source file structure
     (but they may not be visible - depending on the chosen filters and complexity level)
     the static curveset will contain  the same data for all worlds
     curveset constructor has default assumptions - eg slrimpact_phz goes from 1750 to 2200
     */
    
    
    
    List<region> regset;
      /*
    read this as "List of regions" (an example of a generic collection - note List is in  java.util which is imported at the top)
    this regset will be a reference pointing to the list of regions currently chosen for "regional data"  - note precalc method
    note: future scenarios of GDP, population, emissions, LUC etc. are calculated only for these regions - to save time and memory
    to get a list of all the nations use instead regman.nations.reg
       */
    Map<region, Set<region>> subregs = new HashMap();
    /* this will be a map that contains a set of subregions, for each region  - see precalc */
    
    static int nslr;
    
    sealevel sealevel; popgdp socio; regset socreg;  //references to specific modules in the current world
    static float[][] ppm; // a reference to a two-dimensional array, that will remain available outside the loops
    static boolean reportederror=false; //used for debugging
    
    static String[] regnameslr;
    static String[] regnamejcm;
    static float[][] ppermeter;
    
    // static region[] slreg ;
    static Object[] slreg ;
    static int[][] redproslr    ;
    // static float[][] gdptopro     ;
    static int[]   isdeltaic    ;
    static float[] retuper;
    static interp1D[] gdptopro = new interp1D[2];
    static interp1D[] hiwatlev;
    static runAverage[] gdprunav;
    
    
    /*
     the initsetup method is only run once, as a world is initialised
     note this overwrites a general method of module, which netbeans should indicate with a little arrow in the margin
     */
    public void initsetup() {
	mycomplexity=experimental; //hide this module, unless user chooses experimental level
	sealevel=gm(sealevel.class); socreg=gm(regset.class); socio=gm(popgdp.class); //gets references to other modules from the world that contains this module
	follows(sealevel); //declares that this module is affected by sealevel module, and must also follow it in the calculation loop
	follows(socio); //ditto for socioeconomic data
	importdata(); //see new method below
    }
    
    /*
     precalc is run by jcm.core.loop before the timestep loop
     it's typically for calculations that are affected  by adjustable parameters, but should be outside the timestep loop
    note that these loop methods will only be run if  this module is both needed (for some visible output) and changed (due to parameter changes, or initial startup)
     this depends on the interactions - such as follows(sealevel) above
     */
    public void precalc() {
	regset=socreg.regions.chosen.reg; //socreg.regions is a reference to the parameter you can see in "regional emissions" in the tree
	socreg.clearoldregions(slrimpact_phz); //avoid accumulating data for old regions we don't want to see any more
	socreg.clearoldregions(slrimpact_pc) ; //avoid accumulating data for old regions we don't want to see any more
	socreg.clearoldregions(slrimpact_aapf) ; //avoid accumulating data for old regions we don't want to see any more
	// socreg.clearoldregions(slrimpact_tmp) ; //for experiments only
	
	for (int r=0; r<nslr; r++) 	{
	    
	    region sr=regman.allreg.find(regnamejcm[r]);
	    for (region rr : regset)
		if (rr.contains(sr)){ slreg[r]=rr; continue; }
	    if (slreg[r]==null) slreg[r]=regman.world;
	    // slreg[y]= regman.allreg.findo(regnamejcm[y]);
	    // if we use nations we miss some islands thus cannot use findo (would result in null regions)
	    gdprunav[r].reset();
	    
	}
//	subregs.clear();
//	for (region r : regset) { //read this as "for each region r in regset ... "
//	    Set<region> sr=r.subreg(peoplepermeter); //gets a list of subregions within r, that are also found in peoplepermeter
//	    if (sr==null) sr=Collections.emptySet(); //replace null by an empty set - to avoid problems later
//	    subregs.put(r, sr);
//	}
	reportederror=false;
    }
    
    
	/*
    calcstep is run by jcm.core.loop for each module, for each timestep. The current year is a static variable "year" shared by all modules
     this year is used automatically, if you don't specify the year for some curveset methods such as set or get.
	 */
    public void calcstep() {
	float locpop;
	float cdt;
	float cpd;
	float flolev;
	float pd, pop;
	
	
	String curadapt;
	float aapf, hmho,cnt;
	//deb("region no="+regnameslr.length);
	float popchg,result;
	int pcc;
	
	
	try {
	    //float slr=sealevel.total.get() - 0.115f ; //get global total slr for current year
	    // TEST - WARNING
	    float slr=sealevel.total.get() - 0.1f ;
	    // WARNING : high sensitivity to reference year !!!!
	    
	    curadapt= SLRimpacts.typeadapt.chosenname(); // get experimental "adaptation level"
	    float peopleatrisk, gdpfac, popfac, phz, ophz, curlev, rest, gdpcap; //declare here, outside loops, for efficiency
	    int ilow, pc, ipc;
	    region jcmR ;
	    
	    // for (region r : regset) { /
	    for (int ireg=0; ireg<nslr; ireg++) {
		slrimpact_phz.set(slreg[ireg], 0);
		slrimpact_pc.set(slreg[ireg], 0);
		slrimpact_aapf.set(slreg[ireg],0);
		// slrimpact_tmp.set(slreg[ireg],0); // use this for experiments
	    }
	    
	    popchg=0;
	    pc=0;
	    
	    // Restricting to a time interval accelerates the computation
	    if (year>1950 && year<2200) {
		
		for (int ireg=0; ireg<nslr; ireg++) {
		    // JCM region containing current slr region :
		    jcmR = (region) slreg[ireg];
		    
		    // High water level, using 1000 Y (pc 3) return period
		    curlev = hiwatlev[ireg].getLin(3)+slr;
		    
		    // "People in the Hazard Zone" (= at risk if no protection at all)
		    // -> linear interpolation from the table
		    ilow = (int)Math.floor(curlev);
		    rest = curlev - (float)ilow ;
		    if (ilow>=0) {
			phz = (1.0f-rest)*ppermeter[ireg][ilow] + rest*ppermeter[ireg][ilow+1];
		    } else phz = ppermeter[ireg][0] ;
		    // add phz in this region to previously computed phz in other parts of the region :
		    ophz=slrimpact_phz.get(jcmR); // old PHZ is stored for later use (see below)
		    slrimpact_phz.set(jcmR, ophz+phz);
		    
		    // Protection class estimation
		    // ---------------------------
		    
		    // GDP/cap in $ (rough estimation from JCM soc module - to be improved)
		    // with quick fix for French Guyana & Palestine that my have 0 pop !
		    
		    /*
		     NOTE! for the moment only gdp_mer continues after 2100, so we have to use that
		     switiching to gdp_ppp would be better, as soon as it is available.
		     */
		    
		    
		    locpop = socio.pop.get(jcmR);
		    //old:  if (locpop > 0f) gdpcap = socio.gdp_mer.get(jcmR) / locpop *1000f ; else gdpcap=1000f;
		    if (locpop > 0f) gdpcap = socio.gdp_mer.get(jcmR) / locpop ; else gdpcap=1f;
		    
		    // Get running average over ... years (see creation of gdprunav below)
		    gdpcap=gdprunav[ireg].average(gdpcap);
		    
		    // "Protection degree" based on GDP only
		    // Note : we decided to make the interp linear in "prot degree",
		    // which means that it is also approx linear in high water level associated with flooding
		    // (and thus not linear in return period). Doc to be written about this ! (see .xls file)
		    pd=gdptopro[isdeltaic[ireg]].getLin(gdpcap);
		    
		    // temporary test with "extended adaptation with same rules as now, no real account for SLR"
		    // this is a very basic "experiment", results are interesting but do not say much about
		    // real adaptation, it is an unrealistic use of the level(T) curves (extrapolation for T>1000)
		    // (the standard Nicholls 2004 did not allow pc>3)
		    if (curadapt.equals("none")) pd= Math.min(3f,pd); else pd= Math.min(10f,pd);
		    
		    //Minimal sea level associated with flooding, interpolated from the GVA table,
		    // knowing that T = 10^pd (T=return period, and T=10 for pd=1)
		    // SLR is immediately included, reducting protection
		    flolev=hiwatlev[ireg].getLin(pd)-slr;
		    // Get back return period of flooding, now including SLR :
		    pd=hiwatlev[ireg].getInvLin(flolev);
		    
		    // we need a minimum protection (people would move or adapt)
		    //* WARNING level not defined seriously now - it is 2 years.
		    pd=Math.max(0.3f,pd);
		    //* WARNING : discuss this minimum protection level "in all circumstances"
		    
		    // update curveset of protection degree : use  "PHZ-weighted" averaging over SLR regions
		    if (phz > 0f) slrimpact_pc.set(jcmR, ((slrimpact_pc.get(jcmR)*ophz)+pd*phz)/(phz+ophz));
		    
		    // pop change from base year
		    if (socio.pop.get(jcmR,2000) > 0f) popchg = socio.pop.get(jcmR)/socio.pop.get(jcmR,2000);
		    
		    // "Annual Average People Flooded" (= at flooding probability x #people)
		    // ----------------------------------------------------------------------
		    
		    aapf=0f;
		    float step=0.1f;
		    float hstep=step/2f;
		    for (cpd=pd+hstep; cpd<3f; cpd+=step) {
			
			curlev = hiwatlev[ireg].getLin(cpd)+slr; // ! should we still add slr when PC will be updated / slr ?
			
			// -> linear interpolation from the table
			ilow = (int)Math.floor(curlev);
			rest = curlev - (float)ilow ;
			if (ilow>=0) {
			    phz = (1.0f-rest)*ppermeter[ireg][ilow] + rest*ppermeter[ireg][ilow+1];
			} else phz = ppermeter[ireg][0] ;
			
			cdt=(float)(Math.pow(10f,cpd+hstep)-Math.pow(10f,cpd-hstep));
			aapf=aapf+cdt*popchg*phz/(float)(Math.pow(Math.pow(10f,cpd),2f));
			
		    }
		    slrimpact_aapf.set(jcmR,slrimpact_aapf.get(jcmR)+aapf);
		    
		    
		}
	    }
	    
	    
	    
  /*
 // This is probably the right approach, but would need to have SLR region as kind of "sub-lists" of "JCM sub-regions" ?
  // (so that we have 3 imbricated loops : regset, subregs, then SLR regs -> we loop on SLR regs as above BUT while
  // knowing the bigger JCM region we are in
   
	    for (region r : regset) { // for each big region
		peopleatrisk=0;
		for (region rr : subregs.get(r)) { //for each subregion
		    for (int m=0; m<=12; m++) { //for each meter
			if (m<slr*eef) peopleatrisk+=peoplepermeter.get(rr, m+2000) ;
		    }
		}
   
		gdpfac=(socio.pop.get(r)>0 && socio.gdp.get(r)>0) ?  (float)Math.pow(socio.pop.get(r) / socio.gdp.get(r), gef ) : 1f;
		popfac=(socio.pop.get(r, 2000)>0 && socio.pop.get(r) >0) ? socio.pop.get(r) / socio.pop.get(r, 2000) : 1f;
		peopleatrisk *= gdpfac * popfac;
   
	     value -999 = no data; thus >0 means some data
	     gdpfac adjust according to gdp per capita,  popfac adjusts for population change
	     note units declared in socio code: pop is in mega-people, gdp in giga-dollars => if >1000$/cap the ratio is <1
	     note these facs apply to the big regions r, not to each rr: this is because JCM only calculates gdp and pop for those big regions - we could reconsider this
	     note gdp data only starts in 1970 (to be fixed)
	     try adjusting the gdpexpfac to see the effect of this
	     try also different SRES scenarios
   
		slrimpact_phz.set(r, peopleatrisk);
	    }
   */
	    
	} catch (Exception e) { if (!reportederror) e.printStackTrace(); reportederror=true; }
	/*
	 Usually, exceptions inside calcstep are caught by jcm.core.loop , to let JCM continue with the rest of the model.
	 In this case, we report extra information, but avoid printing the trace for every error (would get very slow if inner loop)
	 */
	
    } //calcstep
    
    /*
     postcalc is run by jcm.core.loop after the timestep loop, but before plotting
     typically used for normalising something over time
     */
    public void postcalc() {
	
    }
    
    
    /*
    new method importdata
    note this is static, since this data is the same for all worlds, regardless of scenario etc.
     */
    
    static void importdata() {
	
	
	//histdata.loaddata(peoplepermeter, "slr_popcntry.csv", "\t", false, 1f, 2000, 2012, 2000);
	/*
	 histdata.loaddata is convenient for importing data files of regional timeseries
	 it assumes the file is in (jcm root folder)/source/data
	 be careful to clean-and-build after changing such a data file - this will incorporate it into dist/JCM.jar from which the model is run
	 in netbeans, be careful to paste in tabs, rather than typing with a tab key which are written as spaces
	 
	 histdata.loaddata will search for matching JCM regions, and report  those it doesn't find, which could be mapped to existing regions by adding to data/countrynames.csv
	 (note: in older version of histdata code the line that reports missing regions may be commented - just remove the // and recompile)
	 
	 countrynames.csv also acts to combine data for some small regions - eg monaco is added to france, liechtenstein to switzerland...
	 it also groups the small islands together (4 sets atlantic, pacific, indian, carribean)
	 In principle, such aggregation should only be made at a later stage, *after* we calcuated the people at risk.
	 However, at the moment population, GDP and emissions data is already aggregated for these small islands -to save memory and makes plots clearer
	 I suggest to work with the existing regions for now, and fix this problem later.
	 */
	
	/*
	 the method below is a simpler alternative, just filling the array of floats
	 note in this case, you have to specify to look in the data folder
	 note java arrays start at 0!
	 -
	 Last issue is to link ("map") region of countries from the GVA that does not have a JCM equivalent.
	 This code needs to have a loop on the GVA regions, extracting people at risk for each country.
	 */
	
	String[][] data=fileio.loadtab("data/slr_popcntry.csv", "\t");
	nslr = data.length-3;
	float hwl[]=new float [4];
	float prd[]=new float[]{0,1,2,3}; // because here we cover T= 1,10,100,1000
	
	regnamejcm= new String[nslr];
	regnameslr= new String[nslr];
	ppermeter = new float[nslr][13];
	hiwatlev  = new interp1D[nslr];
	isdeltaic = new int [nslr];
	slreg     = new region [nslr];
	gdprunav  = new runAverage[nslr];
	
	for (int r=0; r<nslr; r++) 	{
	    // #elements for GDP running average :
	    gdprunav[r]=new runAverage(30);
	    regnamejcm[r]=data[r+3][0];
	    regnameslr[r]=data[r+3][1];
	    isdeltaic[r] =(int)Float.parseFloat(data[r+3][2]);
	    for (int x=0; x<13; x++) ppermeter[r][x]=Float.parseFloat(data[r+3][x+3]);
	    for (int x=0; x<4 ; x++) hwl[x]=Float.parseFloat(data[r+3][x+16]);
	    hiwatlev[r]= new interp1D(prd,hwl);
	}
	
	// Temporary test : creation of an higher protection class for high GDP/cap,
	// as a kind of "quick & dirty" implementation of "adaptation to SLR"
	
	redproslr = new int   [][]{{0,1,2,3,3},{0,0,1,2,3},{0,0,0,1,2}, {0,0,0,0,1}, {0,0,0,0,0}};
	
	float gdptp_nod[]=new float[]{0, 300, 600, 2400, 6000};
	float gdptp_del[]=new float[]{0, 1200, 2400, 5000, 9000};
	float prodegs[]=new float[]{1f,1f,1.5f,2.5f,3.5f}; // This provides prot classes equiv to the thresold from Nic04
	// we use 1f rather than 0.5f as prot clas for 0$ ( Nic never goes below 1 so ?)
	// the added "class" (not really a class but a data point) makes values around PC 2 match those from Nic04
	gdptopro[0]= new interp1D(gdptp_nod,prodegs);
	gdptopro[1]= new interp1D(gdptp_del,prodegs);
	retuper   = new float []{10,100,1000,1000};
	
    }
    
} //end class
