package jcm.mod.regemit;

import jcm.mod.obj.globco2emit;
import java.util.List;
import jcm.mod.socio.popgdp;
import jcm.core.cur.*;
import jcm.core.data.interpolator;
import jcm.indata.matchdataOld;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.*;
import jcm.mod.ogas.othgasemit;
import jcm.mod.obj.regset;
import jcm.mod.obj.sresext;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.mod.obj.sresdata.*;
import static jcm.mod.regemit.histemitdata.*;

public class emitbase extends module { //
    // ********* CURVES ******************
    public curveset //
            emitfosbase = new curveset("emitfosbase", "mega&ton&carbon"), //
             emitlucbase = new curveset("emitlucbase", "mega&ton&carbon"), //
             emitch4base = new curveset("emitch4base", "mega&ton&CH4"), //
             emitn2obase = new curveset("emitn2obase", "mega&ton&N"); //
//
    // *********** SETUP ******************

    public void initsetup() {

        history.setaffectedby(gm(regset.class).regions);

        history.follows(gm(CalcLucEmit.class));
        //P2 reconsider inverse carbon feedback affects history: inefficient because we don't need to recalc *regional* LUC if only exploring the global feedbacks
        history.setaffectedby(gm(carboncycle.class), gm(CalcLucEmit.class).lucsource.chosen.equals("Inverse") || gm(CalcLucEmit.class).lucsource.chosen.equals("Houghton"));

        future.follows(history);
        future.setaffectedby(gm(controller.class).scenario);
        future.follows(gm(AviaShipEmit.class).emitbase);
        //note history also needs bunker set before calctot - but aviaemit history is run in initsetup
        follows(future);
        //futluc and sresext affect the curvesets but not the future method
        setaffectedby(gm(futureLUC.class).base);
        setaffectedby(gm(sresext.class));


        emitfosbase.addOb(new curvar(curve.Type.ratio, emitfosbase, gm(popgdp.class).pop, emitlucbase));
    // emitfosbase.addAction(showpan.pan("percap histogram", histoplot.class, new qtset[]{emitfosbase, pop, emitlucbase }));
    //    
    }    //
    //============== ref variables ============================
    region regset;
    //==========================================
    /* History and Future are separate loopcalcs to enable 
    different interactions (don't always need to recalc history if change future) 
    and different calculation order in loop: bottom-up history and top-down future
     * */
    // *********** HISTORY ************
    public loopcalc history = new loopcalc("emitbase-history") {
        public void precalc() {

            regset = (region) gm(regset.class).regions.chosen;
            List<region> reg = regset.reg;

            gm(regset.class).clearoldregions(this);
            for (region r : reg) emitfosbase.getOrAddCurve(r); // necessary so that shares emitfosabate works ... check still ok now in sep precalc

            interpolator.fillregdata(fosCO2, emitfosbase, regset, 0.001f);
            fillhistluc();
            fillhistch4n2o();

            emitfosbase.getOrAddCurve("bunker").color = grey;


        } //end precalc
        //======= CALCSTEP ========

        public void calcstep() {

            if (year < fsyfos) {
                float bunker = year > 1900 ? gm(AviaShipEmit.class).seb.get(AviaShipEmit.sec.tot_int) : 0;
                emitfosbase.set("bunker", bunker);
                gm(globco2emit.class).fossil.set(emitfosbase.calctot());
            }

            if (year < fsyog) {
                emitch4base.calctot();
                emitn2obase.calctot();
            }

        } //end calcstep
    }; // end history
    //
    //
    // *********** FUTURE ************
    public loopcalc future = new loopcalc("emitbase-future") {
        public void precalc() {

            regset = (region) gm(regset.class).regions.chosen;
            controller co = gm(controller.class);

            new interpolator(sres_image_fos.get(co.scemit), 1000f).fill(emitfosbase, regset, fsyfos, 2100, histemitdata.fosCO2, (float) gm(globco2emit.class).fosconv.getval());
            //note also top-downscaling in globco2emit, which includes correction to original sres and subtraction of bunker, also emitfosbase calctot 

            /* P3 Note EPA data is available for most countries until 2020 - could shift beginning of SRES to then, with some kind of convergence 
             * note also othgasemit - which uses just a global dataset - is there any topdownscaling to ensure consistency?
             * alternatively - could use IMAGE data (& ditto for LUC)??
             * see also todo note in history.java
             */
            new interpolator(sresdata.sres4ch4, "SRES4", 1990, 10, co.scre, 1f).fill(emitch4base, regset, 2001, 2100, histemitdata.epaCH4, 2020);
            new interpolator(sresdata.sres4n2o, "SRES4", 1990, 10, co.scre, 1f).fill(emitn2obase, regset, 2001, 2100, histemitdata.epaN2O, 2020);
        }

        public void calcstep() {
            emitch4base.calctot();
            emitn2obase.calctot();
        }
    }; //end future

    //
    //********** LUC ********************
    void fillhistluc() {
        //note: these methods are here rather than in CalcLucEmit, because they change with the socio regionset
        //note todo in regemit.todo re mixing sources of LUC data
        CalcLucEmit cle = gm(CalcLucEmit.class);

        if (cle.lucsource.chosen.equals("Houghton")) {
            float scalefactor = (float) gm(CalcLucEmit.class).landuseemit1990.getval() / 2158.09f;
            new interpolator(LUCdata.lucCO2Houghton, 1950, 1f, scalefactor).fill(emitlucbase, regset, 1750, 2000, LUCdata.lucCO2CAIT);
        }
        if (cle.lucsource.chosen.equals("EDGAR")) interpolator.fillregdata(LUCdata.edgarluc, emitlucbase, regset, 1f);
        if (cle.lucsource.chosen.equals("IVIGmodel"))
            interpolator.fillregdata(gm(CalcLucEmit.class).lucemit, emitlucbase, regset, 0.001f);
        if (cle.LULUCF_UNFCCC_on.istrue())
            interpolator.fillregdata(LUCdata.lucCO2UNFCCC, emitlucbase, regset, 1f);
    /*
    if (lucsource.chosen.equals("MATCH"))
    new interpolator(matchdata.matchco2luc, 1890, 1).fill(emitluc, regset, 1890, 2000, histdata.lucCO2IVIG);
    if (lucsource.chosen.equals("IVIGdata")) interpolator.fillregdata(get(CalcLucEmit.class).lucCO2IVIG, emitluc, regset, 0.001f);
    } else if (year<=2002) { lucf.set(0); for (qt q : histdata.lucCO2.map.values()) lucf.set(lucf.get()+q.get()/1000f); }
     */
    }//luc


    //**************** CH4, N2O *******************
    void fillhistch4n2o() {
        //Note EH CH4 in Tg CH4, N2O in TgN
        //see todo in regemit.todo re interpolator errors - EPA is insufficient source for weighting    

        new interpolator(matchdataOld.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true).fill(emitch4base, regset, 1890, 1970, epaCH4);
        new interpolator(matchdataOld.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true).fill(emitch4base, regset, 1971, 2000, epaCH4);
        for (int y = 1890; y < 2000; y++) gm(othgasemit.class).ch4emit.set(y, emitch4base.calctot(y));

        new interpolator(matchdataOld.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true).fill(emitn2obase, regset, 1890, 1970, epaN2O);
        new interpolator(matchdataOld.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true).fill(emitn2obase, regset, 1971, 2000, epaN2O);
        for (int y = 1890; y < 2000; y++) gm(othgasemit.class).n2oemit.set(y, emitn2obase.calctot(y));

    } //ch4n2o
} // end class





