package jcm.mod.ogas;

import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;

import jcm.mod.obj.sresdata;
import jcm.core.reg.region;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;

public class othgasemit extends module  {
    
    //*******************************************************
    //INTERACTIONS
    public void setinteractions() {
        follows(gm(emitbase.class).history);
	setaffectedby(gm(controller.class).scenario, emitoption.chosen=="sresfix" || emitoption.chosen=="sresscale");
	follows(gm(globco2emit.class), emitoption.chosen=="2000scale" || emitoption.chosen=="sresscale");
    }
    
    //*******************************************************
    //PARAMETERS
    //note: donothing added for attribution experiments
    String[] emitoptions={	"sresfix", "sresscale", "2000fix", "2000scale", "donothing"};
    complexity[] emitcomplex={ normal, normal, normal, normal, experimental};
    
    public param
	    emitoption=new param("othgasemitoptions", emitoptions, "sresscale", emitcomplex),
	    addpermafrost=new param("addpermafrost", false, experimental);
    
    
    //*******************************************************
    //PLOTARRAYS
    public curve
	    ch4emit=new curve( "ch4" , green, simplest ),
	    n2oemit=new curve( "n2o" , brown),
	    soxemit=new curve( "sox" ,  blue, simplest ),
	    coemit=new curve(  "co" , dkgrey ),
	    vocemit=new curve( "voc" ,  yellowgreen ),
	    noxemit=new curve(  "nox",  orange);
    
    public curveset emitcurves=new curveset( 	ch4emit, n2oemit, soxemit, coemit, vocemit, noxemit, "othgasemitcurves", "tera&gram&per&yr");
    
    
    //*******************************************************
    //LOOP CALCS
    
    public void initsetup() {
	/*
         initsetep must come after loaddata
	//ch4emit, coemit, soxemit filled by loaddata
	//adjust methane to match sres at 2000
	//NOTE: CH4 and N2O data  now overwritten by the sum from EDGAR from 1890 to 2000 -see history module
        */
	for (int y=1860; y<2001; y++) ch4emit.set(y, ch4emit.get(y)* 323f / 380f);
	//fill 1750-1860
	for (int y=1750; y<1860; y++) ch4emit.set(y, ch4emit.get(1860) * (y-1750) / 110f);
	//adjust soxemit to match sres at 1990 (70.9) and connect linearly to 2000 (69.0)
	for (int y=0; y<1991; y++) soxemit.set(y, soxemit.get(y)*70.9f/soxemit.get(1990));
	for (int y=1991; y<2001; y++) soxemit.set(y, ((y-1990)*69.0f+(2000-y)*soxemit.get(1990))/10f);
	histnoxvoc();
	super.initsetup();
    }
    
    public void precalc() { scaleis92a();    }
    //note histn2o in atchem
    
    public void calcstep() {
	/* 
        P3 scaling sres starts in 2000 - it should start in fsyog, ie when the (updated) data finishes 
         * in principle we have ch4 and n2O data from EPA until 2020 - could use this instead of SRES?
	P3 reCHECK interactions  with "donothing" othgasemit option
         */
         if ( !emitoption.chosen.equals("donothing") &&  year>=2000) scalesresemit();
	
	//scaling N2O emissions prior to 1890 - do we still need this old fix for edgar?
	if (((region) (gm(regset.class).regions.chosen)).name.equals("EDGAR") && year==1890)  {
	    float emit1890=gm(emitbase.class).emitn2obase.calctot();
	    for (int y=1750; y<=1890; y++)  n2oemit.set(y, emit1890*((float)(y-1750) / (float)(1890-1750)));
	}
	//experiment, add emissions from melting permafrost, apparently 700Gt on average over next century, note not yet any feedback from temperature
	if (addpermafrost.istrue() && year>fsyog) { 
	    float extrach4=700f*(16f/12f)*(year-2000)/50f; 
	    ch4emit.set(ch4emit.get()+extrach4); 
	}
	
    }
    
    //*******************************************************
    //EMISSIONS
    //(future only)
    
    float scale, oldscale; float[] scgas=new float[6];
    
    //P2 note othgasemit scaleis92a is never used since IS92A no longer in the scenario menu - can't get index==6
    //scale is92a to same 2000 values as SRES to match TAR calculations
    float[][][] scgasdata={	sresdata.soxemit, sresdata.ch4emit, sresdata.n2oemit, sresdata.coemit, sresdata.vocemit, sresdata.noxemit};
    void scaleis92a() {	for (int i=0; i<6; i++) {
	if (gm(controller.class).sci==6) scgas[i]=(float)(scgasdata[i][0][0]/scgasdata[i][6][0]);
	else scgas[i]=1f;
    }}
    
    void scalesresemit() {
	//scale to CO2 - note use fossil CO2 emissions not total (inc landuse)
	scale =1f;
	int sc=gm(controller.class).sci;
        //note: if <fsyfos (even if >fsyog) scale factor should be 1, fossilbase doesn't start before fsyfos!
	if (year>=fsyfos && emitoption.chosen=="sresscale") scale=gm(carboncycle.class).fossil.get(year)/gm(globco2emit.class).fossilbase.get(); //(1000f*sres.interp(sres.fosemit, sc, year)
	if (year>2000 && emitoption.chosen=="2000scale" ) scale=gm(carboncycle.class).fossil.get(year)/gm(carboncycle.class).fossil.get(2000);
	if (scale>oldscale && year>2100) scale=oldscale; //prevent increase after 2100
        else oldscale=scale;
        
	int year1= (emitoption.chosen=="2000fix" ||  emitoption.chosen=="2000scale")  ? 2000 : year;
	
	soxemit.set(year, sresdata.interp(sresdata.soxemit, sc, year1)*scale*scgas[0]);
	ch4emit.set(year, sresdata.interp(sresdata.ch4emit, sc, year1)*scale); //*scgas[1]; //scgas doesn't help for CH4 is92a!
	n2oemit.set(year, sresdata.interp(sresdata.n2oemit, sc, year1)*scale*scgas[2]);
	coemit.set(year, sresdata.interp(sresdata.coemit, sc, year1)*scale*scgas[3]);
	vocemit.set(year, sresdata.interp(sresdata.vocemit, sc, year1)*scale*scgas[4]);
	noxemit.set(year, sresdata.interp(sresdata.noxemit, sc,  year1)*scale*scgas[5]);
	
	//hfcs -note cfcs constant
	//interpolation unnecessarily complicated as only use in 5-yr intervals?
	int schfc=(sc<3 ? 0 : sc<7 ? sc-2 : 2); //all A1 same, for TGCIA450 use B1
	int yeara=year+5, yearb=((emitoption.chosen=="sresfix" ||  emitoption.chosen=="sresscale") ? yeara : 2000);
	if ((yeara%5)==0 && yeara>1930 && yeara<=gey)
	    for (int g=0; g<12; g++) {
	    gm(fgas.class).fgemit[g].set(yeara,  (sc==6 && (g<4 || g>6)) ?  0 :  interpolator.interphfc(sresdata.hfcemit, g, schfc, yearb)*scale);
	    //note is92a only has data for 3 gases
	    }
    }
    
    //calculate historical nox & voc by scaling to CO, only for plot not further calculations
    
    void histnoxvoc() {
	noxemit.set(2000, sresdata.interp(sresdata.noxemit, 0, 2000));
	vocemit.set(2000, sresdata.interp(sresdata.vocemit, 0, 2000));
	for (int year=1750; year<2000; year++) {
	    noxemit.set(year, noxemit.get(2000)*coemit.get(year)/coemit.get(2000));
	    vocemit.set(year, vocemit.get(2000)*coemit.get(year)/coemit.get(2000));
	}}
    
} //end class
