//**************** SRES EXTENSON ****************
/** extension of SRES beyond 2100 for population, gdp, fossil-CO2
 */

package jcm.mod.obj;

import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.mod.socio.popgdp;
import java.util.HashMap;
import java.util.Map;
import jcm.core.par.param;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.mod.obj.controller;
import jcm.mod.regemit.AviaShipEmit;
import static jcm.core.complexity.*;
import static jcm.mod.obj.sresdata.*;

public class sresext extends module {
    
    public param extend=new param("extend", new String[] {	"fixed-ext", "linear-ext", "exp-const", "exp-reg"}, "exp-reg", expert);
    
    //references
    curveset pop, gdp, efb;
    region regset;
    int sci;
    
    //factors for trends
    Map<region, Float> popfac=new HashMap(), gpcfac=new HashMap(), epgfac=new HashMap();
    
    
    public void initsetup() {
        popgdp socio=gm(popgdp.class); 
        pop=socio.pop; gdp=socio.gdp_ppp;
        emitbase eb=gm(emitbase.class);
         efb=gm(emitbase.class).emitfosbase;
        follows(socio.future);
        follows(eb.future); // which also follows aviation emitbase
        
        //note also affected by scaling in globco2emit - but that shouldn't change unless futbasescen or aviaship does - and doesn't apply in same year so no order problem
        
       
    }
    
    public void precalc() {
        //P2 be careful using index - as scenario now uses enum, order may change
        sci=gm(controller.class).scenario.getchosenindex();
        regset=(region) gm(regset.class).regions.chosen;
    }
    
    
    public void calcstep() {
        if (year>2100) {
            for (region r : regset.reg)  {
                pop.select(r); gdp.select(r); efb.select(r);
                String ext=(String)extend.chosen;
                
                //calculate rates of change at end of SRES - store in facs
                if (year==2101) {
                    if (ext.equals("linear-ext")) {
                        popfac.put(r, (pop.get(2100) - pop.get(2090))/10f);
                        gpcfac.put(r, ((gdp.get(2100)/pop.get(2100)) - (gdp.get(2090)/pop.get(2090)) )/10f);
                        epgfac.put(r, ((efb.get(2100)/gdp.get(2100)) - (efb.get(2090)/gdp.get(2090)) )/10f);
                    }
                    if (ext.equals("exp-const") || ext.equals("exp-reg")  ){
                        popfac.put(r, pop.get(2100) / pop.get(2099));
                        gpcfac.put(r, (gdp.get(2100)/pop.get(2100)) / (gdp.get(2099)/pop.get(2099)));
                        epgfac.put(r, (efb.get(2100)/gdp.get(2100)) / (efb.get(2099)/gdp.get(2099)));
                    }
                }
                
                if (ext.equals("fixed-ext")) {	//could replace this with linear and facs set to zero
                    pop.set(pop.get(year-1));
                    gdp.set(gdp.get(year-1));
                    efb.set(efb.get(year-1));
                }
                
                if (ext.equals("linear-ext")) {
                    pop.set(pop.get(year-1)+popfac.get(r));
                    gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1)+gpcfac.get(r)));
                    efb.set(gdp.get()*(efb.get(year-1)/gdp.get(year-1)+epgfac.get(r)));
                }
                
                if (ext.equals("exp-const") || ext.equals("exp-reg")  ){
                    pop.set(pop.get(year-1)*popfac.get(r));
                    gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1))* gpcfac.get(r));
                    efb.set(gdp.get()*(efb.get(year-1)/gdp.get(year-1))*epgfac.get(r));
                }
                
                if (ext.equals("exp-reg") ){
                    float gpc=0.00092f*gdp.get()/pop.get(); //0.00092 as reg facs were calculated for 1995 giga$ instead of 2000 mega$
                    popfac.put(r, (1f-sfpop)*popfac.get(r)+ sfpop*(popreg1-popreg2*(float)Math.log(gpc)));
                    gpcfac.put(r,  (1f-sfgpc)*gpcfac.get(r)+ sfgpc*(1f+gpcgrow0[sci]*(float)Math.exp(-gpc*gpcgrowk[sci])));
                    epgfac.put(r, (1f-sfepg)*epgfac.get(r)+ sfepg*(1f+epggrow0[sci]*(float)Math.exp(-gpc*epggrowk[sci])));
                }
            } //reg
            
            pop.calctot(); gdp.calctot();
            efb.calctot(); // note global set in globco2emit which follows this
        } //>2100
        
        
    } //sresext calcstep
    
       //OLD - regressions based on 2045-2095 (all 12 JCM regions together), for six scenarios A1B, T, F, A2, B1, B2
    
    
    static final float[] gpcgrow0={	0.075f, 0.075f, 0.075f, 0.030f, 0.064f, 0.030f }; //growth in gdp/cap (frac) if gdp/cap=0
    static final float[] gpcgrowk={	0.0143f, 0.0143f, 0.0143f, 0.0179f, 0.0255f, 0.0179f }; //exp decay rate of growth as function of 0.001*gdp/cap
    static final float[] epggrow0={	-0.033f, -0.037f, -0.025f, -0.018f, -0.042f, -0.018f }; //decline in emit/gdp (frac) if gdp/cap=0
    static final float[] epggrowk={	0.00606f, 0.00114f, 0.00916f, 0.0128f, 0.0110f, 0.00944f }; //exp decay rate of decline as function of 0.001*gdp/cap
    
    static final float popreg1=1.013f , popreg2=0.004f; //as gpcreg but for popn growth, based on B2 scenario only
//note: for other scenarios there is no clear correlation
//eventually should replace these with (convergence to) UN2300 scenarios - eg high for A2, mid for B2, low for A1+ ?
    
    static final float sfgpc=0.05f, sfepg=0.05f, sfpop=0.02f; // amount by which growth rates tend towards regression function each year
    
    //***************************************************
/*
 
 theory of exp reg is that  growth rate of  population, gdp-per-capita and emissions-per-gdp  converge slowly towards functions of gdp_ppp/capita
 these functions are derived from linear regression over original scenario data, 
 using data from all regions (i.e. its a global function, assuming some convergence)
 and from 2050-2100 (to avoid short-term effects)
 
 pf = 1+dp/p.dt
 pf =>  a + b.ln(g/p)
 use  to find a and b
 
 note: use original image data 2050-2100 (NOT interpolated to regset), as this is a global function
 BUT can't do that as don't have image data for GDP_PPP...! 
 */
    
    static Map<scen, Float> popa, popb;
    
    static void calcreg(scen sc) {
        float sumx=0, sumy=0, sumx2=0, sumxy=0, x, y, n;
        curveset p=sres_image_popn.get(sc);
        
        for (int year=2050; year<2100; year+=5) {
            for (Object r : p.map.keySet()) {
                
            }
        }
    }
    
 
    
    
}
