/*
A switching module, directing control to other modules according to main objective
 */
package jcm.mod.obj;

import jcm.core.*;
import jcm.core.par.param;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.obj.sresdata;
import static jcm.mod.obj.sresdata.*;
import static jcm.mod.obj.sresdata.scen.*;

public class controller extends module {
    //
    String[] objopt = {"nopolicy", "stabilisation", "optimisation"}; 
    complexity[] objcomp = {simplest, simplest, expert};
    public param objective = new param("objective", objopt, objcomp, "stabilisation", simplest);
    //
    public param<scen> scenario = new param("sresmenu", sresscen, scen.A1B, simplest) {
        public void precalc() {
            scen sc = scenario.chosen;
            sci = scenario.getchosenindex();
            scemit = sresscen.contains(sc) ? sc : sc == TGCIA450 ? B1 : A1B; //other eg IS92A uses A1B by default
            scre = scemit.ordinal();
            scpop = popscen.contains(sc) ? sc : A1;
            scgdp = gdpscen.contains(sc) ? sc : sc == TGCIA450 ? B1 : A1;
        }
    };    //scenario.setcomplexity("IS92a", expert); scenario.setcomplexity("CPI", expert); scenario.setcomplexity("TGCIA450", experimental );
    //used by socio, regemit and futureLUC - clearer to show them here
    public scen scemit,  scpop,  scgdp;
    public int sci,  scre;
} //end class


