/*
Future Regional Land Use Change Emissions
Separate from CalcLucEmit as different interactions
Also separate from globco2emit, since this is module is quite slow (can be rate-limiting step when changing many params in loop)

 */
package jcm.mod.luc;

import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.mod.carbon.*;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.sresdata;
import jcm.mod.obj.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.mod.regemit.shares;
import static jcm.core.report.*;

public class futureLUC extends module {    //
    //***************** CURVES ****************
    public curveset //these three curvsets are only needed for checking how it works, not needed for calc (output is in emitbase/shares)
            potlucregquotacurves = new curveset("regpotlucquota", "mega&ton&carbon", fsyluc, gey, expert), //
             potlucregbasecurves = new curveset("regpotlucbase", "mega&ton&carbon", fsyluc, gey, expert); //
    public static curveset lucscenario = new curveset("LUC SRES", "mega&ton&carbon", 2000, 2100, experimental); //
    //
    //*********************** WORKING VARIABLES ***********
    region regset, sresreg;
    interpolator sreslucinterpolator;
    CalcLucEmit cle;
    globco2emit gc;
    Map<region, Float> potlucregbase = new HashMap(), //
            srespotluc = new HashMap(), //
            srb4conv = new HashMap(), //
            srinitial = new HashMap(), //
            sreslucemit = new HashMap(), //
            potlucregquota = new HashMap(), //
            potlucregquota_init = new HashMap(), //
            potluchist = new HashMap(); //historical - for nations (moved from CLE)
    curve trend = new curve("trend"); //just used for storing internal data between base and quota loopcalcs
    Map<region, Map<region, Float>> weight = new HashMap();
    boolean nopolicy;
    float corrfac, fu;
    curveset emitlucbase, emitlucquota, histluc;
    //
    //******************** INTERACTIONS ************
    public void initsetup() {

        sresreg = regman.allreg.findreg("SRES4");
        cle = gm(CalcLucEmit.class);
        gc = gm(globco2emit.class);

        emitlucbase = gm(emitbase.class).emitlucbase;
        emitlucquota = gm(shares.class).emitlucquota;
        //affectsfutureonly = true;
        lucscenario.getOrAddCurve(regman.allreg.findreg("TOTAL")).type = curve.Type.total;

        history.follows(cle);
        history.setaffectedby(gm(regset.class).regions);
        base.follows(history);
        base.setaffectedby(gm(controller.class).scenario);
        //only recalc base following gc if params changed or lucfbase changed (due to sres or sresext or cle)
        base.setaffectedby(gc.lucconv, gc.potlucconvergence, gc.potlucfrac);
        base.setaffectedby(gm(sresext.class));
        quota.follows(base);
        quota.follows(gc);
    }    //
    //************* HISTORY ***********
    public loopcalc history = new loopcalc("futluc-setup") {
        public void precalc() {
            regset = gm(regset.class).regions.chosen;
            for (curveset qq : curvesets) gm(regset.class).clearoldregions(qq);
            histluc = cle.lucsource.chosen.equals("Houghton") ? LUCdata.lucCO2CAIT1 : cle.lucemit;
            fu = cle.lucsource.chosen.equals("Houghton") ? 1f : 1000f;
        }

        public void calcstep() {
            if (year < fsyluc) {
                for (region r : regset.reg) emitlucquota.set(r, emitlucbase.get(r));
                emitlucbase.calctot();
                emitlucquota.calctot();
            }
            if (year == fsyluc - 1) {
                //P2 check: put here for efficiency, but previously that didn't work with houghton=>ivig=>houghton?
                histpotluc();
                setupweights();
            }
        }
    };
    //************ BASE *********
    public loopcalc base = new loopcalc("futluc-base") {
        public void precalc() {
            sreslucinterpolator = new interpolator(sresdata.sres4luc, "SRES4", 1990, 10, gm(controller.class).scre, 1000f);
            nopolicy = gm(controller.class).objective.chosen.equals("nopolicy");
        }

        public void calcstep() {
            if (year == fsyluc - 1) initfut();
            if (year >= fsyluc) {
                for (region r : regset.reg) {
                    //potluc - add previous year 
                    potlucregbase.put(r, potlucregbase.get(r) + emitlucbase.get(r, year - 1) * gc.plf);
                    potlucregbasecurves.set(r, potlucregbase.get(r)); //for checking 
                    //regional emissions start at the potluc baseline then add
                    emitlucbase.set(r, potlucregbase.get(r));
                }

                //initialise sresluc to sum of nations from history for same regions
                float totsres4 = 0;
                for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
                        if (year <= 2100) {
                            lucscenario.set(sr, sreslucinterpolator.getdata(sr, year));
                            //follow trend of SRES and also converge the gap
                            sreslucemit.put(sr, (float) (lucscenario.get(sr) + (1f - gc.lucconv.getval() / 100f) * (sreslucemit.get(sr) - lucscenario.get(sr, year - 1))));
                        } else { // after 2100 - convergence towards the potluc
                            float convfac = (sreslucemit.get(sr) < srespotluc.get(sr)) ? 1f : (float) gc.potlucconvergence.getval() / 100f;
                            sreslucemit.put(sr, convfac * srespotluc.get(sr) + (1f - convfac) * sreslucemit.get(sr)); //convergence to potluc
                        }
                        totsres4 += sreslucemit.get(sr);
                    }

                //correction factor, to be consistent with globco2emit - if total very small, use same as previous year to avoid spike
                if (totsres4 > 10 || totsres4 < -10) corrfac = gc.lucfbase.get() / totsres4;
                //if (year<2010) deb("year="+year+" corrfac="+corrfac);

                //apply SRES4 using weights for each region
                for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
                        sreslucemit.put(sr, sreslucemit.get(sr) * corrfac);
                        srespotluc.put(sr, srespotluc.get(sr) + sreslucemit.get(sr) * gc.plf);
                        trend.set(year, (sreslucemit.get(sr) - srespotluc.get(sr)) / srinitial.get(sr));

                        //if (year<2010)  		    System.err.println("year="+year+" reg="+sr.name+" trend="+trend + " srinitial= "+srinitial.get(sr));

                        for (region r : regset.reg) { //note region loop inside 4region loop - potentially inefficient!
                            emitlucbase.set(r, emitlucbase.get(r) + weight.get(r).get(sr) * trend.get(year));
                        }
                    }
                emitlucbase.calctot();
            }
        }
    };//base
    //************ QUOTA *********
    public loopcalc quota = new loopcalc("futluc-quota") {
        public void calcstep() {
            if (year == fsyluc - 1) for (region r : regset.reg) potlucregquota.put(r, potlucregquota_init.get(r));

            if (year >= fsyluc) {
                for (region r : regset.reg) {
                    //potluc - add previous year 
                    potlucregquota.put(r, potlucregquota.get(r) + emitlucquota.get(r, year - 1) * gc.plf);
                    potlucregquotacurves.set(r, potlucregquota.get(r)); //for checking 
                    //regional emissions start at the potluc baseline then add
                    emitlucquota.set(r, potlucregquota.get(r));
                }
                //divisor and scaledown
                float divisor = (year <= fsyluc) ? (gc.lucquota.get(year - 1) - gc.potlucquota.get(year - 1)) : (gc.lucfbase.get(year - 1) - gc.potlucbase.get(year - 1));
                float scaledownquota = (gm(carboncycle.class).lucf.get(year - 1) - gc.potlucquota.get(year - 1)) / divisor; 	// based on previous year, because there is a feedback (luc=>fossil=>sd=>luc)
                if (year == fsyluc) scaledownquota = 1f;
                //if  (year==fsyluc) deb("futLUC scaledownquota from "+year+": " ); if (year<2008) deb("-"+scaledownquota);

                //apply SRES4 using weights for each region
                for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
                        for (region r : regset.reg) { //note region loop inside 4region loop - potentially inefficient!
                            emitlucquota.set(r, emitlucquota.get(r) + weight.get(r).get(sr) * scaledownquota * trend.get(year));
                        }
                    }
                emitlucquota.calctot();
            }
        }
    }; //quota

//********************** INITFUT  *********************
    void initfut() {
        //set up initial emissions and potential emissions
        for (region sr : sresreg.reg) {
            Set<region> srsubnat = sr.subreg(regman.nations);
            srespotluc.put(sr, 0f);
            float srli = 0;
            for (region rr : srsubnat) {
                srespotluc.put(sr, srespotluc.get(sr) + potluchist.get(rr) * gc.plf);
                for (int i = -5; i < 0; i++) srli += histluc.get(rr, fsyluc + i) / (fu * 5f); //average over 5 previous years to smooth blips
            }
            sreslucemit.put(sr, srli);
            for (region rr : srsubnat) srinitial.put(sr, srli - srespotluc.get(sr));
        }

        for (region r : regset.reg) {
            potlucregbase.put(r, 0f);
            for (region rr : r.subreg(regman.nations)) potlucregbase.put(r, potlucregbase.get(r) + potluchist.get(rr) * gc.plf);
            potlucregquota_init.put(r, potlucregbase.get(r));
        }
    }
//********************** WEIGHTS  *********************
    void setupweights() {
        //calculate weights for small regions as frac of SRES regions
        for (region r : regset.reg) {
            weight.put(r, new HashMap<region, Float>());
            for (region sr : sresreg.reg) weight.get(r).put(sr, 0f);
            for (region rr : r.subreg(regman.nations)) {
                for (region sr : sresreg.reg) if (sr.contains(rr))
                        weight.get(r).put(sr, weight.get(r).get(sr) +
                                          histluc.get(rr, fsyluc - 1) / fu - potluchist.get(rr) * gc.plf);
            }
//	    for (region sr : sresreg.reg) System.err.println(""+r+" "+sr+" "+weight.get(r).get(sr));
        } //r
    }
//****************HIST POTLUC *********************
    /*
    this is slow because calculates for all nations  for all historical years
    first part was previously in CalcLucEmit for efficiency (only recalc if history changed) but moved here for clarity
    P2 maybe reconsider if using nations in histpotluc  is really necessary - seems to be needed for weights interpolating from SRES4
     */
    void histpotluc() {

        for (region r : regman.nations.reg) {
            potluchist.put(r, 0f);
            //fix the houghton/cait option
            if (cle.lucsource.chosen.equals("IVIGmodel")) for (int y = 1700; y < fsyluc; y++)
                    potluchist.put(r, potluchist.get(r) + cle.lucemit.get(r, y) / 1000f);
            if (cle.lucsource.chosen.equals("Houghton")) for (int y = 1850; y < fsyluc; y++)
                    potluchist.put(r, potluchist.get(r) + LUCdata.lucCO2CAIT1.get(r, y)); ///1000f
        }
    }
} //class


//*****************************************

/*
old convergence method
if (year>2100 ) {
//gradual convergence towards the potluc
//note NO MORE ADJUSTING OF GLOBAL TOTAL TO BE CONSISTENT WITH THIS! - implement in globco2emit
for (region r : regset.reg) {
fbase = emitlucbase.get(r, year-1) < potlucregbase.get(r) ? 1f : (float)gc.potlucconvergence.getval()/100f;
fquota = emitlucquota.get(r, year-1) < potlucregquota.get(r) ? 1f : (float)gc.potlucconvergence.getval()/100f;

if (potlucregbase.get(r)>0) emitlucbase.set(r,  fbase * potlucregbase.get(r) + (1f - fbase) * emitlucbase.get(r, year-1) );
else if (emitlucbase.get(r, year)<0) emitlucbase.set(r,0);

if (gc.fixedfrac.istrue() ) emitlucquota.set(r, emitlucquota.get(r, year-1)*get(carboncycle.class).lucf.get()/get(carboncycle.class).lucf.get(year-1));
else {
if (potlucregquota.get(r)>0) emitlucquota.set(r, fquota * potlucregquota.get(r) + (1f - fquota) * emitlucquota.get(r, year-1));
else if (emitlucquota.get(r, year)<0) emitlucquota.set(r,0);
}

potlucregbase.put(r, potlucregbase.get(r) + emitlucbase.get(r, year)*gc.plf);
potlucregquota.put(r, potlucregquota.get(r) + emitlucquota.get(r, year)*gc.plf);
}
} // post 2100
 *///*******************************
//old code ex futbasescen
//	new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 2003, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 1991, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 2002, 10, scre, 1000f).fill(emitluc, regset, startscenluc, 2100, CalcLucEmit.lucCO2IVIG);

