/**
Contains methods for managing the historical temperature data (adjusting base year, creating trend etc.)

 */
package jcm.mod.cli;

import jcm.core.cur.curve;
import jcm.core.ob.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.core.par.param;

public class histtemp extends module {// *********** CURVES **********
    static public int tdey = 2008; //temp data end year
    public static curve 
            proxytemp = new curve("tempproxy_Mann", ltgrey, 1750, 1991, expert),  
            tempdataGISS = new curve("tempdata_GISS", olive, 1880, tdey, simplest), 
            tempdataCRU = new curve("tempdata_CRU", dkgreen, 1850, tdey, simplest), 
            temptrend = new curve("temptrend", green, 1753, tdey - 3);
// ************ LOOP METHODS *********
    public void initsetup() {
        setaffectedby(glotemp.baseyear);
        setaffectedby(glotemp.baserange);
        filldata();
    }

    public void postcalc() {
        if (glotemp.baseyear.changed || glotemp.baserange.changed) {
            adjustbaseyear();
            histtemptrend();
        }
    } // ?? have to do at end because affects curve before baseyear too
    //*********** DATA *********************
    /**global average temperature anomaly (milli-degrees relative to 1961-1990),  from UEA-CRU 1850 to 2008, series HadCRU3Gl
     (see www.cru.uea.ac.uk/data/temperature, ref Brohan et al 2006,  Jones et al 1999) 
     */
    static short[] CRU_glotemp = {-447, -292, -294, -337, -307, -321, -406, -503, -513, -349, -372, -412, -540, -315, -516, -297, -303, -334, -291, -313, -302, -344, -255, -331, -397, -418, -403, -91, 23, -265, -260, -242, -246, -298, -381, -362, -275, -387, -337, -192, -431, -378, -484, -505, -444, -420, -211, -243, -432, -314, -223, -302, -431, -509, -554, -412, -329, -507, -559, -564, -548, -581, -491, -489, -305, -213, -434, -506, -388, -331, -314, -261, -381, -347, -360, -274, -162, -254, -255, -376, -165, -124, -155, -297, -159, -184, -152, -34, 9, -1, 18, 77, -31, -28, 120, -7, -205, -197, -204, -211, -309, -169, -74, -27, -251, -281, -349, -73, -10, -72, -123, -23, -21, 2, -295, -216, -147, -149, -159, -10, -67, -190, -56, 77, -213, -170, -254, 19, -63, 49, 77, 120, 11, 177, -21, -38, 29, 179, 180, 103, 254, 212, 61, 105, 171, 275, 137, 351, 546, 296, 270, 409, 464, 473, 447, 482, 422, 405, 324};
    
    /**
     global average temperature offset (milli-degrees relative to 1951-1980),  from NASA-GISS 1880 to 2008
     (see http://data.giss.nasa.gov/gistemp/, Hansen et al 1996)
     Note: difference in avg (61-90) -(51-80) = 0.069
     */
    static double[] GISS_glotemp= {    -0.25, -0.19, -0.22, -0.24, -0.30, -0.30, -0.25, -0.35, -0.26, -0.15, -0.37, -0.28, -0.32, -0.32, -0.33, -0.27, -0.17, -0.13, -0.25, -0.17, -0.10, -0.16, -0.27, -0.31, -0.34, -0.25, -0.20, -0.39, -0.34, -0.35, -0.33, -0.34, -0.34, -0.31, -0.15, -0.09, -0.30, -0.40, -0.32, -0.20, -0.19, -0.13, -0.24, -0.21, -0.21, -0.16, -0.01, -0.13, -0.11, -0.25, -0.07, -0.01, -0.06, -0.17, -0.05, -0.10, -0.03, 0.08, 0.12, 0.03, 0.05, 0.11, 0.04, 0.10, 0.20, 0.07, -0.04, 0.01, -0.04, -0.06, -0.15, -0.04, 0.03, 0.11, -0.10, -0.10, -0.17, 0.08, 0.08, 0.06, -0.01, 0.08, 0.04, 0.08, -0.21, -0.11, -0.03, 0, -0.04, 0.08, 0.03, -0.10, 0, 0.14, -0.08, -0.05, -0.16, 0.13, 0.02, 0.09, 0.18, 0.26, 0.05, 0.26, 0.09, 0.05, 0.13, 0.27, 0.31, 0.20, 0.38, 0.35, 0.12, 0.14, 0.24, 0.38, 0.30, 0.40, 0.57, 0.33, 0.33, 0.48, 0.56, 0.55, 0.48, 0.62, 0.55, 0.57, 0.44};

    /** proxy temperature data from 1750 to 1991 - from Mann et al 1998 (note: this needs updating) */
    
    static double[] proxy_data = {-0.5707, -0.47775, -0.42825, -0.2025, -0.40045, -0.3814, -0.46865, -0.1951, -0.16555, -0.2003, -0.13645, -0.16595, -0.12905, -0.1807, -0.2641, -0.1395, -0.0991, -0.14555, -0.1529, -0.4026, -0.26625, -0.1538, 0.01125, -0.0253, -0.1295, -0.03915, -0.05395, -0.41305, -0.3275, -0.278, -0.36055, -0.4821, -0.3974, -0.2797, -0.6002, -0.4517, -0.08865, -0.48555, -0.28145, -0.0748, -0.1746, -0.05045, -0.07435, -0.192, -0.18555, -0.27405, -0.25455, -0.40565, 0.0568, -0.1182, -0.25025, -0.29235, -0.3379, -0.2077, -0.30065, -0.3284, -0.33875, -0.0348, -0.24675, -0.37485, -0.4447, -0.3505, -0.38175, -0.6145, -0.5238, -0.4456, -0.65925, -0.44385, -0.35305, -0.2037, -0.3579, -0.5103, -0.22805, -0.2962, -0.268, -0.16205, -0.18335, -0.4886, -0.20335, -0.5099, -0.19805, -0.2641, -0.4165, -0.31135, -0.51595, -0.77645, -0.78605, -0.5993, -0.6162, -0.37175, -0.30055, -0.3266, -0.2059, -0.4651, -0.7027, -0.62015, -0.12215, -0.09865, -0.58365, -0.81775, -0.4812, 0.0829, 0.0825, -0.2745, -0.35135, -0.45905, -0.50295, -0.48775, -0.26845, -0.1503, -0.34045, -0.2815, -0.33395, -0.1694, -0.2506, -0.1021, -0.48115, -0.28275, -0.30405, -0.3431, -0.34875, -0.15075, -0.35525, -0.23325, -0.3123, -0.2233, -0.26885, 0.00125, -0.14855, -0.57585, -0.54065, -0.3279, -0.4547, -0.31965, -0.4443, -0.22845, -0.14205, -0.1651, -0.2059, -0.06475, -0.182, -0.4582, -0.42995, -0.08695, -0.04825, -0.17895, -0.4052, -0.4087, -0.3158, -0.8625, -0.31015, -0.21375, -0.23715, -0.403, -0.3931, -0.1912, -0.3757, -0.63145, -0.11255, -0.46345, -0.3375, -0.10435, -0.29795, -0.3006, -0.3479, -0.21895, -0.22635, -0.3045, -0.2389, 0.17625, -0.08305, -0.1938, -0.2055, -0.21335, -0.28065, -0.1651, -0.1408, -0.1881, -0.15035, -0.22725, -0.0518, -0.1356, -0.21595, -0.1486, -0.1187, -0.1252, 0.1432, -0.0101, -0.12215, 0.0242, -0.1165, -0.12775, -0.0453, -0.05005, -0.0027, 0.0242, -0.19295, -0.0648, -0.23805, -0.0496, -0.11395, -0.04175, -0.04655, 0.1306, -0.21935, 0.04245, 0.0251, 0.13015, -0.0622, 0.0242, 0.2461, 0.10585, -0.2589, -0.11515, -0.2459, -0.0882, -0.2181, -0.03095, -0.14205, 0.14365, -0.0179, 0.0438, -0.06825, 0.18535, 0.1228, 0.02205, 0.1028, -0.1217, -0.1464, 0.0169, -0.2029, -0.09565, -0.0244, 0.24485, 0.07675, -0.0635, -0.03175, -0.0639, 0.23005, 0.35035, 0.17925, 0.12495};

    static void filldata() {
        for (int y = 1850; y <= tdey; y++)  tempdataCRU.set(y, CRU_glotemp[y - 1850] / 1000f);
        //the -0.069 is not normalise to 1961-90 avg
         for (int y = 1880; y <= tdey; y++) tempdataGISS.set(y, (float)GISS_glotemp[y-1880]-0.069f);
        //the 0.04 is to normalise proxytemp to 1961-90 average=0
        for (int y = 1750; y <= 1991; y++) proxytemp.set(y, (float) proxy_data[y - 1750] + 0.04f);
    }
    //*******************************************
    /**make historical tempdata trend - 7 year moving average */
    static void histtemptrend() {
        
        float ti=0;
        for (int y = 1750; y < 1757; y++) ti+= proxytemp.get(y); 
        temptrend.set(1753, ti/7f);
        for (int y = 1757; y < 1850; y++) temptrend.set(y - 3, temptrend.get(y - 4) + (proxytemp.get(y) - proxytemp.get(y - 7)) / 7.0f);
        for (int y = 1850; y < 1857; y++) temptrend.set(y - 3, temptrend.get(y - 4) + (tempdataCRU.get(y) - proxytemp.get(y - 7)) / 7.0f);
        for (int y = 1857; y <1880; y++) temptrend.set(y - 3, temptrend.get(y - 4) + (tempdataCRU.get(y) - tempdataCRU.get(y - 7)) / 7.0f);
        for (int y = 1880; y <1887; y++) temptrend.set(y - 3, temptrend.get(y - 4) + (tempdataCRU.get(y) + tempdataGISS.get(y))/14f  - tempdataCRU.get(y - 7) / 7.0f);
        for (int y = 1887; y <= tdey; y++) temptrend.set(y - 3, temptrend.get(y - 4) + (tempdataCRU.get(y) + tempdataGISS.get(y) - tempdataCRU.get(y-7) - tempdataGISS.get(y-7)) / 14.0f);
    }

    /**Normalising to baseyear  - : use baserange- years moving average 
     Note the offset calculated from CRU is also applied to GISS data, so the difference between these is preserved. 
     Should consider whether this is the best way to do it?
     */
    static void adjustbaseyear() {
        int by = (int) glotemp.baseyear.getval(), r = (int) glotemp.baserange.getval(), rw = 1 + r * 2;
        float htoffset = 0;
        for (int i = 0; i < rw; i++) {
            int dy = by + i - r;
            if (dy < gsy) dy = gsy;
            if (dy > tdey) dy = tdey;
            htoffset += (float) ((by - r >= 1850 ? tempdataCRU.get(dy) : proxytemp.get(dy)) / rw);
        }
        //float byoffset = //htoffset;//temptrend.get(by);

        for (int y = 1750; y <= 1991; y++) proxytemp.set(y, proxytemp.get(y) - htoffset);
        for (int y = 1850; y <= tdey; y++) tempdataCRU.set(y, tempdataCRU.get(y) - htoffset);
        for (int y = 1880; y <= tdey; y++) tempdataGISS.set(y, tempdataGISS.get(y) - htoffset);
        //for (int y = 1753; y <= tdey - 3; y++) temptrend.set(y, temptrend.get(y) - byoffset);
    }
}
