/*
 ocean carbonate chemistry and air-sea  gas exchange rate
 feedbacks in response to temperature and increasing ocean pH
 */

package jcm.mod.carbon;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.cli.glotemp;

public class  carbonatechemistry  extends module {
    
    
    public void setinteractions() {
	setaffectedby(chemfeedback, carbchem.chosen.startsWith("real"));
	setaffectedby(glotemp.class, chemfeedback.istrue() && carbchem.chosen.startsWith("real"));
    }
    
    public curve pH=new curve("pH", dkgreen),
	    bicarbonate=new curve("HCO3-", blue),
	    carbonate=new curve("CO3(2-)", dkblue),
	    co2aq=new curve("CO2aq" ,cyan),
	    totc02=new curve("TCO2", black);
    public curveset conc=new curveset( co2aq, bicarbonate, carbonate, totc02,  "concentrations", "molar");
    public curveset pHset=new curveset( pH,  "pH", "- log10 [H+]");
    
    
    String[] chemoptions={	"realb","realj","hildaz0z1","cubicfit","linear-carbonate"};
    complexity[] chemcomplex= { experimental, normal, expert, expert, normal };
    
    public param<String>
	    carbchem=new param("carbchemmenu", chemoptions, "realj", chemcomplex);	//determines which carbon chemistry formula to use
    public param
	    chemfeedback=new param("chemfbopt", true), 			//recalculate chemistry "constants" for each new temp?
	    gasex=new param("asgasex", "mol&per&m2&per&ppm&per&yr", orange, 0.06, 0, 0.12, expert); //gas exchange rate mol m-2 ppmv-1 yr-1
    
    //**********************************
    //chemistry/gasexchange variables, the [] are for low-lat (=0) and high-lat (=1) boxes
    //calk and hyd change as go along. k's are to store constants if not changing
    double askodml, talk, totb;
    double [] oafdml, askoaf, alpha, gamma, cubfitf,  totc0, calk, hyd, k1, k2, kb, kw, k0;
    double[] octemp, saflin, saflin0;
    
    double dml=berncarbon.dml, ocarea =berncarbon.ocarea, hfrac=berncarbon.hfrac;
    
    
    //**********************************
    //Setup carbonate chemistry -
    //this used to be in berncarbon setupfluxes
    //but maybe don't need to reset these unless above three parameters changed (or temp feedback)
    
    public void setupchemistry() {
	
	//gas exchange rate in mol m-2 uatm-1 yr-1 from 14C budget, almost independent of temp, but note not exactly same as in Joos value!
	double airseak= gasex.getval();
	
	//useful combinations of constants
	//note the [] are for low-lat (=0) and high-lat (=1) boxes
	
	askodml=1000.0*airseak/dml;
	oafdml=new double[2]; oafdml[0]=1.0e15 /(12*ocarea*(1.0-hfrac)*dml); oafdml[1]=1.0e15 /(12*ocarea*hfrac*dml);
	//param to get flux in MtC when multiplied by ppm gradient
	askoaf=new double[2]; askoaf[0]= 1.2e-11 * airseak * ocarea* (1.0-hfrac); askoaf[1]= 1.2e-11 * airseak * ocarea * hfrac;
	//air-sea exchange rate
	alpha=new double[2]; alpha[0]= carboncycle.ppmpmtc*askoaf[0]; alpha[1] = carboncycle.ppmpmtc*askoaf[1];
	
	hyd=new double[2]; hyd[0] = 1e-8; hyd[1] = 1e-8;
	calk=new double[2]; calk[0] = talk-0.001; calk[1] = talk-0.001;
	//calk and hyd are just starting values: will adjust as you go round the main loop
	//actually only need one of them -at the moment use hyd
	
	//temperature-dependent constants
	saflin=new double[2]; saflin0=new double[2]; gamma=new double[2]; cubfitf=new double[2];
	k0=new double[2]; k1=new double[2]; k2=new double[2]; kb=new double[2]; kw=new double[2];
	
	//ocean temperature
	octemp=new double[2]; octemp[0]=21.37; octemp[1]=1.38; //from original hilda?
	
	//for "real" chemistry calculations -need to know initial setup:
	talk = 0.0024; totb = 0.000416; // from dickson handbook
	totc0 = new double[2];
	totc0[0] = totc0(octemp[0]); totc0[1] = totc0(octemp[1]);
	//based on above, and same constants, with pCO2=280, and T for each box. overall uptake is very sensitive to this setting!
	//note totc0 is not same for hd and ld, but can't really assume eqm either -will be a steady state flow round loop due to temp gradient.
	
	//linear part of sea-air flux to include in matrix
	saflin[0] = saflin(octemp[0]) ; saflin[1] = saflin(octemp[1]);
	//line below makes better linear part for high emissions scenarios (but not so efficient at beginning)
	//if (carbchem.chosen=="realb" || carbchem.chosen=="realj"){	saflin[0] *= 2.0; saflin[1]*=2.0; }
	//disabled this - upsets attribution (responsibility) if nonlinear part not zero at beginning, and share between CO2 and temperature effect
	
	//also must remember original if saflin changes with temp!
	saflin0[0]= saflin[0]; saflin0[1]=saflin[1];
	
	//work out chemistry constants for low and high lat boxes, depending on which formula you chose
	chemconsts(octemp[0], 0); chemconsts(octemp[1], 1);
	
    } //precalc setup
    
    
    //********************************************
    //this is called from berncarbon calcstep
    //can't make it a calcstep here because doesn't store any state
    
    void temperaturefeedback() {
	if (chemfeedback.istrue()) {
	    double octr=gm(glotemp.class).getoceantemprise();
	    chemconsts(octemp[0]+octr, 0);
	    chemconsts(octemp[1]+octr, 1);
	}
    }
    
    
    //*************************************************************
    //temperature dependent constants:
    
    //hilda z0z1 carbonate chemistry: excess pco2 (ppmv) = z0dc/(1-z1dc) where dc =excess tco2 (micro-mol/kg) , note t in C
    double z0(double t) {	return 1.7561-0.031618*t+0.0004444*t*t; }
    double z1(double t) {	return 0.004096-7.7086e-5*t+6.1e-7*t*t; }
    
    //solubility Weiss 74, t in K! assume s=35
    double k0(double t) {	return Math.exp(-60.2409 + 9345.17/t + 23.3585*Math.log(t/100) + 35*(0.023517 - 0.00023656*t + 0.00000047036*t*t )); }
    
    //borate dissociation constant, Dickson 1990, t in K, assume s=35
    double kb(double t) {	return Math.exp(-(28559.7/t) + 1016.43 - 181.498*Math.log(t) +0.314173*t); }
    
    //carbonic acid k1, k2 Roy 1993, t in K, assume s=35
    double k1(double t) {	return Math.exp(-(2331.08/t) -1.5529413*Math.log(t) + 3.18181); }
    double k2(double t) {	return Math.exp(-(3493.43/t) -0.2005743*Math.log(t) -7.69056); }
    
    //kw water dissociation, Millero 95, t in  K, assume s=35
    double kw(double t) {	return Math.exp(-(13145.2/t) -17.4432*Math.log(t) +113.0395); }
    
    //preindustrial total carbon (mol/l), for pco2=280, talk=0.0024
    double totc0(double t) {	return (0.002221 /*orig=0.002225*/ -0.0000095*t); }
    
    //saflin factor dpco2/dTCO2 at c0 ppm/micromolar
    double saflin(double t) {	return askodml*(1.68 -0.036*t +0.0006*t*t); }
    
    //cubic-fit formula factor
    double cubfitf(double t) {	return askodml*(80.0 -3.5*t +0.05*t*t)/1e6; }
    
    float calcpK(double d) { 	return (float)(-Math.log(d)/Math.log(10.0));    }
    
    
    //************************************************
    //routine to change chemistry "constants": (called within mainloop if temperature feedback)
    
    void chemconsts(double t, int b) {
	if (carbchem.chosen=="hildaz0z1") {	saflin[b] = z0(t)*askodml; gamma[b]= z1(t)*oafdml[b]; }
	if (carbchem.chosen=="saflin") {	saflin[b] = saflin(t); }
	if (carbchem.chosen=="cubicfit") {	saflin[b] = saflin(t); cubfitf[b] = cubfitf(t)*oafdml[b]*oafdml[b]; }
	if (carbchem.chosen=="realb" || carbchem.chosen=="realj") {	double tk=t+273.15; k0[b]=k0(tk); k1[b]=k1(tk); k2[b]=k2(tk); kb[b]=kb(tk); kw[b]=kw(tk); }
    } //end chemconsts
    //check constants: System.out.println(b+" "+t+" "+k0[b]+" "+k1[b]+" "+k2[b]+" "+kb[b]+" "+kw[b]);
    
    
    //************************************************
    //functions for nonlinear components of fluxes from sea to air, depending on carbchem.chosen
    
    double safnonlin(double xsc, int b) {
	
	if (!(carbchem.chosen=="realb" || carbchem.chosen=="realj")) {
	    pH.set(curve.dud);  carbonate.set(curve.dud);        bicarbonate.set(curve.dud);  co2aq.set(curve.dud);  totc02.set(curve.dud);
	}
	
	if (carbchem.chosen=="hildaz0z1") return (saflin[b]*gamma[b]*xsc*xsc)/(1.0-(gamma[b]*xsc)) + (chemfeedback.istrue()? xsc*(saflin[b]-saflin0[b]) : 0);
	if (carbchem.chosen=="cubicfit") return (cubfitf[b]*xsc*xsc*xsc)+ (chemfeedback.istrue()? xsc*(saflin[b]-saflin0[b]) : 0);
	if (carbchem.chosen=="linear") return chemfeedback.istrue() ?  xsc*(saflin[b]-saflin0[b]) : 0;
	
	if (carbchem.chosen=="realb" || carbchem.chosen=="realj") {
	    double totc = totc0[b] + xsc * oafdml[b] /1.0e6 ;
	    
	    int ncit=0;
	    
	    if (carbchem.chosen=="realb") {	//ben's iteration method -use old h to calculate calk from talk, solve quadratic for new h
		double hydold;
		do {
		    ncit++;
		    hydold=hyd[b];
		    calk[b]= talk - (totb*kb[b]/(hyd[b]+kb[b])) - (kw[b]/hyd[b]) +hyd[b];
		    double root=((totc-calk[b])*(totc-calk[b]))-(4*calk[b]*(calk[b]-2*totc)*k2[b]/k1[b]);
		    hyd[b] = (k1[b]/(2*calk[b]))*((totc-calk[b])+Math.pow(root,0.5));
		} while (Math.abs(1-hydold/hyd[b])>0.00001 && ncit<10);
	    }
	    
	    else {	//jesper's iteration method from basic program
		double ph=6.0, dph=-0.5, yold=0.0, a, y;
		do {
		    ncit++;
		    hyd[b]=Math.pow(10.0,-ph);
		    a=((k1[b]/hyd[b]+2.0*k1[b]*k2[b]/(hyd[b]*hyd[b]))/(1.0+k1[b]/hyd[b]+k1[b]*k2[b]/(hyd[b]*hyd[b])))*totc;
		    y= talk -a -kb[b]*totb/(hyd[b]+kb[b]) - kw[b]/hyd[b] + hyd[b];
		    dph*=y/(yold-y); yold=y; ph+=dph;
		} while (Math.abs(dph)>0.00001 && ncit<10);
	    }
	    
	    double co2= totc * (hyd[b]*hyd[b])/(hyd[b]*hyd[b] + k1[b]*hyd[b] + k1[b]*k2[b]);
	    //added for output
	    double bicarb=k1[b] * co2 /hyd[b];
	    double carb=totc - co2 - bicarb;
	    //note this will set pH etc using only second ocean box, but they will be almost identical
	    pH.set(calcpK(hyd[b]));
	    carbonate.set((float)(carb));
	    bicarbonate.set((float)(bicarb));
	    co2aq.set((float)(co2));
	    totc02.set((float)(totc));
	    
	    return (askoaf[b] * ((1e6 * co2 / k0[b])-carboncycle.atppmprein))- saflin[b]*xsc ;
	    
	    //note: saflin linear flux was included in matrix to help smooth the response, so subtract it here
	} //end real
	return 0;
    }
    
    
}
