//loads historical and sres data
/*
P2 Aim to load data from textfiles, abandon old loaddata (although keep compression/uncompression methods) see also data.todo
 
 othergas emissions & concentrations,
 temperature-data & proxy, (needs updating anyway, inc new hockey-sticks)
 historical gdp & en, (could easily replace by gdp from elsewhere?)
 sres global, 12-regional (soc&fos), 4regional (othgas), IPCC-TAR data for circles
 
P2 CHECK Old Loaddata notes
What need to replace with text files before can get rid of it?
Maybe can split by receiving module
 
Hist-global emit CO2, LUCO2, CH4, SOX, CO
Hist-global conc CO2, N2O, O3, HFC, CFC,
Hist global RF Solar, Volcano
Hist global temp -measured, proxy
 
Hist-JCM12 CO2, pop, gdp, en
Hist-EDGAR  CH4, N20, LUC
 
Note also the matchdata class
CH4fos, luc, n2o, ch4 for 13 regions, 1890-1970 in 10yr blocks, then every year until 2100 (for scenario A2)
 
SRES IMAGE regional emit CO2, POP, GDP/cap, EN/cap
SRES 4-region CO2, CO2LUC, CH4, N2O, POP, GDP
 
SRES IPCC global emit CO2, LUCO2, SOX, CH4, N2O, NOX, CO, VOC, HFC
SRES IPCC global conc, rf, temp: BERN-C02, 10x forcings, global temp
 
 *
 */

package jcm.indata;
import java.io.*;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.ob.world;
import jcm.mod.obj.sresdata;
import jcm.core.tls.fileio;
import jcm.mod.ogas.*;
import jcm.mod.cli.glotemp;
import static jcm.core.report.*;

public class loaddata  {
    
    static DataInputStream datain;
    
    
    
    public static void getdata(world w)  {	try {
	
	logn("Loading Core Data");
	datain = fileio.getDIS("data/data.dat");
	
	//historical global
	loadarray1(null); //        loadarray(w.get(carboncycle.class).fossil.a,110);
	loadarray1(null); //	loadarray(w.get(carboncycle.class).lucf.a,100); //1850-1990
	
	loadarray1(w.gm(othgasemit.class).ch4emit,1860);
	loadarray1(w.gm(othgasemit.class).soxemit, 1850);
	loadarray1(w.gm(othgasemit.class).coemit, 1765);
	
	loadarray1(null); //	loadarray(carboncycle.co2atppmdata.a,110); //note this now inside carboncycle code
	
	loadarray1(null); //w.get(atchem.class).ch4conc);
	loadarray1(null); //w.get(atchem.class).n2oconc);
	loadarray1(null); //w.get(atchem.class).tropo3du, 1850);
	
	loadarray2(fgas.hfchistconc); //startyr = 1960
	loadarray2Q(w.gm(fgas.class).fgconc,12, 1930); //startyr 1930=0 cfcs 12-26, in 5-yr steps
	
	loadarray1(null); //aerosol.solarrfdata);
	loadarray1(null); //aerosol.volcorig);
	
	loadarray1(null); //glotemp.tempdata, 1860); //up to 2002 !
	loadarray1(null); //glotemp.proxytemp); //up to 1991
	
	log("- hist-glob-data-ok");
	
	//historical regional -start 1900
	loadarray2(null); //regemit.jcm12fos);
	loadarray2(null); //history.jcm12pop); //need for remake gdp & en, temporarily
	loadarray2(null); //history.jcm12gdp, 70);
	loadarray2(null); //history.jcm12en, 71);
	
	log("-hist-reg-data-ok");
	
	//sres global
	loadarray2(sresdata.fosemit);
	loadarray2(sresdata.lucemit);
	loadarray2(sresdata.soxemit);
	loadarray2(sresdata.ch4emit);
	loadarray2(sresdata.n2oemit);
	loadarray2(sresdata.noxemit);
	loadarray2(sresdata.coemit);
	loadarray2(sresdata.vocemit);
	loadarrayset3(sresdata.hfcemit);
	
	log("-sres-glob-data-ok");
	
	//sres regional
	loadarray3(null); //sresdata.jcm12fos);
	loadarray3(null); //scenario pop
	loadarray3(null); //scenario gdp
	loadarray3(null); //scenario energy
	
	log("-sres-reg-data-ok");
	
	//sres calculated for comparison only
	loadarray2(sresdata.bernmid);
	for (int i=0; i<6; i++) loadarray2(sresdata.rfdata[i]);
	loadarray1(sresdata.rfdata[6][0]); for (int j=1; j<7; j++) sresdata.rfdata[6][j]=sresdata.rfdata[6][0]; //cfc same for all
	for (int i=7; i<10; i++) loadarray2(sresdata.rfdata[i]);
	loadarray2(sresdata.tempchange);
	for (int i=0; i<7; i++) loadarray2(sresdata.sldata[i]);
	
	log("-sres-calc-data-ok");
	
	//historical responsibility data - for brazilian proposal exercise
	loadarray2(null); //regemit.ehch4);
	loadarray2(null); //regemit.ehn2o);
	loadarray2(null); //history.houghton);
	loadarray3(null); //sresdata.sres4fos
	loadarray3(sresdata.sres4luc);
	loadarray3(sresdata.sres4ch4);
	loadarray3(sresdata.sres4n2o);
	loadarray3(null); //sresdata.sres4pop
	loadarray3(null); //sresdata.sres4gdp
	
	log("-responsibility-data-ok");
	
	datain.close();
    } catch (IOException e) {	deb(e, "loaded Caught IOException: "); }
    
    
    } //end getdata
    
    
    
    //********************************
    //general methods to load an array:
    
    
    //simplest 1D array
    static void loadarray1(Object id) {	loadarray1(id, (id instanceof curve ? ((curve) id).sy : 0)); }
    
    //1D with offset start
    static void loadarray1(Object id, int s) {	int l=getlen(); loadArray(id, s, l); }
    
    //2D array
    static void loadarray2(float[][] id) {	loadarray2(id,0); }
    
    //2D array, starting id[][] at s
    static void loadarray2(float[][] id, int s) {	loadarray2(id, 0, s); }
    
    //2D array, starting id[] at si, id[][] at sj
    static void loadarray2(float[][] id, int si, int sj) {
	int li=getlen(); int lj=getlen();
	for (int i=si; i<(si+li); i++) loadArray(id !=null ? id[i] : null, sj, lj);
    }
    
    //2D QT array, starting at si, a[] at sj
    static void loadarray2Q(curve[] q, int si, int sj) {
	int li=getlen(); int lj=getlen();
	for (int i=si; i<(si+li); i++) loadArray(q[i], sj, lj);
    }
    
    
    //3D array regular
    static void loadarray3(float[][][] id) {
	int li=getlen(); int lj=getlen(); int lk=getlen();
	for (int i=0; i<li; i++) for (int j=0; j<lj; j++) loadArray(id !=null ? id[i][j] : null, 0, lk);
    }
    
    //3D array, set of irregular 2D
    static void loadarrayset3(float[][][] id) {
	int li=getlen();
	for (int i=0; i<li; i++) {
	    int lj=getlen(); int lk=getlen();
	    for (int j=0; j<lj; j++) loadArray(id !=null ? id[i][j] : null, 0, lk);
	}
    }
    
    //***********************************
    // key method: 1D array, start and length
    static void loadArray(Object id, int s, int l) {
	try {
	    float min=datain.readFloat(), max=datain.readFloat(), rf=(max-min)/255f, f;
	    curve q=id instanceof curve ? (curve)id : null;
	    
	    for (int i=0; i<l; i++) {
		f=min+rf* datain.readUnsignedByte();
		if (id instanceof float[]) ((float[])id)[i+s]=f;
		if (id instanceof curve) q.set( s+i * q.xstep, f);
	    }
	} catch (IOException e) {	log(e); } catch (Exception e) { deb(e); }
    } //end load
    
    static int getlen() {	int l=0; try {	l=datain.readShort(); } catch (IOException e) {	log(e); } return l; }
    
    
} //end class

