
package jcm.indata;
import java.io.*;
import java.util.*;
import static jcm.core.report.*;
import jcm.core.tls.fileio;

public class DataConvertorWEO {
    
    
    public static void main(String[] args) {
	File inf=new File("/java/jcm/jcm5/data/convert/WEOApr2008all.csv");
	File outf=new File("/java/jcm/jcm5/source/data/hist/WEOgdp_mer.csv"); //-ppp
	String header="GDP data, MER, current US dollars, field NGDPD from WEO April 2008, from 1980 to 2013 (estimated after 2007, or earlier depending on data)\n\n";
	String field="NGDPD"; //PPPGDP	
	//String header="GDP data, PPP, current international dollars, field PPPGDP from WEO October 2007, from 1990 to 2008 (estimated after 2005/6, or earlier depending on data)\n\n";
	/* 
	 Note: the field PPPGDP is purchsing power parity current dollars 
	 the field NGDPD uses market exchange rates to convert to current dollars, including some projected exchange rates (see notes in table)
	(need to correct both using the deflator from US to get 2000$)  - this is easier to join to other data such as PWT
	(note: if  NGDPD = my * ex (=uy/my),  => uy , so  * u0/uy => u0 - same as if take m0 * ex0 (=u0/m0)
	 
	 */
	
	try {
	    InputStream is= new FileInputStream(inf);
	    LineNumberReader lnr=new LineNumberReader(new BufferedReader(new InputStreamReader(is)));
	    StringTokenizer st;	String s;
	    List<String> as=new ArrayList();
	    List<String> a= new ArrayList();
	    String b;
	    
	    try {
		while ((s=lnr.readLine())!=null) {
		    st = new StringTokenizer(s, "\t");
		    a.clear();
		    while (st.hasMoreTokens()) a.add(st.nextToken().trim());
		    if (a.size()>2 && a.get(2).equals(field)) {
			b=a.get(3); for (int i=9; i<43; i++) b+="\t"+a.get(i).replace(",", "");
			b+="\n";
			as.add(b);
		    }
		}//while
	    } catch (IOException e) { deb(e); }
	    
	    is.close();
	    
	    FileWriter fw= new FileWriter(outf);
	    
	    fw.write(header);
	    for (String os : as)  fw.write(os);
	    fw.close();
	    
	} catch (IOException e) { deb(e); }
	
    }
    
} //end class
/*
 Code is a variant of load-tab
 but to avoid huge memory use need processing during loading, => need specialised method in the middle.
 could pass an object that has a usedataitem() method?
 
 */