
package jcm.indata;
import java.io.*;
import java.math.*;
import java.util.*;
import static jcm.core.report.*;

public class DataConvertorPWT {
    
    
    public static void main(String[] args) {
	// Input file location
	File inf=new File("data/convert/Penn_pwt62.csv");
	// Output files locations
	File f_pop=new File("Source/data/hist/PWTpop.csv");
	File f_xrat=new File("Source/data/hist/PWTxrat.csv");
	File f_ppp=new File("Source/data/hist/PWTppp.csv");
	File f_cgdp=new File("Source/data/hist/PWTcgdp.csv");
	
	
	try {
	    InputStream is= new FileInputStream(inf);
	    LineNumberReader lnr=new LineNumberReader(new BufferedReader(new InputStreamReader(is)));
	    StringTokenizer st = null;	String s;
	    // List<String> xrat =new ArrayList();
	    String pcntry="", cntry="", iso="";
	    String year="";
	    String pop="";
	    String xrat="";
	    String ppp="";
	    String cgdp="";
	    Boolean headok=false;
	    
	    // Create output files and write headers
	    FileWriter fw_pop= new FileWriter(f_pop);
	    FileWriter fw_xrat= new FileWriter(f_xrat);
	    FileWriter fw_ppp= new FileWriter(f_ppp);
	    FileWriter fw_cgdp= new FileWriter(f_cgdp);
	    
	    s=lnr.readLine();
	    String main_head=s;
	    s=lnr.readLine(); fw_pop.write(main_head+"\n"+s+"\n");
	    s=lnr.readLine(); fw_xrat.write(main_head+"\n"+s+"\n");
	    s=lnr.readLine(); fw_ppp.write(main_head+"\n"+s+"\n");
	    s=lnr.readLine(); fw_cgdp.write(main_head+"\n"+s+"\n");
	    s=lnr.readLine(); // last header line has no more use here (old columns heads)
	    
	    try {
		pcntry = ""; // will hold the name of last processed country
		do  {
		    // Need to try getting data (before knowing what to do)
		    s=lnr.readLine();
		    if (s==null) {
			cntry="-"; // end of file reached - no more country - will just write
		    } else {
			st = new StringTokenizer(s, "\t");
			// File contents:
			//country   country-isocode   year   POP   XRAT   PPP   cgdp
			cntry=st.nextToken().trim();
		    }
		    if (!cntry.equals(pcntry)) {
			if (!pcntry.equals("")){
			    if (!headok) {
				// This is the very first pass : write the "years" header
				fw_pop.write(year);
				fw_xrat.write(year);
				fw_ppp.write(year);
				fw_cgdp.write(year);
				headok=true;
			    }
			    // We have all years for a given country, let's write it
			    fw_pop.write("\n"+pop);
			    fw_xrat.write("\n"+xrat);
			    fw_ppp.write("\n"+ppp);
			    fw_cgdp.write("\n"+cgdp);
			}
			// Clear the data storage for the current country, all years
			year="Country";
			pop   =cntry;
			xrat  =cntry;
			ppp   =cntry;
			cgdp  =cntry;
			pcntry=cntry;
		    }
		    
		    // Get and store the data for a year and a country
		    if (s!=null) {
			iso  =      st.nextToken().trim();
			year+= "\t"+st.nextToken().trim();
			pop += "\t"+roundInt(st.nextToken().trim());
			xrat+= "\t"+roundFloat(st.nextToken().trim());
			ppp += "\t"+roundFloat(st.nextToken().trim());
			cgdp+= "\t"+roundInt(st.nextToken().trim());
		    }
		} while (s!=null) ;
		
	    } catch (IOException e) { deb(e); }
	    
	    is.close();
	    fw_pop.close();
	    fw_xrat.close();
	    fw_ppp.close();
	    fw_cgdp.close();
	    
	} catch (IOException e) { deb(e); }
	
    } //main
    
    //rounding numbers
    static MathContext mc=new MathContext(4);
    static String roundInt(String s)  {  try { return ""+(int)(Float.parseFloat(s)+0.5f);    } catch (Exception e) { return "n/a"; } }
    static String roundFloat(String s)  { try { return  new BigDecimal(s.replace(" ",""), mc).toString();    } catch (Exception e) { return "n/a"; } }
    
    
    
    } //end class
