
//tool for viewing graph data

package jcm.gui.plot;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.plotlink;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.core.itf.menuFiller;
import jcm.core.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import java.io.*;
import static  jcm.core.report.*;


public class datable extends JScrollPane implements plotlink  {
    
    jcmTM tm; boolean ready=false;
    
    public datable(final curveset qq) {
	setName(labman.getTitle(qq.getNameWithWorld()));
	setToolTipText(getName());
	
	register.addlink(this, qq);
	loop.gonow(); //for regional modules, qq.map.values() are made only after loop.go
	
	tm=new jcmTM(qq);
	JTable 	tab=new JTable(tm);
	tab.setColumnSelectionAllowed(true);
	setcolor(tab, 0, Color.black);
	int c=1; for (curve q: qq.map.values()) { setcolor(tab, c, q.color); c++; }
	
	//for (int i=0; i<tm.getColumnCount(); i++)  tab.getColumnModel().getColumn(i).setMinWidth(80);
	//setPreferredSize(new Dimension(400,300));
	//setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	
	tab.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	//could specify a menu of options for resizing?
	
	setViewportView(tab);
	
	new jcmMenu(tab, new menuFiller(){ public void fillMenu(jcmMenu pop) { pop.add(savetablemenu(qq)); pop.addSeparator(); qq.fillMenu(pop);  } } );
	ready=true;
    }
    
    void setcolor(JTable tab, int column, final Color color) {
	tab.getColumnModel().getColumn(column).setCellRenderer(new DefaultTableCellRenderer() {
	    public void setValue(Object value) {	setForeground(darken(color));  super.setValue(value); }
	});
    }
    
    
    boolean ispale(Color c) { return (c.getRed()+c.getGreen()+c.getBlue())>650; }
    Color inverse(Color c) { return new Color(390-c.getRed(), 390-c.getGreen(), 390-c.getBlue()); } // no good for grays
    Color darken(Color c) { return (c.getRed()+c.getGreen()+c.getBlue() <650) ? c : new Color(c.getRed()-100, c.getGreen()-100, c.getBlue()-100); }
    
    public void doplot() { try {
	tm.fireTableDataChanged();
	repaint();
    } catch (Exception e) { deb(e, "table plot problem"); }
    }
    
    public boolean isShowing(){ return (!ready || super.isShowing()); } //so loop.go has an effect, before its showing
    
    //*******************************************
    //SAVE TABLE
    
    static jcmMenu savetablemenu(final curveset qq) {
	jcmMenu savetable=new jcmMenu("Save table");
	for (final String s : new String[]{"csv", "tab"})  savetable.add( new jcmAction(s) {  public void act()  {
	    //qq.forcecalc();  //no longer needed- if this menu is only available once table already visible
	    fileio f=new fileio("tables", qq.name, s, "Save Table", "save");
	    savetable(f, qq, s);
	}});
	return savetable;
    }
    
    
    //used by scripts
    public static void  savetable(File f, curveset qq, String type) { savetable(new fileio(f), qq, type);    }
    
    static void  savetable(fileio  f, curveset qq, String type) {
	if (f.os!=null) {
	    try {
		jcmTM tm=new jcmTM(qq);
		OutputStreamWriter fw=new OutputStreamWriter(f.os);
		int rows=tm.getRowCount(), cols=tm.getColumnCount();
		String line;
		for (int row=0; row<rows; row++) {
		    line="";
		    for (int col=0; col<cols; col++)   line+=tm.getValueAt(row, col)+ (type=="csv" ? ", " : "\t");
		    fw.write(line+"\n");
		    //System.out.println(line+"\n");
		}
		f.save();
	    } catch (IOException e) {	deb(e); };
	} //if
    } //savetable
    
}//end class

//P2 rather inefficient code - eg calc new color per cell, and round floats to int (should be done by generic qtset)


//*******************************************

class jcmTM extends AbstractTableModel  {
    
    //note this assumes that all data have same sy & xstep as first column!
    
    
    Vector<curve> curves;
    jcmTM(curveset qq) {   curves=new Vector<curve>(qq.map.values()); }
    
    public String getColumnName(int col) {	return (col==0 ? "year" : labman.getTitle(curves.get(col-1).name)); }
    public int getRowCount()  {  int rc=0; for (curve c : curves) {int rcc= c.getlength(); if (rcc>rc) rc=rcc; } return rc+1; 	}
    public int getColumnCount() { return 1+curves.size(); }
    public Object getValueAt(int row, int col) {
	int year=curves.get(0).getyear(row-1);
	if (row==0) return getColumnName(col);
	if (col==0) return year;
	float f=curves.get(col-1).get(year) ; return (Float.isNaN(f) ?  "---" : ( f==(float)((int)f) ) ? ""+((int)f)  :  f);
    }
    public boolean isCellEditable(int row, int col) {	return ( col==0 || row==0 ? false : true ); }
    public void setValueAt(Object value, int row, int col) {
	curves.get(col-1).set((Integer)getValueAt(row, 0), Float.parseFloat(value.toString()));
	fireTableCellUpdated(row, col);
    }
}

/**********************
 //not currently used
 public static jcmMenu savetablemenu(final String name, final TableModel tm) {
 jcmMenu savetable=new jcmMenu("Save table");
 for (final String s : new String[]{"csv", "tab"})  savetable.add( new jcmAction(s) {  public void act()  {
 savetable(name, tm, s);
 }});
 return savetable;
 }
 */
