/*
 
 */

package jcm.gui.plot;
import java.awt.*;
import javax.swing.JButton;
import javax.swing.event.MouseInputListener;
import jcm.core.par.param;
import jcm.core.ob.interacob;
import jcm.gui.doc.labman;
import static jcm.gui.gen.colfont.*;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import static jcm.core.report.*;
import jcm.gui.nav.jcmAction;
import jcm.mod.regimp.mapdata;

public class colorscale extends scaleview implements MouseInputListener {
    
    colormap cm;
    JButton reset;
    jcmAction resetAction;
    
    //implements plotlink,
    //register.addlink(this,  (interacob)cm);
    //public void doplot() { repaint();  }
    
    public colorscale(colormap source) {
	cm=source;
	cm.resetscale();
	sp=new param(param.Type.Xscale,  "Xscale", "", 0, cm.getmin(), cm.getrange()+cm.getmin()) {
	    public void precalc() { deb("sp precalc"); if (cm.hasresetscale() ) resetcols(); }
	};
	resetAction=new jcmAction("Reset Colors") { public void act() { cm.resetscale(); resetcols(); sp.changed=true; sp.respond(true);}};
	reset=new JButton(resetAction);
	//put links to reset here because must adjust before mapplot doplot, which maybe before colorscale doplot - however this depends on this postcalc coming after that of regcli!
	
	origin= cm.getmin() +cm.getrange()/2;
	setBackground(white);
	setPreferredSize(new Dimension(400, 32));
	setToolTipText(labman.getTitle(sp.getstate())); //name+"&"+sp.units.units)
	addMouseListener(this);
	addMouseMotionListener(this);
	setCursor(new Cursor(Cursor.E_RESIZE_CURSOR));
	if (cm instanceof interacob) {   sp.setaffectedby((interacob)cm); }
    }
    
    public void resetcols() {
	sp.min=cm.getmin(); sp.max=cm.getrange()+cm.getmin();
	origin=cm.getmin() +cm.getrange()/2;
	sp.units.checkunitfac(sp.range());
	repaint();
	deb("sp adjusted "+sp.min+"-"+sp.max);
    }
    
    
    public void paintComponent(Graphics g) {
	lookandfeel.setAntiAlias(g);
	lw=20; 	w=getWidth()-2*lw; h=getHeight();
	g.clearRect(0,0,w+2*lw,h);
	for (int x=0; x<=w; x++) {
	    float f=(float) (sp.min()+(x*sp.range())/w );
	    g.setColor(getColor(f));
	    g.drawLine(x+lw, 0, x+lw, h/2);
	    //if (x==0 || x%(w/(w/80))==0) { 	g.setColor(black); 	g.drawLine(x+lw, h/2, x, h/2+4);		g.drawString(units.round(f,1,2), x+lw-12, h-4);     }
	}
	g.setFont(colfont.normalfont);
	drawnums(g);
    }
    
    public float sptocm(float f) {
	return (float)(cm.getmin()+(f-sp.min())*cm.getrange()/sp.range());
    }
    
    public Color getColor(float f) { return getColor(f, sp.min(), sp.range()); }
    
    
    //*************  default rainbow colorscale ***************
    static int r,g,b;
    public static Color[] c =new Color[256];
    static { makerainbow(); }
    public static void makerainbow() {
	for (int i=0; i<256; i++) {
	    b= (int) (127+127.0*Math.cos((Math.PI*2)*(i-43)/256));
	    g= (int) (127+127.0*Math.cos((Math.PI*2)*(i-128)/256));
	    r= (int) (127+127.0*Math.cos((Math.PI*2)*(i-213)/256));
	    c[i]=new Color(r,g,b);
	}
    }
    
    //august 06: added 10% at each end of range
    public static Color getColor(double f, double min, double range) {
	if (mapdata.dud((float)f)) return white;
	int q=(int)(256.0 * (f-(min-0.1f*range))/(range*1.2f) + 4096.0)%256;
	if (q>0) return c[q]; else return white;
    } // if (c<0) c=0;
    
    
    
} //end class