package jcm.gui.nav;

import java.lang.ref.WeakReference;
import java.util.*;
import javax.swing.*;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.itf.*;
import jcm.core.itf.menuFiller;
import jcm.core.report;
import jcm.core.ob.root;
import jcm.core.ob.world;
import jcm.gui.doc.*;
import jcm.gui.gen.*;
import jcm.core.tls.memoryChecker;
import jcm.gui.plot.backImage;
import static jcm.core.complexity.*;
import static jcm.gui.nav.filter.filtertype.*;
import static jcm.core.report.*;

public class topMenus {
    public static jcmMenu view; //external to main since ref from lookandfeel

    public static void makemenus() {

        JMenuBar mb = showpan.mb;

        //******************************* SETUP MENU *****************
        splash.report("Setup Menu");

        jcmMenu sup = new jcmMenu("Setup");
        setup.fillMenu(sup);
        sup.add(loop.modendyear);
        sup.add(curve.smoothinterval);
        sup.add(curve.smoothtype);
        sup.add(showpan.pan(docview.class, "About&SetupMenu"));

        mb.add(sup);

        //*************** TOOLS MENU *******************
        splash.report("-Tools Menu");
        jcmMenu tools = new jcmMenu("Tools");
        view = new jcmMenu("View");

        tools.add(showpan.pan(jcmTree.class));

        jcmMenu soe = new jcmMenu("sysout", normal);
        soe.add(showpan.pan(report.class), report.debugmode, loop.checkperform);

        tools.add(soe);
        mb.add(view);
        mb.add(tools);

        tools.add(showpan.pan(interacmap.class, normal));
        tools.add(new jcmAction("Check Memory", expert) {
              public void act() {
                  memoryChecker.checkall();
              }
          });
        tools.addSeparator();
        tools.add(imagesaver.copyaction(showpan.mf), imagesaver.saveimagemenu(showpan.mf, "JCM-all"));

        tools.addSeparator();
        tools.revalidate();

        //*************** VIEW MENU *******************

//	jcmMenu struc=new jcmMenu("Filter");
//	struc.add(complexity.defaultcomplexity, docview.helpmode, param.filterenabled);
//	mb.add(struc);

        //lookandfeel.lookAndFeelParam.precalc();
        splash.report("-View Menu");
        view.add(complexity.defaultcomplexity);
        view.add(labman.language);
        view.addSeparator();
        view.add(lookandfeel.lookAndFeelParam);
        view.add(lookandfeel.macMenuBar);
        //lookandfeel.thememenu(view);
        view.add(lookandfeel.antiAlias, lookandfeel.fontSize);
        view.add(backImage.usebackim);
        //view.add(showpan.pantype);

        view.addSeparator();
        view.add(showpan.pan(docview.class, "About&ViewMenu"));




        //**************************************
        //shouldn't be necessary as setup will make a world
        //splash.report("Initialise World 1");
        //world w=new world("World 1");

        //**************** DOC ******************

        jcmMenu doc = new jcmMenu("DocMenu");
        doc.add(showpan.pan(docview.class, "welcome"));
        doc.add(showpan.pan(docview.class, "howuse"));
        doc.add(showpan.pan(docview.class, "mainmenu"));
        doc.add(docview.helpmode);
        doc.addSeparator();
        doc.add(new jcmMenu(world.worldsob.find("World 1"), Doc, "Model Doc"));
        doc.addSeparator();
        //doc.add(showpan.pan(labdoctable.class));

        mb.add(doc);

        // **************** FILTER MENUS ***************

        splash.report("-Filter Menus");

        //P2 consider whether below should be simplest or normal - actually menus are most useful when simplest?
        mb.add(new jcmMenu(Curves, world.worldsob,  simplest));
        mb.add(new jcmMenu(Maps, world.worldsob,  simplest));
        mb.add(new jcmMenu(NeededParams, world.worldsob, simplest));
        mb.add(new jcmMenu(Worlds, world.worldsob, expert));
        mb.add(new jcmMenu(root.rootob.find("jcm"), Source, expert));
        jcmMenu datamenu=new jcmMenu("Data", Data, expert);
        datamenu.add(new jcmMenu("Core data", root.rootob.find("data"), Data, expert));
        datamenu.add(new jcmMenu("LUC data", root.rootob.find("lucdata"), Data, expert));
        datamenu.add(new jcmMenu("MATCH data", root.rootob.find("match-emitdata"), Data, expert));
        mb.add(datamenu);
        mb.add(new jcmMenu(root.rootob.find("jcm.script"), Scripts, expert));

        //************************* WIN MENU *************************
        final jcmMenu winmenu = new jcmMenu("Show", normal, new menuFiller() {
                                        public void fillMenu(jcmMenu m) {
                                            for (final WeakReference<JComponent> wrc : register.winmap.keySet()) if (wrc.get() != null && wrc.get().isShowing())
                                                    m.add(new jcmAction(wrc.get().getName()) {
                                                      public void act() {
                                                          showpan.toFront(wrc.get());
                                                      }
                                                  });
                                        }
                                    });
        mb.add(Box.createHorizontalGlue());
        mb.add(winmenu);

        //************************* CIRC MENU *************************
        splash.report("-Circle Menu");
        tools.add(new jcmAction("CircMenu", experimental) {
              public void act() { //new JButton(
                  showpan.addwindow(new circmenu(world.worldsob));
              }
          });

        tools.add(showpan.pan(docview.class, "About&ToolsMenu"));


        mref.doplot(); //to adjust for complexity
        splash.report("-Finished Menus");

    } //make menus
    //***************** MENU REFRESHER
//
//	 register.addlink(mref, complexity.defaultcomplexity);
//	register.addlink(mref, labman.language);
//	register.addlink(mref, lookandfeel.fontSize);
    static final Set<jcmMenu> menus = new LinkedHashSet();
    static plotlink mref = new plotlink() {
        public boolean isShowing() {
            return true;
        }

        public void doplot() {
            for (int i = 0; i < showpan.mb.getMenuCount(); i++) {
                JMenu j = showpan.mb.getMenu(i);
                if (j instanceof jcmMenu) menus.add((jcmMenu) j);
            }
            showpan.mb.removeAll();
            deb("Menu Bar removed all");
            for (jcmMenu j : menus) if (complexity.check(j)) {
                    showpan.mb.add(j);
                    deb("-mb added " + j.name);
                }
            showpan.mb.validate();
            showpan.mb.repaint();
        }
    };
} //end classs
