

package jcm.gui.gen;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.*;
import javax.swing.*;
import jcm.core.ob.*;
import jcm.gui.doc.docview;
import jcm.gui.nav.jcmTree;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.core.tls.txt;
import static jcm.core.report.*;

public class iconFinder {
    
    
    private static Map<URL, ImageIcon> icons=new HashMap(); //this stores a map of filtered icons, for efficiency
    private static Map<String, String> iconalias=new HashMap();
    
    static {
	String[][] sss=fileio.loadtab("png/iconnames.txt", ",");
	for (String[] ss : sss) for (String s : ss)  iconalias.put(s.toLowerCase(), ss[0]);
    }
    
    public static String get(String s) { 	return (s==null ? null : iconalias.get(s.toLowerCase()));     }
    
    public static String findAlias(String s) {
	String s2=get(s);
	if (s2==null) s2=get(infob.removepackagename(s));
	return get(s2);
    }
    
    public static String findAlias(infob io) {
	String s=get(io.name.toLowerCase());
	if (s==null && io.name.indexOf("&")>0) for (String s2 : txt.split(io.name, "&")) s=get(s2.toLowerCase());
	if (s==null) s=get(io.type());
	//if (s==null) s=labman.getShort(io.name); //for texticon
	return s;
    }
    
    public static String findAlias(Object c) {
	if (c instanceof infob) return findAlias((infob)c);
	if (c instanceof String) return findAlias((String)c);
	if (c instanceof Enum) return findAlias(c.toString());
	//could add some other special cases here
	String s =
		(c instanceof jcmTree) ?  get( ((jcmTree) c).getRoot().name)
		: (c instanceof docview) ?  get(((docview)c).page)
		: null;
	if (s==null) s= findAlias(c.getClass().getSimpleName());
	return s;
    }
    
    public static Icon findIcon(String s) { return getIcon(findAlias(s)); }
    public static Icon findIcon(infob io) { return getIcon(findAlias(io)); }
    public static Icon findIcon(Object c) { return getIcon(findAlias(c)); }
    
    public static Icon getIcon(final String alias) {
	try {
	    URL u=fileio.getURL("png/"+alias+".png");
	    if (u!=null) return filter(u);
	    else if (alias!=null) return texticon(alias);
	} catch (Exception e) { deb(e, "can't make icon "+ alias);   }
	return null;
    }
    
    
    //make a temporary icon (roundrect containing text)
    public static Icon texticon(final String s) {
	final int w=20, h=20;
	return new Icon() {
	    public int getIconHeight() { return w; }
	    public int getIconWidth() {return h; }
	    public void paintIcon(Component c, Graphics g, int x, int y) {
		g.drawRoundRect(x+1,y+1, w-2,h-2,6,6);
		Rectangle r=g.getClipBounds();
		g.setClip(0,0,w,h);
		g.drawString(s,x+2,y+16);
		g.setClip(r);
	    }
	};
    }
    
    //filter makes all color same as top-left pixel transparent, maybe rather inefficient method
    static ImageIcon filter(URL u) {
	if (icons.get(u)==null)  {
	    try {
		BufferedImage bi=javax.imageio.ImageIO.read(u);
		BufferedImage bi2=new BufferedImage(bi.getWidth(), bi.getHeight(),  BufferedImage.TYPE_INT_ARGB);
		int mask=bi.getRGB(0,0);
		for (int x=0; x<bi.getWidth(); x++) for (int y=0; y<bi.getHeight(); y++) bi2.setRGB( x,y,
			bi.getRGB(x,y)==mask ? 0 : bi.getRGB(x,y)
			);
		icons.put(u, new ImageIcon(bi2));
	    } catch (Exception e) { deb(e); return null; }
	}
	return icons.get(u);
	//return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(i.getImage().getSource(), new jcmImageFilter())));
    }
    
}
