/*
A tool to view the java source code
 */

package jcm.gui.doc;
import static  jcm.core.report.*;


import java.awt.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.text.html.HTMLDocument;
import jcm.StartJCM;
import jcm.core.tls.cs;
import jcm.core.tls.fileio;

public class sourceview extends JScrollPane {
    
    static String[] keywords= {   "public ", "static ", "void ", "class ", "interface ", "enum ",    "float ", "double ", "byte ", "short ",  "int ", "long ", "char ",    "if", "for", "while", "do" ,   "import ", "extends ", "package ", "abstract ", "try ", "catch ", "instanceof ", "new ", "return " 	};
    static String[] braks={ "{", "}", "[", "]", "(", ")"}, ops= {"+", "-", "*", "/", "=", "|", "&", ".", ",", ";", ":", "?", "%"};
    static String[] seps={":", ",", ";"};
    
    static String note=    
            "<i><font color=brown>Code viewed from JCM with revision date: "+StartJCM.revisiondate+", viewed at "+ new Date(System.currentTimeMillis()).toGMTString()+"</font></i><br>"+
            "<i><font color=green>This code is extracted from the archive source.jar, check this is up-to-date with the code used to compile JCM.jar! <br>"+
            "To explore the source code in depth, it is recommended to use an IDE such as Netbeans</font></i><br>"+
            "<font color=blue>(C)Please note conditions of use in JCM documentation</font><hr><p>";
    
    static String header1="<h3>JCM source code ", header2="</h3>"; 
    
    JEditorPane ta;
    public sourceview(String name) {
	ta= new JEditorPane();
	
	setName(name);
	setPreferredSize(new Dimension(300,400));
	
//	if (name.endsWith("java") || name.endsWith("html") || name.endsWith("png")) {
	ta.setContentType("text/html;");
	setcodebase("/png/");
	ta.setText(gettext(name));
	setViewportView(ta);
    }
    
    void setcodebase(String s) {
	try{
	    ((HTMLDocument) ta.getDocument()).setBase(getClass().getResource(s));
	} catch (Exception e) {	deb(e); }	
    }
    
    String gettext(String name) {
	
	if (name.endsWith(".png") || name.endsWith(".jpg")) { 
	    int i=name.lastIndexOf("/")+1;
	    setcodebase("/"+name.substring(0,i));
	    return "<h3>"+name+"</h3><hr><img src="+name.substring(i)+" >";
	}
	
	log("loading "+name);
	String f=fileio.loadstring(name);
	
	if (f=="") return "<font color=red><i>Problem loading  "+name+ "</i></font>";
	
	
	cs s=new cs(f);
	
	if (name.endsWith("java")) {
	    s.swap("<","ÈÈ").swap(">", "ËË");
	    
	    s.surround("//", "<i> @@@@ " , "\n<@@i>", "\n"); //must be before remove \n
	    s.surround("/*", "<i> @@µµ " , " µµ@@ <@@i>", "*/");
	    
	    for (String k: ops) s.simplesurround(k, "<font colorÁÁred>", "<@@font>");
	    s.swap("µµ", "*").swap("ÁÁ", "=").swap("@@", "/").swap("ÈÈ", "<font color=red>&lt;</font>").swap("ËË", "<font color=red>&gt;</font>");;
	    
	    for (String k: keywords) s.simplesurround(k, "<font color=green>", "</font>");
	    for (String k: braks) s.simplesurround(k, "<font color=blue>", "</font>");
	    
	    s.swap("\n\n", "</nobr><p><nobr>");
	    s.swap("\n", "</nobr><br><nobr>");
	    s.swap("\t","<font color=white>TAB</font>" );
	    
	    return header1+name+header2+note+s.toString();
	} else {
	    s.swap("\n\n", "</nobr><p><nobr>");
	    s.swap("\n", "</nobr><br><nobr>");
	    if (s.s.length()<100000) {//causes memory out of heap space for some big data files
		s.swap("\t","<font color=white>TAB</font> " );
		for (String k : seps) s.simplesurround(k,  "<font color=red>", "</font>");
	    }
	    return "<h3>"+name+"</h3><hr>"+s.toString();
	}
	
    }
    
}
