

package jcm.core.reg;
import java.awt.*;
import jcm.core.reg.*;
import static jcm.core.report.*;

public class regpoly extends Polygon {
    boolean wrapping=false;
    
    public void addpoint(Point p) { addPoint(p.x, p.y); } //(int)(4*Math.random()-2), p.y+(int)(4*Math.random()-2));
    
    
    public void addedge(edge e, boolean forwards) {
	if (forwards) {
	    if (e.left.gt(e.from)) addpoint(e.from.fef(e.left, e.right).p[0]); //add first point from other edge
	    for (int i=0; i<e.p.length; i++) addpoint(e.p[i]); //remaining points (exc last)
	} else {	//reverse
	    addpoint( e.to.gt(e.left) ?  e.left.fef(e.to, e.right).p[0] : e.to.fef(e.right, e.left).p[0] ); //add first point -always from other edge for reverse
	    for (int i=e.p.length-1; i>=(e.left.gt(e.from) ?  0 : 1); i--) addpoint(e.p[i]); //remaining points - skip last if it is the first point (will be in next edge)
	}
    }
    
    //two methods below don't work in old microsoft JVM
    public boolean intersects(int x, int y, int w, int h) {	try {	return super.intersects(x,y,w,h); } catch (Error e) {	return true; } }
    public boolean contains(int x, int y, int w, int h) {	try {	return super.contains(x,y,w,h); } catch (Error e) {	return false; }	}
    
} //end class

/*
 an edge stores a list of points, between  countries left, right, from, to
 points stored only for  left<right
 first point stored only for left<from
 */

class edge {
    region left, right, from, to;
    Point[] p=new Point[0];
    edge(region l, region r, region f, region t) {	left=l; right=r; from=f; to=t; }
    edge() {	}
    boolean internal() {	return left.name.substring(0,3).equals(right.name.substring(0,3)); }
    
    String info() {	try {	return " l="+left.name + " r="+right.name + " f=" + from.name + " t="+to.name; } catch (RuntimeException e) {	return " noinfo "; }}
    
    float length() { try {
	float len=0; int i=0; Point a, b;
	if (left.gt(from)) a=from.fef(left, right).p[0]; else { a=p[0]; i=1; } //first point
	for (;i<p.length; i++) { b=p[i];  len+=len(a, b); a=b; } //middle points
	b= left.lt(to) ?  left.fef(to, right).p[0] : to.fef(right, left).p[0]; len+=len(a, b);  //last  point
	return len;
    } catch (Exception e) { deb(e, "regpoly"); return 0; }
    }
    
    static float len(Point a, Point b) { //note this is very inefficient
	float dy=a.y-b.y, yav=(a.y+b.y)/2, dx=(a.x-b.x)* (float)Math.cos((Math.PI*yav)/180.0);
	return (float) Math.sqrt(dx*dx+dy*dy );
    }
}

	/*
	public regpoly intersect (regpoly b) {
	Point p; Polygon c;
	for (int i=0; i<b.npoints-1; i++) p=intersect(xpoint[i], ypoint[i], xpoint[i+1], ypoint[i+1], b.xpoint[j], b.ypoint[j], b.xpoint[j+1], b.ypoint[j+1]);
	}
	 
	public static Point intersect(int x1s, int y1s, int x1e, int y1e, int x2s, int y2s, int x2e, int y2e) {
	m1=(y1e-y1s)/(x1e-x1s), c1=y1-m1*x1;
	m2=(y2e-y2s)/(x2e-x2s), c2=y2-m2*x2;
	xi=(c2-c1)/(m1-m2), yi=m1*xi+c1;
	if (xi>x1s) && (xi<x2s) return new Point(xi,yi) else return null;
	}
	 */

