/*
 ROOT
 contains the root of the infob heirachy,
 also unpacks the JAR package to discover available resources
 contains the static code that used to be in world
 */
package jcm.core.ob;

import java.awt.Color;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import jcm.core.*;
import jcm.core.tls.fileio;
import static jcm.core.report.*;
import jcm.gui.nav.filter;

public class root {
    
    //note used to be called JCM5 root - autodoc also changed
    public static infob rootob=new packageob("JCM root"); // the "static" list of available classes (including modules)
    static {rootob.level=1;}
    
    public static Set<String> packages=new HashSet(); // is this ever used? 
    
    //************* MAKE ROOT ************
    //called only at startup, to fill root by searching through jar for classes
    
    public static void makeroot() {
	String[] tofind={"/jcm/StartJCM.class", "/lucdata/lu_A_1700.png", "/match-emitdata/CH4_agwa_best_A1B.tab"};
	//NOTE: add a file for each extra jar to include - if want data to be displayable from tree
	for (String s: tofind) makeroot(s);
	infob docroot=new infob("mainmenu", rootob); docroot.addAction(filter.filtertype.Doc); 	rootob.addOb(docroot);
    }
    
    public static void makeroot(String seek) {
	Enumeration<JarEntry> jes=fileio.getJarEntries(world.class.getResource(seek));
	if (jes==null) { log("can't find "+seek); return; }
	log("Exploring Package: ");
	while ( jes.hasMoreElements() )  {
	    JarEntry je=jes.nextElement();
	    String s= je.getName();
	    if (je.isDirectory()) { packages.add(s.replace("/", ".")); log("-"+s); }
	    if (!je.isDirectory() && !(je.getName().contains("$")))  { // note $ implies inner class
		addtree(rootob, s);
	    }
	}
	rootob.color=Color.black;
    }
    
    static String[] exclude= new String[]{ "png", "todo", "META-INF"};
    
    public static void addtree(infob th, String s) {
	for (String e  : exclude) if (s.startsWith(e)) return;
	int i=s.indexOf("/");
	String s1, s2;
	if (i>0) { // it's a folder'
	    s1=s.substring(0,i); s2=s.substring(i+1);
	    if (th.getObs()!=null) for (infob o : th.getObs()) {
		if (o.getName().equals(s1)) {
		    addtree(o, s1+"."+s2);  return; //CHANGE was just S2
		}
	    }
	    boolean ispackage=s.startsWith("jcm");
	    infob hh= (ispackage ? new packageob(s1, th) : new infob(s1, th));
	    
	/*
	 changed infob to packageob, to include doc for low-level packages! (both extradoc, and in tree)
	 note - don't want too many packageobs, because then doc filter opens everything!
	 */
	    addtree(hh, s1+"."+s2); //CHANGE was just S2
	    if (hh.getObs()!=null) {  th.addOb(hh); }
	    return;
	} // if its a file not a folder
	infob rootob=new infob( s.replace(".class", ""), th);
	rootob.addClassActions();
	th.addOb(rootob);
    }
    
} //end class

//******************* PATH ***************
//    public static String getPath(infob th) {
//	String ss=th.getName();
//	// below no longer necessary, since the infob name now stores the dots
////	//hasinfo h=th; while (h.getOwner()!=root) { h=h.getOwner(); ss=h.getName()+"."+ss; }
//	return ss;
//    }