
package jcm.core.cur;

import java.util.*;
import javax.swing.Action;
import jcm.core.*;
import jcm.core.itf.*;
import jcm.core.ob.*;
import jcm.gui.nav.*;
import jcm.gui.doc.labman;
import static  jcm.gui.gen.colfont.*;
import static jcm.core.report.*;
import static jcm.core.cur.curve.Type.*;
import jcm.gui.nav.jcmAction;


/**
 contains static methods for finding / making derivatives of curvesets
 @see curvesetvar
 */
public class makederiv {
    
    //    Map of potential qtsets to make variants: stored for efficiency - but note this can get quite big!
    // could be more efficient to store for example one list of all the regional qtsets
    static Map<curveset, Map<module, List<curveset>>> potLink =new HashMap();
    
    
    //***************  MAKE VARIANT MENU ******************
    /** make the create- variant menu used in the tree and on right-click
     */
    //this keeps making new actions and menus then throwing them away again! - inefficient?
    public static jcmMenu makevariantmenu(final curveset base) {
        jcmMenu submenu=new jcmMenu("CreateVariant");
        submenu.add(new jcmAction( "percent&change&per&yr") { public void act() {  addnewderiv(ratefrac, base); }});
        submenu.add(new jcmAction( "percent&of&total") { public void act() {  addnewderiv(frac, base); }});  //this used to be added in reg below only for region qtsets!
        submenu.add(new jcmAction( "derivative") { public void act() {  addnewderiv(rate, base); }});
        submenu.add(new jcmAction( "integral") { public void act() {  addnewderiv(integral, base); }});
        submenu.add(new jcmAction( "smooth") { public void act() {  addnewderiv(smooth, base); }});
        submenu.add(makeDerivMenu(ratio, base));
        submenu.add(makeDerivMenu(difference, base));
        submenu.addSeparator();
        if (world.worlds.size()>1) submenu.add(compareworldmenu(base));
        submenu.addSeparator();
        submenu.add(new jcmAction("Refresh Options") {   public void act() {refreshopts(base);   }});
        return submenu;
    }
    
    //*************** ADD DERIVATIVE QTSETS **************
    //shortcut methods
    public static void addnewderiv(curve.Type type, curveset ... qq) { addderiv(qq[0], new curvar(type, qq)); }
    public static void addnewderiv(curve.Type type, List<curveset> qq) { addderiv(qq.get(0), new curvar(type, qq)); }
    
    /**adds a derivative to the ob tree
     (note this is for temporary qtsets added after tree is open - for hardcoding permanent variants, just addOb should be sufficient)
     */
    public static void addderiv(curveset base, curveset qd) {
        if (qd==null) return;
        base.addOb(qd);
        qd.temporary=true;
        qd.justadded=true; jcmTree.restruclink.changed=true; //signal to tree to open it
        qd.owner=base;
        if (qd.type==qd.type.smooth)  qd.setaffectedby(curve.smoothtype, curve.smoothinterval);
        //P4 check this disposes OK
        loop.golater("qtset add-deriv");
    }
    
    
    //************* FIND POTENTIAL DERVATIVES ********
    
    /** make a menu of potential derivatives of a specific type,  based on a starting curveset.
     <br> The choice depends on the type:
     <br> e.g. if type = ratio, any pairs sharing some common keys will be available
     <br> but if type = difference, the units also have to be the same
     */
    public static jcmMenu  makeDerivMenu(curve.Type type, curveset base) {
        if (potLink.get(base)==null)  findPotLink(base);
        Map<module, List<curveset>> pl=potLink.get(base);
        if (pl.size()>0)  {
            jcmMenu dm=new jcmMenu(type+":");
            
            //same name in other worlds
            for (java.util.List<curveset> qqs : pl.values()) for (curveset qqd : qqs) if (qqd.name.equals(base.name)  && checkUnitsMatch(base, qqd, type)) dm.add(addVariantAction(qqd.getworld().name, base, qqd, type));
            dm.addSeparator();
            
            //other modules (in same order that findPotLink searched)
            for (module m : pl.keySet()) {
                jcmMenu submenu=new jcmMenu(labman.getTitle( m.getworld()==base.getmodule().getworld() ? m.getName() : m.getFullName()));
                for (final curveset qqd : pl.get(m)) if (qqd.checkcomplexity()  && checkUnitsMatch(base, qqd, type)) submenu.add(addVariantAction(qqd.getTitle(), base, qqd, type));
                if (submenu.list.size()>1) dm.add(submenu);
                if (submenu.list.size()==1)  dm.add(submenu.list.get(0));
                //note it might be zero, due to complexity
            }
            return dm;
        }
        return null;
    }
    
    
    
    /*********** potlink *************
     can combine with any curveset with same name (eg in other world)
     or any curveset containing some common keys
     beware checking this is slow - so a map of these is stored, made on first calling makederivmenu,  recalculated when "refresh options" is called
     search the modules in the order we want to view the results (ie same module, same package, same world, others...)
     */
    static void findPotLink(curveset base) {
        try {
            if (potLink.get(base)==null) potLink.put(base, new LinkedHashMap());
            potLink.get(base).clear();
            
            module mod=base.getmodule();
            
            checkmod(base, mod);
            for (infob io : mod.owner.getObs()) if (io!=mod && io instanceof module) checkmod(base, (module)io);
            for (module m : mod.getworld().mods) if (m!=mod && m.owner!=mod.owner) checkmod(base, m);
            for (world w : world.worlds) if (w!=mod.getworld()) for (module m : w.mods)  checkmod(base, m);
        } catch (Exception e) { deb("makederiv findPotLink "+base+" => "+e); }
    }
    
    
    static void checkmod(curveset base, module m) {
        List<curveset> fit=new LinkedList();
        
        for (final curveset qqd : m.curvesets)  if (!qqd.equals(base)) {
            checkoverlap(fit, base, qqd);
        }
        if (fit.size()>0) potLink.get(base).put(m,fit);
        
    }
    
    static void  checkoverlap(List<curveset> fit, curveset base, curveset qqd) {
        //  deb("\n\nrun checkoverlap +"+qqd.name+"\n\n");
        if (qqd.obs!=null) for (infob o : qqd.obs) if (o instanceof curveset) {
            //deb("makederiv found "+o.name);
            checkoverlap(fit, base, (curveset)o);
        }
        if (qqd.name.equals(base.name)) { fit.add(qqd);  return; }
        for (Object o : qqd.map.keySet()) if (base.map.containsKey(o)) { fit.add(qqd);  return; }
        
    }
    
    
//*********** refresh ************
//force calc using  temporary plotlink to self,  -called by Refresh Options action -  is this the best way?
    static void refreshopts(curveset base) {
        if (base.changed) {
            plotlink p=new plotlink() {
                public boolean isShowing() { return true; }
                public void doplot() {}
            };
            register.addlink(p, base); loop.gonow(); register.removelink(p, base);
        }
        findPotLink(base);
    }
    
//************ units *******************
    static boolean checkUnitsMatch(curveset base, curveset qqd, curve.Type type) {
        if (type==ratio) return true;
        if (type==extra) return checkUnitsMatch(((curvar) base).linkqq.get(0), qqd, curve.Type.sum);
        return  base.units.substring(base.units.indexOf("&")+1).equals(qqd.units.substring(qqd.units.indexOf("&")+1));
        //assumes there is a mega/giga etc. before &, see also method units.sameAs, however qtset units is just a string
    }
    
//************ action ***********
//to actually create the selected variant
    static  Action addVariantAction(String name, final curveset base, final curveset qqd, final curve.Type type) {
        return new jcmAction(name)  { public void act() {
            if (type==ratio)  addnewderiv(ratio, base, qqd);
            if (type==difference)   addnewderiv(difference, base, qqd);
            if (type==extra) ((curvar)base).addLink(qqd); //for histoplot and XYplot
        }};
    }
    
    
    
//****************** COMPARE WORLD *************************
    /** make a derivative curveset, using the curve whose name matches the string, comparing all worlds (used by setup) */
    public static curveset compareworld(curveset base, String name) {
        //for (Object key : map.keySet()) deb("check: "+key+ " = "+name+" ? "+key.equals(name));
        for (Object key : base.map.keySet())  if (key.toString().equals(base.name)) return compareworld(base, base.map.get(key));
        return null;
    }
    
    /** make a derivative curveset, using the curve specified, comparing all worlds */
    public static curveset compareworld(curveset base, curve q) {
        deb("compare worlds "+q.name);
        curveset cwq=new curveset("Compare&"+q.name, base.units, base.sy, base.ey, base.xstep);
        cwq.register();
        for (world w : world.worlds)  for (module m : w.mods)  for (curveset mqq : m.curvesets)  if (mqq.name.equals(base.name))  {
            for (Object key : base.map.keySet()) if (base.map.get(key)==q)  try {
                cwq.addcurve(w.name, new curve(mqq.map.get(key).geta(), w.name, w.color , base.sy, base.ey, base.xstep));
                //note - this new qt contains a reference to the same data array as the original, just has different name & color
            } catch (NullPointerException e) { deb("cannot find curve "+key+" for "+w.name); }
            cwq.setaffectedby(m);
        }
        return cwq;
    }
    /** make a menu of curves, one of which may be selected for comparing worlds*/
    public static jcmMenu compareworldmenu(final curveset base) {
        jcmMenu cwm=new jcmMenu(" Compare Worlds... ");
        for (final curve q : base.map.values())   cwm.add(new jcmAction("Compare&"+q.name) {
            public void act() {  addderiv(base, compareworld(base, q)); }
        });
        return cwm;
    }
    
    
    
    
}
