
package jcm.core.cur;

import java.util.*;
import jcm.core.*;
import jcm.gui.nav.*;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.plot.*;
import static  jcm.gui.gen.colfont.*;
import static jcm.core.report.*;
import static jcm.core.cur.curve.Type.*;

/**
 an extension of curveset to make variants of existing curvesets:- ratios, differences, etc.
 typically will be created by user via the create-variant menu
 most variants do not hold independent data arrays, but calculate on demand - retaining interactions with their parent curvesets
 variants will be saved by setup
 */
public class curvar extends curveset  {
    
    /** list of the parent curvesets - usually only 1,2 or 3 depending on type*/
    public List<curveset> linkqq;
    
/* notes:
     could be extended to pointer / forking curvesets
    note also  qa and qb in curve
 */
    
    
    //*************** CONSTRUCTION ******************
    /**  var-args variant of the List<curveset> constructor   */
    public curvar(curve.Type type, curveset ... qqq) { this.type=type;  linkqq=new ArrayList(3);  for (curveset qq : qqq) linkqq.add(qq);    setup();    }
    /** variant curvesets are constructed by reference to a curve.Type and at least one existing curveset<ul>
     <li>One curveset is enough for types such as rate, frac
     <li>Two are needed for  types  such as ratio, difference, sum (<i> for example, type.ratio, emissions, population => emissions per capita</i>)
     <li>Three or more curvesets are used for making histograms and XY scatterplots
     </ul>
     The name and color, units and timescale etc. are derived from the parent curvesets
     */
    public curvar(curve.Type type,  List<curveset> lqq) { this.type=type; linkqq=lqq; setup(); }
    
    void setup() {
	for (curveset qq : linkqq) {
	    setaffectedby(qq); //beware this interaction will remain until disposed! -  although adding extra is called by a plot!
	}
	curveset base =linkqq.get(0), other= linkqq.size()>1 ? linkqq.get(1) : null;
	
	name= other==null ?  base.name+"&"+type
		: base.name+"&"+(
		type==type.ratio ? "per"
		: type==type.sum ? "plus"
		: type==type.difference ? "minus"
		: ""
		) +"&"+other.name;
	
	units= type==type.rate ? base.units+"&per&year"
		:  type==type.ratefrac ? "percent&per&year"
		: type==type.integral ? base.units+"&integral"
		: type==type.frac ? "percent"
		: type==type.ratio ? base.units+"&per&"+other.units
		: base.units;
	
	sy=base.sy;	ey=base.ey;	xstep=base.xstep;
	color=base.color;
	owner=base;
	
	//make the curves
	if (other==null) {
	    for (Object k : (type== type.frac ? base.mapwithouttotal().keySet() : base.map.keySet())) addcurve(k, new curve(base.map.get(k), type, base) ); //ref to this only really necessary for frac type -see curve get
	} else {
	    for (Object k : base.map.keySet()) if (other.map.containsKey(k))  addcurve(k, new curve(base.map.get(k), other.map.get(k), type, base) );
	}
	
	addActions();
	register();
	changed=true; loop.golater("made curveset variant => loop golater"); //this will make plots repaint
    }
    
    
    //only used by add-extra
    void addLink(curveset qq) {
	linkqq.add(qq);
	setaffectedby(qq);
	changed=true; loop.golater("made curveset variant => loop golater"); //this will make plots repaint
    }
    
    
    
    //*************** OVERRIDING curveSET METHODS  ******************
    
    /** make derivative curves (which can claulate ratios, differences etc.) */
    public curve makecurve(Object key) {
	switch (type) {
	    case difference :   case sum :  case ratio : return new curve(linkqq.get(0).map.get(key), linkqq.get(1).map.get(key), type, owner);
            case frac : case rate : case ratefrac : case integral : case smooth:  return new curve(linkqq.get(0).map.get(key), type, owner);
	    default : return super.makecurve(key);
	}
    }
    
    /** add actions for histogram and scatteplot */
    void addExtraPlotAction() {
	if (type==type.ratio) {
	    addAction(filter.filtertype.Curves, showpan.pan("Histogram", histoplot.class, this));
	    addAction(filter.filtertype.Curves, showpan.pan("Scatter/XYplot", XYplot.class, this));
	}
    }
    
    /** wiki-doc: shows summary of the curvesets  from which this is dervied */
    public String docCurves() {
	if (linkqq==null) return super.docCurves();
	String s="==Curves==";
	s+=labman.getTitle(type+"&of&");
	for (curveset qq : linkqq) s+=qq.docSummary()+"<br>";
	return s;
    }
    
    /** gets value for key and year ( if key not found, makes a new curve,  which may be able to calculate a value)  */
    public float get(Object r, int year) { return getOrAddCurve(r).get(year); }
    /** gets value for key, in current module.year (if key not found, makes a new curve ,  which may be able to calculate a value)  */
    public float get(Object r) {return getOrAddCurve(r).get();}
    
    
    //********************
    /** used by baseplot to remake curves in response to change of region set */
    public void refreshregs() {
	if (type!=normal) {
	    map.clear(); for (Object o : type==type.frac ? linkqq.get(0).mapwithouttotal().keySet() :  linkqq.get(0).map.keySet()) getOrAddCurve(o);
	}
    }
    
    
    //************ MAKE VARIANT MENU ****************
    
    /** add a remove option to parent method */
    public void fillMenu(jcmMenu pop, Set<filter.filtertype> fs) {
	super.fillMenu(pop, fs);
	if (temporary) {
	    pop.addSeparator();
	    pop.add(new jcmAction("Remove") { public void act() { owner.removeOb(curvar.this); disposeLater();   }} );
	}
    }
    
    
    
} //end class
