/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODScrollButton;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class NimRODScrollBarUI
extends MetalScrollBarUI {
    private boolean clicked;
    private boolean rollOver;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODScrollBarUI();
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MiML(this);
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new NimRODScrollButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new NimRODScrollButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Color color;
        Color color2;
        Color color3 = UIManager.getColor("ScrollBar.thumb");
        Color color4 = UIManager.getColor("ScrollBar.thumbShadow");
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(color3);
        graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(this.rollOver ? color4.darker() : color4);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        Icon icon = null;
        icon = this.scrollbar.getOrientation() == 0 ? UIManager.getIcon("ScrollBar.horizontalThumbIconImage") : UIManager.getIcon("ScrollBar.verticalThumbIconImage");
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = (rectangle.width - n) / 2;
        int n4 = (rectangle.height - n2) / 2;
        if (this.scrollbar.getOrientation() == 0 && rectangle.width >= n || this.scrollbar.getOrientation() == 1 && rectangle.height >= n2) {
            icon.paintIcon(jComponent, graphics, n3, n4);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = null;
        if (this.clicked) {
            color2 = NimRODUtils.getSombra();
            color = NimRODUtils.getBrillo();
        } else {
            color2 = NimRODUtils.getBrillo();
            color = NimRODUtils.getSombra();
        }
        gradientPaint = this.scrollbar.getOrientation() == 0 ? new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.x, rectangle.height, color) : new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.width, rectangle.y, color);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(rectangle);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = null;
        gradientPaint = this.scrollbar.getOrientation() == 0 ? new GradientPaint(rectangle.x, rectangle.y, NimRODUtils.getSombra(), rectangle.x, rectangle.y + rectangle.height, NimRODUtils.getBrillo()) : new GradientPaint(rectangle.x, rectangle.y, NimRODUtils.getSombra(), rectangle.x + rectangle.width, rectangle.y, NimRODUtils.getBrillo());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(rectangle);
    }

    public class MiML
    extends BasicScrollBarUI.TrackListener {
        NimRODScrollBarUI papi;

        public MiML(NimRODScrollBarUI nimRODScrollBarUI2) {
            super(NimRODScrollBarUI.this);
            this.papi = nimRODScrollBarUI2;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            this.papi.rollOver = true;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            this.papi.rollOver = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this.papi.clicked = true;
            NimRODScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            this.papi.clicked = false;
            NimRODScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (this.papi.rollOver && !NimRODScrollBarUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                NimRODScrollBarUI.this.rollOver = false;
                NimRODScrollBarUI.this.scrollbar.repaint();
            } else if (!this.papi.rollOver && NimRODScrollBarUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.papi.rollOver = true;
                NimRODScrollBarUI.this.scrollbar.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (this.papi.rollOver && !NimRODScrollBarUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                NimRODScrollBarUI.this.rollOver = false;
                NimRODScrollBarUI.this.scrollbar.repaint();
            } else if (!this.papi.rollOver && NimRODScrollBarUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.papi.rollOver = true;
                NimRODScrollBarUI.this.scrollbar.repaint();
            }
        }
    }
}

