/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODIconFactory;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.plaf.metal.MetalIconFactory;

public class NimRODCheckBoxUI
extends MetalCheckBoxUI {
    boolean oldOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODCheckBoxUI();
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.oldOpaque = abstractButton.isOpaque();
        abstractButton.setOpaque(false);
        this.icon = NimRODIconFactory.getCheckBoxIcon();
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setOpaque(this.oldOpaque);
        this.icon = MetalIconFactory.getCheckBoxIcon();
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        if (this.oldOpaque) {
            Dimension dimension = jComponent.getSize();
            Container container = jComponent.getParent();
            if (container != null) {
                if (container.getClass() == CellRendererPane.class) {
                    graphics.setColor(jComponent.getBackground());
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                } else if (container instanceof JTable) {
                    graphics.setColor(((JTable)container).getSelectionBackground());
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                } else if (container instanceof JList) {
                    graphics.setColor(((JList)container).getSelectionBackground());
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        NimRODUtils.paintFocus(graphics, 1, 1, dimension.width - 2, dimension.height - 2, 8, 8, NimRODLookAndFeel.getFocusColor());
    }
}

