/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonUI;

public class NimRODButtonUI
extends MetalButtonUI {
    protected MiListener miml;
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODButtonUI();
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setBorder(NimRODBorders.getButtonBorder());
        this.selectColor = NimRODLookAndFeel.getFocusColor();
    }

    public void unsinstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setBorder(MetalBorders.getButtonBorder());
    }

    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.miml = new MiListener(abstractButton);
        abstractButton.addMouseListener(this.miml);
        abstractButton.addPropertyChangeListener(this.miml);
        abstractButton.addFocusListener(this.miml);
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        abstractButton.removeMouseListener(this.miml);
        abstractButton.removePropertyChangeListener(this.miml);
        abstractButton.removeFocusListener(this.miml);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (!this.oldOpaque) {
            return;
        }
        if (abstractButton.isContentAreaFilled()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(NimRODUtils.getColorAlfa(this.selectColor, 100));
            RoundRectangle2D.Float float_ = this.hazBoton(abstractButton);
            graphics2D.fill(float_);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (!abstractButton.isFocusPainted() || !this.oldOpaque) {
            return;
        }
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        NimRODUtils.paintFocus(graphics, 3, 3, abstractButton.getWidth() - 6, abstractButton.getHeight() - 6, 2, 2, NimRODLookAndFeel.getFocusColor());
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.oldOpaque = jComponent.isOpaque();
        if (jComponent.getParent() instanceof JToolBar) {
            super.update(graphics, jComponent);
        } else {
            jComponent.setOpaque(false);
            super.update(graphics, jComponent);
            jComponent.setOpaque(this.oldOpaque);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
        if (this.oldOpaque) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Float float_ = this.hazBoton(jComponent);
            graphics2D.clip(float_);
            graphics2D.setColor(NimRODLookAndFeel.getControl());
            graphics2D.fill(float_);
            if (jComponent.getParent() instanceof JToolBar) {
                if (buttonModel.isRollover() || buttonModel.isPressed() || buttonModel.isSelected()) {
                    jComponent.setBorder(NimRODBorders.getGenBorder());
                } else {
                    jComponent.setBorder(NimRODBorders.getEmptyGenBorder());
                }
                if (buttonModel.isPressed() || buttonModel.isSelected()) {
                    graphics2D.setColor(NimRODLookAndFeel.getFocusColor());
                    graphics2D.fill(float_);
                }
            } else {
                GradientPaint gradientPaint = null;
                gradientPaint = buttonModel.isPressed() || buttonModel.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODUtils.getSombra(), 0.0f, jComponent.getHeight(), NimRODUtils.getBrillo()) : new GradientPaint(0.0f, 0.0f, NimRODUtils.getBrillo(), 0.0f, jComponent.getHeight(), NimRODUtils.getSombra());
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(float_);
                if (buttonModel.isRollover()) {
                    graphics2D.setColor(NimRODUtils.getRolloverColor());
                    graphics2D.fill(float_);
                }
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        super.paint(graphics, jComponent);
    }

    private RoundRectangle2D.Float hazBoton(JComponent jComponent) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float();
        float_.x = 0.0f;
        float_.y = 0.0f;
        float_.width = jComponent.getWidth();
        float_.height = jComponent.getHeight();
        float_.arcwidth = 8.0f;
        float_.archeight = 8.0f;
        return float_;
    }

    public class MiListener
    extends MouseInputAdapter
    implements PropertyChangeListener,
    FocusListener {
        private AbstractButton papi;

        MiListener(AbstractButton abstractButton) {
            this.papi = abstractButton;
        }

        public void refresh() {
            if (this.papi != null && this.papi.getParent() != null) {
                this.papi.getParent().repaint(this.papi.getX() - 5, this.papi.getY() - 5, this.papi.getWidth() + 10, this.papi.getHeight() + 10);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.papi.getModel().setRollover(true);
            this.refresh();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.papi.getModel().setRollover(false);
            this.refresh();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.papi.getModel().setRollover(false);
            this.refresh();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.papi.getModel().setRollover(false);
            this.refresh();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.refresh();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.refresh();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.refresh();
        }
    }
}

