/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import jcm.core.cur.curveset;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.showpan;
import jcm.gui.plot.lineplot;
import jcm.script.calcscript;

public class plot_contribtemp_1
extends calcscript {
    Map<String, curveset> regionCurves = new HashMap<String, curveset>();
    static String[] regionsChosen = new String[]{"United States", "Japan", "China", "India", "Canada", "Oceania", "North Europe", "South EU +France", "East Europe +Ukraine", "Russia", "Central Asia Stans", "Turkey", "Arabia", "Iran Pakn Afgn", "Other East Asia", "South East Asia", "Indonesia", "Central America", "Bolivia to Guiana", "Argta Chile Pgy Ugy", "Brazil.", "North Africa", "Sahel (Africa)", "Central Africa", "Southern Africa"};
    Map<String, Float> prob = new HashMap<String, Float>();
    boolean storeprob = true;

    public void run() {
        lineplot.thin = 500;
        for (String s : regionsChosen) {
            this.checkbut();
            this.regionCurves.put(s, new curveset(s, 1850, 2005, 5));
            report.log(s);
            File f = new File("results" + this.fs + s + ".tab");
            String[][] s1 = fileio.loadtab(f, "\t");
            for (int r = 0; r < s1.length; ++r) {
                int c;
                String line = "";
                if (r == 0) {
                    for (c = 1; c < s1[0].length; ++c) {
                        this.regionCurves.get(s).getOrAddCurve(s1[0][c]);
                        String[] parts = txt.split(s1[0][c], new String[]{" ", "_"});
                        if (this.storeprob) {
                            this.prob.put(s1[0][c], Float.valueOf(Float.parseFloat(parts[parts.length - 1]) - 440.0f));
                        }
                        try {
                            Color col;
                            this.regionCurves.get((Object)s).getOrAddCurve((Object)s1[0][c]).color = col = new Color((double)Float.parseFloat(parts[parts.length - 4]) > 0.5 ? 200 : ((double)Float.parseFloat(parts[parts.length - 4]) > 0.2 && (double)Float.parseFloat(parts[parts.length - 4]) < 0.5 ? 100 : 0), parts[0].equals("IVIGmodel-A_") ? 225 : (parts[0].equals("IVIGmodel-B_") ? 150 : (parts[0].equals("IVIGmodel-B/ISAM_") ? 75 : 0)), parts[0].equals("Houghton_") ? 225 : 0, (int)(4000.0f / (Float.parseFloat(parts[parts.length - 1]) - 430.0f)));
                            continue;
                        }
                        catch (Exception e) {
                            String sss = "";
                            for (String ss : parts) {
                                sss = sss + ss + "\t";
                            }
                            report.log("color out of range " + sss);
                        }
                    }
                    this.storeprob = false;
                    continue;
                }
                for (c = 1; c < s1[0].length; ++c) {
                    this.regionCurves.get(s).set(s1[0][c], (int)Float.parseFloat(s1[r][0]), Float.parseFloat(s1[r][c]));
                }
            }
            System.gc();
        }
        report.log("All tables loaded");
        this.pdf();
        this.end();
    }

    void pdf() {
        curveset pdf = new curveset("pdf", "%", 0, 300, 1);
        curveset cumf = new curveset("cumf", "%", 0, 300, 1);
        for (String s : regionsChosen) {
            int z;
            for (z = 0; z <= 1000; ++z) {
                pdf.set(s, z, 0.0f);
                cumf.set(s, z, 0.0f);
            }
            pdf.getOrAddCurve((Object)s).color = regman.allreg.findreg((String)s).color;
            cumf.getOrAddCurve((Object)s).color = regman.allreg.findreg((String)s).color;
            for (String n : this.prob.keySet()) {
                int z2 = (int)(this.regionCurves.get(s).get(n, 2000) * 10.0f);
                pdf.set(s, z2, pdf.get(s, z2) + this.prob.get(n).floatValue());
            }
            for (z = 1; z <= 1000; ++z) {
                cumf.set(s, z, cumf.get(s, z - 1) + pdf.get(s, z - 1));
            }
        }
        JComponent c1 = this.plot(pdf);
        ((lineplot)c1).xscale.min = 0.0;
        ((lineplot)c1).xscale.max = 300.0;
        ((lineplot)c1).xscale.changed = true;
        ((lineplot)c1).doplot();
        imagesaver.saveimage((Component)c1, "png", new File("results" + this.fs + pdf + ".png"));
        JComponent c2 = this.plot(cumf);
        ((lineplot)c2).xscale.min = 0.0;
        ((lineplot)c2).xscale.max = 300.0;
        ((lineplot)c2).xscale.changed = true;
        ((lineplot)c2).doplot();
        imagesaver.saveimage((Component)c2, "png", new File("results" + this.fs + cumf + ".png"));
    }

    void plotandsave(String s) {
        JComponent c1 = this.plot(this.regionCurves.get(s));
        imagesaver.saveimage((Component)c1, "png", new File("results" + this.fs + s + ".png"));
        report.log("results" + this.fs + s + ".png");
        showpan.dispose(c1);
    }
}

