/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import java.util.HashMap;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.mod.obj.controller;
import jcm.mod.obj.regset;
import jcm.mod.obj.sresdata;
import jcm.mod.obj.sresext;
import jcm.mod.socio.histsocdata;

public class popgdp
extends module {
    public curveset pop = new curveset(new Object[]{"population", "mega&person", complexity.simplest});
    public curveset gdp_ppp = new curveset("gdp_ppp", "mega&dollar&(2000)&per&year", 1950);
    public curveset gdp_mer = new curveset("gdp_mer", "mega&dollar&(2000)&per&year", 1950);
    public param socconv = new param(new Object[]{"socioconv", "percent&per&year", colfont.dkgreen, Float.valueOf(2.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), complexity.expert});
    public param ppp_convfac = new param(new Object[]{"ppp_convfac", "%&per&yr", 2, 0, 100, complexity.experimental});
    public param ppp_powfac = new param(new Object[]{"ppp_powfac", "", 0.3, 0.1, 1, complexity.experimental});
    region regset;
    public loopcalc history = new loopcalc("socio-history"){

        public void precalc() {
            int y;
            popgdp.this.regset = (region)popgdp.this.gm(regset.class).regions.chosen;
            popgdp.this.gm(regset.class).clearoldregions(this);
            interpolator.fillregdata(histsocdata.histpop, popgdp.this.pop, popgdp.this.regset, 0.001f);
            interpolator.fillregdata(histsocdata.GDP_MER, popgdp.this.gdp_mer, popgdp.this.regset, 1.0f);
            interpolator.fillregdata(histsocdata.GDP_PPP, popgdp.this.gdp_ppp, popgdp.this.regset, 1.0f);
            for (y = gsy; y < fsypop; ++y) {
                popgdp.this.pop.calctot(y);
            }
            for (y = gsy; y < fsygdp; ++y) {
                popgdp.this.gdp_mer.calctot(y);
                popgdp.this.gdp_ppp.calctot(y);
            }
        }
    };
    public loopcalc future = new loopcalc("socio-future"){

        public void precalc() {
            controller co = popgdp.this.gm(controller.class);
            new interpolator(sresdata.sres_image_popn.get((Object)co.scpop)).fill(popgdp.this.pop, popgdp.this.regset, fsypop, 2100, histsocdata.histpop, (float)popgdp.this.socconv.getval());
            for (int y = fsypop; y <= 2100; ++y) {
                popgdp.this.pop.calctot(y);
            }
            float inflator = 1.0856584f;
            new interpolator(sresdata.sres_image_gdp.get((Object)co.scgdp), Float.valueOf(inflator)).fill(popgdp.this.gdp_mer, popgdp.this.regset, fsygdp, 2100, histsocdata.GDP_MER, (float)popgdp.this.socconv.getval());
            popgdp.this.futureppp();
            for (int y = fsygdp; y <= 2100; ++y) {
                popgdp.this.gdp_mer.calctot(y);
                popgdp.this.gdp_ppp.calctot(y);
            }
        }
    };

    public void initsetup() {
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.future.follows(this.history);
        this.future.setaffectedby(this.gm(controller.class).scenario);
        this.setaffectedby(this.gm(sresext.class));
        this.future.setaffectedby(this.socconv);
    }

    public void futureppp() {
        curveset mer = this.gm(popgdp.class).gdp_mer;
        curveset ppp = this.gm(popgdp.class).gdp_ppp;
        curveset pop = this.gm(popgdp.class).pop;
        region USA = regman.nations.find("USA");
        if (!mer.map.keySet().contains(USA)) {
            report.deb("\nCan't calculate future PPP without USA in the chosen regionset!! ");
            return;
        }
        HashMap<region, Float> alpha = new HashMap<region, Float>();
        float acf = (float)this.ppp_convfac.getval() / 100.0f;
        float b = (float)(-this.ppp_powfac.getval());
        for (int y = fsygdp - 1; y < 2100; ++y) {
            float u = mer.get(USA, y) / pop.get(USA, y);
            float du = (mer.get(USA, y + 1) / pop.get(USA, y + 1) - u) / u;
            ppp.set(USA, y + 1, mer.get(USA, y + 1));
            for (region r : ((region)this.gm(regset.class).regions.chosen).reg) {
                if (r == USA) continue;
                float m = mer.get(r, y) / pop.get(r, y);
                float dm = (mer.get(r, y + 1) / pop.get(r, y + 1) - m) / m;
                float p = ppp.get(r, y) / pop.get(r, y);
                float a = y == fsygdp - 1 ? (float)((double)(p / m) / Math.pow(m / u, b)) : ((Float)alpha.get(r)).floatValue();
                float da = acf * (1.0f - a);
                alpha.put(r, Float.valueOf(a + da));
                float dp = p * (dm * (1.0f + b) - b * du + da / a);
                ppp.set(r, y + 1, pop.get(r, y + 1) * (p + dp));
            }
        }
    }
}

