/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.resp;

import java.util.EnumMap;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.mod.obj.controller;
import jcm.mod.obj.sresdata;

public class matchdata
extends module
implements dataholder {
    public EnumMap<gas, EnumMap<sector, EnumMap<lbu, curveset>>> emitmap;

    public void initsetup() {
        try {
            this.makemap();
            this.loaddata(sresdata.scen.none);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setaffectedby(this.gm(controller.class).scenario);
    }

    public void precalc() {
        this.loaddata();
    }

    public curveset emit(Object ... oo) {
        gas g = gas.CO2;
        sector s = sector.enin;
        lbu u = lbu.best;
        for (Object o : oo) {
            if (o instanceof gas) {
                g = (gas)((Object)o);
            }
            if (o instanceof sector) {
                s = (sector)((Object)o);
            }
            if (!(o instanceof lbu)) continue;
            u = (lbu)((Object)o);
        }
        curveset q = this.emitmap.get((Object)g).get((Object)s).get((Object)u);
        if (q != null) {
            return q;
        }
        q = new curveset("" + (Object)((Object)g) + "_" + (Object)((Object)s) + "_" + (Object)((Object)u), "kilo&ton&" + (Object)((Object)g), 1750, 2100);
        q.owner = this;
        q.setaffectedby(this);
        this.curvesets.add(q);
        this.addOb(q);
        q.register();
        this.emitmap.get((Object)g).get((Object)s).put(u, q);
        return q;
    }

    void makemap() {
        this.emitmap = new EnumMap(gas.class);
        for (gas g : gas.values()) {
            this.emitmap.put(g, new EnumMap(sector.class));
            for (sector s : sector.values()) {
                this.emitmap.get((Object)g).put(s, new EnumMap(lbu.class));
            }
        }
    }

    public static int sy(sresdata.scen n) {
        return n == sresdata.scen.none ? 1750 : 2000;
    }

    public static int ey(sresdata.scen n) {
        return n == sresdata.scen.none ? 2005 : 2100;
    }

    void loaddata() {
        sresdata.scen n = (sresdata.scen)((Object)this.gm(controller.class).scenario.chosen);
        if (n == null) {
            report.deb("no matchdata for scenario !");
            return;
        }
        this.loaddata(n);
    }

    void loaddata(sresdata.scen n) {
        for (gas g : gas.values()) {
            for (lbu u : lbu.values()) {
                for (sector s : sector.values()) {
                    if (s == sector.lucf && (g != gas.CO2 || n != sresdata.scen.A1B && n != sresdata.scen.B2 && n != sresdata.scen.none)) continue;
                    String name = (Object)((Object)g) + "_" + (Object)((Object)s) + "_" + (Object)((Object)u) + "_" + (Object)((Object)n) + ".tab";
                    try {
                        String[][] data = fileio.loadtab("match-emitdata/" + name, "\t");
                        curveset qq = this.emit(new Object[]{g, u, s});
                        for (int i = 1; i < data.length; ++i) {
                            name = data[i][0];
                            region reg = regman.allreg.findormakereg(name, "matchdata: ");
                            if (reg == null) {
                                report.deb("matchdata " + name + " not in countrynames");
                            }
                            curve q = qq.getOrAddCurve(reg != null ? reg : name);
                            for (int j = 1; j < data[i].length; ++j) {
                                q.set(j + matchdata.sy(n) - 1, Float.parseFloat(data[i][j]));
                            }
                        }
                    }
                    catch (Exception e) {
                        report.deb(e + "\ntrying to load " + name);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum sector {
        enin,
        agwa,
        lucf;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum lbu {
        lower,
        best,
        upper;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum gas {
        CO2,
        CH4,
        N2O;

    }
}

