/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regimp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.mod.cli.sealevel;
import jcm.mod.math.interp1D;
import jcm.mod.math.runAverage;
import jcm.mod.obj.regset;
import jcm.mod.socio.popgdp;

public class SLRimpacts
extends module {
    public curveset slrimpact_phz = new curveset("slrimpact_phz", "people at risk");
    public curveset slrimpact_pc = new curveset("slrimpact_pc", "protection class");
    public curveset slrimpact_aapf = new curveset("slrimpact_aapf", "person&per&year");
    public static String[] listadapt = new String[]{"none", "mini", "average", "full"};
    public static param typeadapt = new param(new Object[]{"adaptmenu", listadapt, "none", complexity.simplest});
    List<region> regset;
    Map<region, Set<region>> subregs = new HashMap<region, Set<region>>();
    static int nslr;
    sealevel sealevel;
    popgdp socio;
    regset socreg;
    static float[][] ppm;
    static boolean reportederror;
    static String[] regnameslr;
    static String[] regnamejcm;
    static float[][] ppermeter;
    static Object[] slreg;
    static int[][] redproslr;
    static int[] isdeltaic;
    static float[] retuper;
    static interp1D[] gdptopro;
    static interp1D[] hiwatlev;
    static runAverage[] gdprunav;

    public void initsetup() {
        this.mycomplexity = complexity.experimental;
        this.sealevel = this.gm(sealevel.class);
        this.socreg = this.gm(regset.class);
        this.socio = this.gm(popgdp.class);
        this.follows(this.sealevel);
        this.follows(this.socio);
        SLRimpacts.importdata();
    }

    public void precalc() {
        this.regset = ((region)this.socreg.regions.chosen).reg;
        this.socreg.clearoldregions(this.slrimpact_phz);
        this.socreg.clearoldregions(this.slrimpact_pc);
        this.socreg.clearoldregions(this.slrimpact_aapf);
        for (int r = 0; r < nslr; ++r) {
            region sr = regman.allreg.find(regnamejcm[r]);
            for (region rr : this.regset) {
                if (!rr.contains(sr)) continue;
                SLRimpacts.slreg[r] = rr;
            }
            if (slreg[r] == null) {
                SLRimpacts.slreg[r] = regman.world;
            }
            gdprunav[r].reset();
        }
        reportederror = false;
    }

    public void calcstep() {
        try {
            int ireg;
            float slr = this.sealevel.total.get() - 0.1f;
            String curadapt = typeadapt.chosenname();
            for (ireg = 0; ireg < nslr; ++ireg) {
                this.slrimpact_phz.set(slreg[ireg], 0.0f);
                this.slrimpact_pc.set(slreg[ireg], 0.0f);
                this.slrimpact_aapf.set(slreg[ireg], 0.0f);
            }
            float popchg = 0.0f;
            boolean pc = false;
            if (year > 1950 && year < 2200) {
                for (ireg = 0; ireg < nslr; ++ireg) {
                    region jcmR = (region)slreg[ireg];
                    float curlev = hiwatlev[ireg].getLin(3.0f) + slr;
                    int ilow = (int)Math.floor(curlev);
                    float rest = curlev - (float)ilow;
                    float phz = ilow >= 0 ? (1.0f - rest) * ppermeter[ireg][ilow] + rest * ppermeter[ireg][ilow + 1] : ppermeter[ireg][0];
                    float ophz = this.slrimpact_phz.get(jcmR);
                    this.slrimpact_phz.set(jcmR, ophz + phz);
                    float locpop = this.socio.pop.get(jcmR);
                    float gdpcap = locpop > 0.0f ? this.socio.gdp_mer.get(jcmR) / locpop : 1.0f;
                    gdpcap = gdprunav[ireg].average(gdpcap);
                    float pd = gdptopro[isdeltaic[ireg]].getLin(gdpcap);
                    pd = curadapt.equals("none") ? Math.min(3.0f, pd) : Math.min(10.0f, pd);
                    float flolev = hiwatlev[ireg].getLin(pd) - slr;
                    pd = hiwatlev[ireg].getInvLin(flolev);
                    pd = Math.max(0.3f, pd);
                    if (phz > 0.0f) {
                        this.slrimpact_pc.set(jcmR, (this.slrimpact_pc.get(jcmR) * ophz + pd * phz) / (phz + ophz));
                    }
                    if (this.socio.pop.get(jcmR, 2000) > 0.0f) {
                        popchg = this.socio.pop.get(jcmR) / this.socio.pop.get(jcmR, 2000);
                    }
                    float aapf = 0.0f;
                    float step = 0.1f;
                    float hstep = step / 2.0f;
                    for (float cpd = pd + hstep; cpd < 3.0f; cpd += step) {
                        curlev = hiwatlev[ireg].getLin(cpd) + slr;
                        ilow = (int)Math.floor(curlev);
                        rest = curlev - (float)ilow;
                        phz = ilow >= 0 ? (1.0f - rest) * ppermeter[ireg][ilow] + rest * ppermeter[ireg][ilow + 1] : ppermeter[ireg][0];
                        float cdt = (float)(Math.pow(10.0, cpd + hstep) - Math.pow(10.0, cpd - hstep));
                        aapf += cdt * popchg * phz / (float)Math.pow(Math.pow(10.0, cpd), 2.0);
                    }
                    this.slrimpact_aapf.set(jcmR, this.slrimpact_aapf.get(jcmR) + aapf);
                }
            }
        }
        catch (Exception e) {
            if (!reportederror) {
                e.printStackTrace();
            }
            reportederror = true;
        }
    }

    public void postcalc() {
    }

    static void importdata() {
        String[][] data = fileio.loadtab("data/slr_popcntry.csv", "\t");
        nslr = data.length - 3;
        float[] hwl = new float[4];
        float[] prd = new float[]{0.0f, 1.0f, 2.0f, 3.0f};
        regnamejcm = new String[nslr];
        regnameslr = new String[nslr];
        ppermeter = new float[nslr][13];
        hiwatlev = new interp1D[nslr];
        isdeltaic = new int[nslr];
        slreg = new region[nslr];
        gdprunav = new runAverage[nslr];
        for (int r = 0; r < nslr; ++r) {
            int x;
            SLRimpacts.gdprunav[r] = new runAverage(30);
            SLRimpacts.regnamejcm[r] = data[r + 3][0];
            SLRimpacts.regnameslr[r] = data[r + 3][1];
            SLRimpacts.isdeltaic[r] = (int)Float.parseFloat(data[r + 3][2]);
            for (x = 0; x < 13; ++x) {
                SLRimpacts.ppermeter[r][x] = Float.parseFloat(data[r + 3][x + 3]);
            }
            for (x = 0; x < 4; ++x) {
                hwl[x] = Float.parseFloat(data[r + 3][x + 16]);
            }
            SLRimpacts.hiwatlev[r] = new interp1D(prd, hwl);
        }
        redproslr = new int[][]{{0, 1, 2, 3, 3}, {0, 0, 1, 2, 3}, {0, 0, 0, 1, 2}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}};
        float[] gdptp_nod = new float[]{0.0f, 300.0f, 600.0f, 2400.0f, 6000.0f};
        float[] gdptp_del = new float[]{0.0f, 1200.0f, 2400.0f, 5000.0f, 9000.0f};
        float[] prodegs = new float[]{1.0f, 1.0f, 1.5f, 2.5f, 3.5f};
        SLRimpacts.gdptopro[0] = new interp1D(gdptp_nod, prodegs);
        SLRimpacts.gdptopro[1] = new interp1D(gdptp_del, prodegs);
        retuper = new float[]{10.0f, 100.0f, 1000.0f, 1000.0f};
    }

    static {
        reportederror = false;
        gdptopro = new interp1D[2];
    }
}

