/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.ogas.othgasemit;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.regemit.emitbase;
import jcm.mod.resp.attribTracer;
import jcm.mod.resp.responsibility;
import jcm.mod.socio.costs;
import jcm.mod.socio.popgdp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class shares
extends module {
    public curveset emitfosquota = new curveset(new Object[]{"emitfosquota", "mega&ton&carbon", complexity.simplest});
    public curveset emitlucquota = new curveset("emitlucquota", "mega&ton&carbon");
    public curveset emitch4quota = new curveset("emitch4quota", "mega&ton&CH4");
    public curveset emitn2oquota = new curveset("emitn2oquota", "mega&ton&N");
    public curveset emitfosabate;
    public curveset emitfosquotaCO2 = new curveset(new Object[]{"emitfosquotaCO2", "mega&ton&CO2", 1890, 2100, complexity.expert});
    public curveset emitequiv = new curveset(new Object[]{"CO2 Equivalent  (GWP) Emissions", "mega&ton&CO2", 1890, 2100, complexity.expert});
    complexity[] distribcomplex = new complexity[]{complexity.simplest, complexity.simplest, complexity.normal, complexity.expert, complexity.experimental, complexity.experimental};
    public param<distriboptions> distribution = new param(new Object[]{"distribmenu", distriboptions.values(), distriboptions.convergence, this.distribcomplex});
    public param<igroup> initgroup = new param(new Object[]{"initial group", igroup.values(), igroup.Kyoto_Annex_B, complexity.normal});
    public param<emitthreshold> emitlim = new param(new Object[]{"emissions threshold", emitthreshold.values(), emitthreshold.axbemitpercap, complexity.normal});
    public param<convcrit> conv_criteria = new param(new Object[]{"convergence criteria", convcrit.values(), convcrit.emissionspercapita, complexity.expert});
    public param<intensity> midincaction = new param(new Object[]{"middle-income early action", intensity.values(), intensity.base});
    public param richjoin = new param("join if high GDP", true);
    public param axb_gdp_threshold = new param("upper_GDP_threshold", "dollar&per&person", 20000, 10000, 30000);
    public param convergey = new param(new Object[]{"convyear", "", 2060, 2010, 2100, complexity.simplest});
    public param exponential = new param(new Object[]{"expconvopt", false, complexity.expert});
    public param cvf = new param(new Object[]{"convfac", "", 6, 1, 13, complexity.expert});
    public param popcoyoption = new param(new Object[]{"popcoyopt", false, complexity.expert});
    public param popcoy = new param(new Object[]{"popcoy", "", 2030, 1990, 2100, complexity.expert});
    public param lc_iterative = new param(new Object[]{"iterative", false, complexity.experimental});
    public param ldc_gdp_threshold = new param("lower_GDP_threshold", "dollar&per&person", 5000, 0, 20000);
    public param dc_reduction = new param("midinc intensity reduction", "percent&per&yr", 0.5, 0, 5);
    public param rate_caps = new param(new Object[]{"rate caps", false, complexity.expert});
    public param rate_constraint = new param("max decline rate", "percent&per&yr", 6, 2, 20);
    public param d2rate_constraint = new param("max deceleration", "percent&per&yr", 3, 0.5, 5);
    public param checkscaling = new param(new Object[]{"topdownscale", true, complexity.experimental});
    public param logparticip = new param("record_transitions", false);
    emitbase regemit;
    attribTracer attr;
    responsibility resp;
    popgdp socio;
    curveset efq;
    curveset efb;
    List<region> reg_all;
    List<region> reg_allnb = new ArrayList<region>();
    Set<region> particip = new HashSet<region>();
    Set<region> notparticip = new HashSet<region>();
    Set<region> capped = new HashSet<region>();
    Map<region, Float> mac = new HashMap<region, Float>();
    Map<region, Float> abateshare = new HashMap<region, Float>();
    Map<region, Integer> midinc_sy = new HashMap<region, Integer>();
    double cf;
    float participtot;
    boolean policyscenario = true;
    public loopcalc history = new loopcalc("shares-history"){

        public void precalc() {
            shares.this.gm(regset.class).clearoldregions(this);
            region regset2 = (region)shares.this.gm(regset.class).regions.chosen;
            for (region r : regset2.reg) {
                shares.this.emitfosquota.getOrAddCurve(r);
                shares.this.emitfosabate.getOrAddCurve(r);
            }
            shares.this.emitfosquota.getOrAddCurve((Object)"bunker").color = colfont.grey;
        }

        public void calcstep() {
            if (year < fsyfos) {
                shares.this.settobase(true);
                shares.this.calctotandequiv();
            }
        }
    };
    static float gwpch4 = 23.0f;
    static float gwpn2o = 296.0f;

    @Override
    public void initsetup() {
        this.regemit = this.gm(emitbase.class);
        this.attr = this.gm(attribTracer.class);
        this.resp = this.gm(responsibility.class);
        this.socio = this.gm(popgdp.class);
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.history.follows(this.gm(emitbase.class).history);
        this.follows(this.socio);
        this.follows(this.regemit);
        this.follows(globco2emit.class);
        this.follows(othgasemit.class);
        this.follows(this.gm(AviaShipEmit.class).emitmitig);
        this.follows(this.gm(futureLUC.class).quota);
        this.distribution.setaffectedby(this.gm(controller.class).objective);
        this.setaffectedby(this.gm(controller.class).objective);
        this.emitfosabate = new curvar(curve.Type.difference, this.gm(emitbase.class).emitfosbase, this.emitfosquota);
        this.emitfosabate.mycomplexity = complexity.expert;
        this.emitfosquota.addOb(new curvar(curve.Type.ratio, this.emitfosquota, this.gm(popgdp.class).pop, this.emitlucquota));
        this.emitequiv.addOb(new curvar(curve.Type.ratio, this.emitequiv, this.gm(popgdp.class).pop));
        this.distribution.priority = 1.3;
        this.initgroup.priority = 1.23;
        this.emitlim.priority = 1.22;
        this.richjoin.priority = 1.21;
        this.midincaction.priority = 1.2;
        this.rate_caps.priority = 1.19;
    }

    @Override
    public void setinteractions() {
        distriboptions dc = (distriboptions)((Object)this.distribution.chosen);
        boolean incpart = this.policyscenario && this.initgroup.chosen != igroup.all_from_start;
        this.setaffectedby((interacob)this.gm(attribTracer.class), this.policyscenario && dc == distriboptions.responsibility);
        this.setaffectedby((interacob)this.gm(costs.class), this.policyscenario && dc == distriboptions.leastcost);
        this.setaffectedby(this.distribution, this.policyscenario);
        this.setaffectedby(this.initgroup, this.policyscenario);
        this.setaffectedby(this.emitlim, incpart);
        this.setaffectedby(this.conv_criteria, this.policyscenario && dc == distriboptions.convergence);
        this.setaffectedby((interacob)this.convergey, this.policyscenario && dc == distriboptions.convergence);
        this.setaffectedby((interacob)this.popcoyoption, this.policyscenario && dc == distriboptions.convergence && this.conv_criteria.chosen == convcrit.emissionspercapita);
        this.setaffectedby((interacob)this.popcoy, this.policyscenario && dc == distriboptions.convergence && this.conv_criteria.chosen == convcrit.emissionspercapita && this.popcoyoption.istrue());
        this.setaffectedby((interacob)this.exponential, this.policyscenario && dc == distriboptions.convergence);
        this.setaffectedby((interacob)this.cvf, this.policyscenario && dc == distriboptions.convergence && this.exponential.istrue());
        this.setaffectedby((interacob)this.lc_iterative, this.policyscenario && dc == distriboptions.leastcost);
        this.setaffectedby((interacob)this.richjoin, incpart);
        this.setaffectedby((interacob)this.axb_gdp_threshold, incpart && this.richjoin.istrue());
        this.setaffectedby(this.midincaction, incpart);
        this.setaffectedby((interacob)this.rate_caps, this.policyscenario);
        this.setaffectedby((interacob)this.rate_constraint, this.policyscenario && this.rate_caps.istrue());
        this.setaffectedby((interacob)this.d2rate_constraint, this.policyscenario && this.rate_caps.istrue());
        this.setaffectedby((interacob)this.ldc_gdp_threshold, incpart && (this.midincaction.chosen != intensity.base || this.rate_caps.istrue()));
        this.setaffectedby((interacob)this.dc_reduction, incpart && this.midincaction.chosen != intensity.base);
    }

    void settobase(boolean incbunk) {
        for (region r : this.reg_allnb) {
            this.efq.set(r, this.efb.get(r));
            if (incbunk) {
                this.efq.set("bunker", this.efb.get("bunker"));
            }
            this.emitch4quota.set(r, this.gm(emitbase.class).emitch4base.get(r));
            this.emitn2oquota.set(r, this.gm(emitbase.class).emitn2obase.get(r));
        }
    }

    void calctotandequiv() {
        this.efq.calctot();
        if (year >= 1890 && year <= 2100) {
            this.calcequiv();
            this.emitch4quota.calctot();
            this.emitn2oquota.calctot();
        }
    }

    @Override
    public void precalc() {
        this.efq = this.emitfosquota;
        this.efb = this.regemit.emitfosbase;
        this.cf = this.cvf.getval() / (this.convergey.getval() - (double)fsyfos);
        this.policyscenario = this.gm(controller.class).objective.chosen != "nopolicy";
        this.initregions();
    }

    @Override
    public void calcstep() {
        if (year >= fsyfos) {
            this.settobase(false);
            if (this.policyscenario) {
                this.setparticipate();
                this.developing_bottomup();
                distriboptions dc = (distriboptions)((Object)this.distribution.chosen);
                if (dc == distriboptions.grandfather) {
                    for (region r : this.particip) {
                        this.efq.set(r, this.efq.get(r, year - 1));
                    }
                }
                if (dc == distriboptions.sresdist) {
                    for (region r : this.particip) {
                        this.efq.set(r, this.efb.get(r));
                    }
                }
                if (dc == distriboptions.convergence) {
                    this.converge();
                }
                if (dc == distriboptions.leastcost) {
                    this.leastcost();
                }
                if (dc == distriboptions.responsibility) {
                    this.responsibility();
                }
                this.scaleandcapparticip();
            }
            if (this.checkscaling.istrue()) {
                this.efq.topdownscale(this.gm(carboncycle.class).fossil.get(), true);
                this.efq.calctot();
            }
            this.emitch4quota.topdownscale(this.gm(othgasemit.class).ch4emit.get());
            this.emitn2oquota.topdownscale(this.gm(othgasemit.class).n2oemit.get());
            this.calctotandequiv();
        }
    }

    void initregions() {
        if (this.logparticip.istrue()) {
            report.deb("\n ===========================");
        }
        this.reg_all = ((region)this.gm(regset.class).regions.chosen).reg;
        this.reg_allnb.clear();
        this.reg_allnb.addAll(this.reg_all);
        this.reg_allnb.remove("bunker");
        this.particip.clear();
        this.notparticip.clear();
        this.midinc_sy.clear();
        this.mac.clear();
        this.abateshare.clear();
        if (this.initgroup.chosen == igroup.all_from_start) {
            this.particip.addAll(this.reg_allnb);
        } else {
            this.notparticip.addAll(this.reg_allnb);
            if (this.initgroup.chosen == igroup.Kyoto_Annex_B) {
                this.makeKyotoAxB();
            }
        }
    }

    void makeKyotoAxB() {
        Set<region> A1nat = regman.allreg.find("AXB").subreg(regman.nations);
        HashSet<region> AXB = new HashSet<region>();
        String initparticip = "\nInitial Annex B: ";
        block0: for (region r : this.reg_allnb) {
            Set<region> rn = r.subreg(regman.nations);
            for (region rr : rn) {
                if (!A1nat.contains(rr)) continue;
                AXB.add(r);
                initparticip = initparticip + ", " + r.getName();
                continue block0;
            }
        }
        if (this.logparticip.istrue()) {
            report.deb(initparticip);
        }
        this.notparticip.removeAll(AXB);
        this.particip.addAll(AXB);
    }

    void setparticipate() {
        float poptot = 0.0f;
        float fostot = 0.0f;
        if (this.notparticip.isEmpty()) {
            return;
        }
        if (this.emitlim.chosen != emitthreshold.nolim) {
            Collection<region> group = this.emitlim.chosen == emitthreshold.worldemitpercap ? this.reg_allnb : this.particip;
            for (region r : group) {
                poptot += this.socio.pop.get(r, year - 1);
                fostot += this.efq.get(r, year - 1);
            }
            for (region r : this.notparticip) {
                if (!(this.efq.get(r, year - 1) / this.socio.pop.get(r, year - 1) > fostot / poptot)) continue;
                this.changecat(r, " emit/cap > avg (" + fostot / poptot + ")");
            }
        }
        for (region r : this.notparticip) {
            float gdppercap = this.socio.gdp_ppp.get(r) / this.socio.pop.get(r);
            if (this.richjoin.istrue() && (double)gdppercap > this.axb_gdp_threshold.getval()) {
                this.changecat(r, " GDP/cap > " + this.axb_gdp_threshold.getval());
            }
            if (this.midinc_sy.containsKey(r) || !((double)gdppercap > this.ldc_gdp_threshold.getval())) continue;
            this.midinc_sy.put(r, 0);
        }
        this.notparticip.removeAll(this.particip);
        if (this.logparticip.istrue() && this.notparticip.isEmpty()) {
            report.deb("\n ============================\n");
        }
    }

    void changecat(region r, String reason) {
        this.particip.add(r);
        if (this.logparticip.istrue()) {
            report.deb(r.getName() + "\t\t  joins " + year + "\t  " + reason);
        }
    }

    void developing_bottomup() {
        if (this.midincaction.chosen != intensity.base) {
            for (region r : this.midinc_sy.keySet()) {
                int yd = this.midinc_sy.get(r);
                if (this.notparticip.contains(r)) {
                    this.midinc_sy.put(r, ++yd);
                }
                float fracreduce = (float)Math.pow(1.0 - this.dc_reduction.getval() / 100.0, yd);
                if (this.midincaction.chosen == intensity.redrelbase && yd > 0) {
                    this.efq.set(r, this.efq.get(r) * fracreduce);
                }
                if (this.midincaction.chosen != intensity.redint || yd <= 0) continue;
                float intensity2 = this.efq.get(r, year - yd) / this.socio.gdp_ppp.get(r, year - yd) * fracreduce;
                this.efq.set(r, Math.min(intensity2 * this.socio.gdp_ppp.get(r), this.efq.get(r)));
            }
        }
        float emittot = 0.0f;
        for (region r : this.notparticip) {
            emittot += this.efq.get(r);
        }
        this.participtot = this.gm(carboncycle.class).fossil.get() - this.efq.get("bunker") - emittot;
    }

    void scaleandcapparticip() {
        float excess = this.scaleandcap(this.particip, this.participtot);
        if (excess < 0.0f) {
            float midinctot = 0.0f;
            HashSet<region> midinc = new HashSet<region>(this.midinc_sy.keySet());
            midinc.removeAll(this.particip);
            for (region r : midinc) {
                midinctot += this.efq.get(r);
            }
            excess = this.scaleandcap(midinc, midinctot + excess);
        }
        if (excess < 0.0f) {
            float alltot = 0.0f;
            for (region r : this.reg_allnb) {
                alltot += this.efq.get(r);
            }
            float fac = (this.gm(carboncycle.class).fossil.get() - this.efq.get("bunker")) / alltot;
            for (region r : this.reg_allnb) {
                this.efq.set(r, this.efq.get(r) * fac);
            }
        }
    }

    float scaleandcap(Set<region> group, float grouptot) {
        boolean somechange;
        this.capped.clear();
        float rc = (float)this.rate_constraint.getval() / 100.0f;
        float d2rc = (float)this.d2rate_constraint.getval() / 100.0f;
        do {
            somechange = false;
            float emittot = 0.0f;
            for (region r : group) {
                if (this.capped.contains(r)) continue;
                emittot += this.efq.get(r);
            }
            float fac = grouptot / emittot;
            for (region r : group) {
                if (this.capped.contains(r)) continue;
                this.efq.set(r, this.efq.get(r) * fac);
            }
            if (!this.rate_caps.istrue() || year < fsyfos + 10) {
                return 0.0f;
            }
            for (region r : group) {
                if (this.capped.contains(r)) continue;
                float rate = this.efq.get(r, year) - this.efq.get(r, year - 1);
                float oldrate = this.efq.get(r, year - 1) - this.efq.get(r, year - 2);
                if (rate < 0.0f && (rate - oldrate) / this.efq.get(r) < -d2rc) {
                    this.efq.set(r, this.efq.get(r, year - 1) * (1.0f - d2rc) + oldrate);
                    somechange = true;
                }
                if ((rate = this.efq.get(r, year) - this.efq.get(r, year - 1)) / this.efq.get(r) < -rc) {
                    this.efq.set(r, this.efq.get(r, year - 1) * (1.0f - rc));
                    somechange = true;
                }
                if (!somechange) continue;
                this.capped.add(r);
                if (this.efq.get(r) < 0.0f) {
                    this.efq.set(r, 0.0f);
                }
                if (this.efq.get(r) > this.efb.get(r)) {
                    this.efq.set(r, this.efb.get(r));
                }
                grouptot -= this.efq.get(r);
            }
        } while (somechange);
        return grouptot;
    }

    void converge() {
        int cyear;
        int n = cyear = this.conv_criteria.chosen == convcrit.emissionspercapita && (double)year > this.popcoy.getval() && this.popcoyoption.istrue() ? (int)this.popcoy.getval() : year;
        double f = (double)year >= this.convergey.getval() ? 1.0 : (this.exponential.istrue() ? Math.exp(this.cf * ((double)year - this.convergey.getval() - 1.0)) : 1.0 / (this.convergey.getval() - (double)year));
        float poptot = 0.0f;
        float gdptot = 0.0f;
        float emittot = 0.0f;
        for (region r : this.particip) {
            poptot += this.socio.pop.get(r, cyear);
            gdptot += this.socio.gdp_ppp.get(r, cyear);
            emittot += this.efq.get(r);
        }
        float cr = 1.0f;
        for (region r : this.particip) {
            if (this.conv_criteria.chosen == convcrit.emissionspercapita) {
                cr = this.socio.pop.get(r, cyear) / poptot;
            }
            if (this.conv_criteria.chosen == convcrit.emissionspergdp) {
                cr = this.socio.gdp_ppp.get(r, cyear) / gdptot;
            }
            float er = this.efq.get(r, year - 1) / emittot;
            this.efq.set(r, (float)((double)er - f * (double)(er - cr)));
        }
    }

    void responsibility() {
        float tempinctot = 0.0f;
        float tempincp = 0.0f;
        float oldemittot = 0.0f;
        int respyear = (int)Math.min((double)(year - 1), this.resp.endyear.getval());
        for (region r : this.particip) {
            if (!(this.efq.get(r, year - 1) > 0.0f)) continue;
            tempinctot += this.attr.surftemp.get(r, respyear);
            oldemittot += this.efq.get(r, year - 1);
        }
        float totreduce = oldemittot - this.participtot;
        if (totreduce < 0.0f) {
            report.deb("Problem applying Brazilian proposal: total reduction positive in " + year);
            return;
        }
        for (region r : this.particip) {
            float fr = this.attr.surftemp.get(r, respyear) / tempinctot;
            this.efq.set(r, this.efq.get(r, year - 1) - totreduce * fr);
            if (!(this.efq.get(r, year) < 0.0f)) continue;
            this.efq.set(r, 0.0f);
        }
    }

    void leastcost() {
        float suma = 0.0f;
        float sumb = 0.0f;
        float sums = 0.0f;
        float summ = 0.0f;
        int nregs = this.particip.size();
        if (this.lc_iterative.istrue()) {
            for (region r : this.particip) {
                this.mac.put(r, Float.valueOf(1.0f / (this.gm(costs.class).mac(r, year - 1) * this.gm(costs.class).ew(r, year - 1))));
                if (Float.isInfinite(this.mac.get(r).floatValue()) || Float.isNaN(this.mac.get(r).floatValue())) {
                    this.mac.put(r, Float.valueOf(0.0f));
                }
                summ += this.mac.get(r).floatValue();
            }
            for (region r : this.particip) {
                this.abateshare.put(r, Float.valueOf(summ > 0.0f ? this.abateshare.get(r).floatValue() * (0.6f + 0.4f * this.mac.get(r).floatValue() / summ) : this.efb.get(r) / this.gm(carboncycle.class).fossil.get()));
                this.efq.set(r, this.efq.get(r, year - 1) + (this.efb.get(r) - this.efb.get(r, year - 1)));
            }
        } else {
            for (region r : this.particip) {
                this.abateshare.put(r, Float.valueOf(1.0f / (float)Math.pow(this.gm(costs.class).alpha(r), 1.0f / (this.gm(costs.class).beta(r) - 1.0f))));
                this.efq.set(r, this.efb.get(r));
            }
        }
        for (region r : this.particip) {
            sums += this.abateshare.get(r).floatValue();
            sumb += this.efq.get(r);
        }
        suma = sumb - this.gm(carboncycle.class).fossil.get();
        for (region r : this.particip) {
            this.efq.set(r, this.efq.get(r) - suma * this.abateshare.get(r).floatValue() / sums);
            if (this.efq.get(r) < 0.0f) {
                this.efq.set(r, 0.0f);
            }
            if (!(this.efq.get(r) > this.efb.get(r))) continue;
            this.efq.set(r, this.efb.get(r));
        }
    }

    void calcequiv() {
        for (region r : this.reg_allnb) {
            this.emitequiv.set(r, (this.efq.get(r) + this.emitlucquota.get(r)) * 44.0f / 12.0f + this.emitch4quota.get(r) * gwpch4 + this.emitn2oquota.get(r) * gwpn2o * 44.0f / 14.0f);
            this.emitfosquotaCO2.set(r, this.efq.get(r) * 44.0f / 12.0f);
        }
        this.emitequiv.calctot();
        this.emitfosquotaCO2.calctot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum intensity {
        redint,
        redrelbase,
        base;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum emitthreshold {
        worldemitpercap,
        axbemitpercap,
        nolim;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum igroup {
        all_from_start,
        Kyoto_Annex_B,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum convcrit {
        emissionspercapita,
        emissionspergdp;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum distriboptions {
        sresdist,
        convergence,
        grandfather,
        responsibility,
        leastcost,
        unspecified;

    }
}

