/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.ogas;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.obj.sresdata;
import jcm.mod.ogas.fgas;
import jcm.mod.regemit.emitbase;

public class othgasemit
extends module {
    String[] emitoptions = new String[]{"sresfix", "sresscale", "2000fix", "2000scale", "donothing"};
    complexity[] emitcomplex = new complexity[]{complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.experimental};
    public param emitoption = new param(new Object[]{"othgasemitoptions", this.emitoptions, "sresscale", this.emitcomplex});
    public param addpermafrost = new param(new Object[]{"addpermafrost", false, complexity.experimental});
    public curve ch4emit = new curve(new Object[]{"ch4", colfont.green, complexity.simplest});
    public curve n2oemit = new curve("n2o", colfont.brown);
    public curve soxemit = new curve(new Object[]{"sox", colfont.blue, complexity.simplest});
    public curve coemit = new curve("co", colfont.dkgrey);
    public curve vocemit = new curve("voc", colfont.yellowgreen);
    public curve noxemit = new curve("nox", colfont.orange);
    public curveset emitcurves = new curveset(this.ch4emit, this.n2oemit, this.soxemit, this.coemit, this.vocemit, this.noxemit, "othgasemitcurves", "tera&gram&per&yr");
    float scale;
    float oldscale;
    float[] scgas = new float[6];
    float[][][] scgasdata = new float[][][]{sresdata.soxemit, sresdata.ch4emit, sresdata.n2oemit, sresdata.coemit, sresdata.vocemit, sresdata.noxemit};

    public void setinteractions() {
        this.follows(this.gm(emitbase.class).history);
        this.setaffectedby(this.gm(controller.class).scenario, this.emitoption.chosen == "sresfix" || this.emitoption.chosen == "sresscale");
        this.follows(this.gm(globco2emit.class), this.emitoption.chosen == "2000scale" || this.emitoption.chosen == "sresscale");
    }

    public void initsetup() {
        int y;
        for (y = 1860; y < 2001; ++y) {
            this.ch4emit.set(y, this.ch4emit.get(y) * 323.0f / 380.0f);
        }
        for (y = 1750; y < 1860; ++y) {
            this.ch4emit.set(y, this.ch4emit.get(1860) * (float)(y - 1750) / 110.0f);
        }
        for (y = 0; y < 1991; ++y) {
            this.soxemit.set(y, this.soxemit.get(y) * 70.9f / this.soxemit.get(1990));
        }
        for (y = 1991; y < 2001; ++y) {
            this.soxemit.set(y, ((float)(y - 1990) * 69.0f + (float)(2000 - y) * this.soxemit.get(1990)) / 10.0f);
        }
        this.histnoxvoc();
        super.initsetup();
    }

    public void precalc() {
        this.scaleis92a();
    }

    public void calcstep() {
        if (!this.emitoption.chosen.equals("donothing") && year >= 2000) {
            this.scalesresemit();
        }
        if (((region)this.gm(regset.class).regions.chosen).name.equals("EDGAR") && year == 1890) {
            float emit1890 = this.gm(emitbase.class).emitn2obase.calctot();
            for (int y = 1750; y <= 1890; ++y) {
                this.n2oemit.set(y, emit1890 * ((float)(y - 1750) / 140.0f));
            }
        }
        if (this.addpermafrost.istrue() && year > fsyog) {
            float extrach4 = 933.3334f * (float)(year - 2000) / 50.0f;
            this.ch4emit.set(this.ch4emit.get() + extrach4);
        }
    }

    void scaleis92a() {
        for (int i = 0; i < 6; ++i) {
            this.scgas[i] = this.gm(controller.class).sci == 6 ? this.scgasdata[i][0][0] / this.scgasdata[i][6][0] : 1.0f;
        }
    }

    void scalesresemit() {
        int yearb;
        this.scale = 1.0f;
        int sc = this.gm(controller.class).sci;
        if (year >= fsyfos && this.emitoption.chosen == "sresscale") {
            this.scale = this.gm(carboncycle.class).fossil.get(year) / this.gm(globco2emit.class).fossilbase.get();
        }
        if (year > 2000 && this.emitoption.chosen == "2000scale") {
            this.scale = this.gm(carboncycle.class).fossil.get(year) / this.gm(carboncycle.class).fossil.get(2000);
        }
        if (this.scale > this.oldscale && year > 2100) {
            this.scale = this.oldscale;
        } else {
            this.oldscale = this.scale;
        }
        int year1 = this.emitoption.chosen == "2000fix" || this.emitoption.chosen == "2000scale" ? 2000 : year;
        this.soxemit.set(year, sresdata.interp(sresdata.soxemit, sc, year1) * this.scale * this.scgas[0]);
        this.ch4emit.set(year, sresdata.interp(sresdata.ch4emit, sc, year1) * this.scale);
        this.n2oemit.set(year, sresdata.interp(sresdata.n2oemit, sc, year1) * this.scale * this.scgas[2]);
        this.coemit.set(year, sresdata.interp(sresdata.coemit, sc, year1) * this.scale * this.scgas[3]);
        this.vocemit.set(year, sresdata.interp(sresdata.vocemit, sc, year1) * this.scale * this.scgas[4]);
        this.noxemit.set(year, sresdata.interp(sresdata.noxemit, sc, year1) * this.scale * this.scgas[5]);
        int schfc = sc < 3 ? 0 : (sc < 7 ? sc - 2 : 2);
        int yeara = year + 5;
        int n = yearb = this.emitoption.chosen == "sresfix" || this.emitoption.chosen == "sresscale" ? yeara : 2000;
        if (yeara % 5 == 0 && yeara > 1930 && yeara <= gey) {
            for (int g = 0; g < 12; ++g) {
                this.gm(fgas.class).fgemit[g].set(yeara, sc == 6 && (g < 4 || g > 6) ? 0.0f : interpolator.interphfc(sresdata.hfcemit, g, schfc, yearb) * this.scale);
            }
        }
    }

    void histnoxvoc() {
        this.noxemit.set(2000, sresdata.interp(sresdata.noxemit, 0, 2000));
        this.vocemit.set(2000, sresdata.interp(sresdata.vocemit, 0, 2000));
        for (int year = 1750; year < 2000; ++year) {
            this.noxemit.set(year, this.noxemit.get(2000) * this.coemit.get(year) / this.coemit.get(2000));
            this.vocemit.set(year, this.vocemit.get(2000) * this.coemit.get(year) / this.coemit.get(2000));
        }
    }
}

