/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.math;

public class interp1D {
    private float[] xs;
    private float[] ys;

    public interp1D(float[] set_xs, float[] set_ys) {
        this.xs = new float[set_xs.length];
        this.ys = new float[set_ys.length];
        System.arraycopy(set_xs, 0, this.xs, 0, set_xs.length);
        System.arraycopy(set_ys, 0, this.ys, 0, set_ys.length);
    }

    public int search1D(float xx, float[] xvals) {
        for (int ii = 0; ii < xvals.length - 2; ++ii) {
            if (!(xvals[ii] <= xx) || !(xvals[ii + 1] >= xx)) continue;
            return ii;
        }
        if (xx < this.xs[0]) {
            return 0;
        }
        return this.xs.length - 2;
    }

    public float getLin(float xx) {
        int ilow = this.search1D(xx, this.xs);
        float yy = this.ys[ilow] + (this.ys[ilow + 1] - this.ys[ilow]) * (xx - this.xs[ilow]) / (this.xs[ilow + 1] - this.xs[ilow]);
        return yy;
    }

    public float getInvLin(float yy) {
        int ilow = this.search1D(yy, this.ys);
        float xx = this.xs[ilow] + (this.xs[ilow + 1] - this.xs[ilow]) * (yy - this.ys[ilow]) / (this.ys[ilow + 1] - this.ys[ilow]);
        return xx;
    }
}

