/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.obj.sresdata;
import jcm.mod.obj.sresext;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.shares;

public class futureLUC
extends module {
    public curveset potlucregquotacurves = new curveset(new Object[]{"regpotlucquota", "mega&ton&carbon", fsyluc, gey, complexity.expert});
    public curveset potlucregbasecurves = new curveset(new Object[]{"regpotlucbase", "mega&ton&carbon", fsyluc, gey, complexity.expert});
    public static curveset lucscenario = new curveset(new Object[]{"LUC SRES", "mega&ton&carbon", 2000, 2100, complexity.experimental});
    region regset;
    region sresreg;
    interpolator sreslucinterpolator;
    CalcLucEmit cle;
    globco2emit gc;
    Map<region, Float> potlucregbase = new HashMap<region, Float>();
    Map<region, Float> srespotluc = new HashMap<region, Float>();
    Map<region, Float> srb4conv = new HashMap<region, Float>();
    Map<region, Float> srinitial = new HashMap<region, Float>();
    Map<region, Float> sreslucemit = new HashMap<region, Float>();
    Map<region, Float> potlucregquota = new HashMap<region, Float>();
    Map<region, Float> potlucregquota_init = new HashMap<region, Float>();
    Map<region, Float> potluchist = new HashMap<region, Float>();
    curve trend = new curve("trend");
    Map<region, Map<region, Float>> weight = new HashMap<region, Map<region, Float>>();
    boolean nopolicy;
    float corrfac;
    float fu;
    curveset emitlucbase;
    curveset emitlucquota;
    curveset histluc;
    public loopcalc history = new loopcalc("futluc-setup"){

        public void precalc() {
            futureLUC.this.regset = (region)futureLUC.this.gm(regset.class).regions.chosen;
            for (curveset qq : futureLUC.this.curvesets) {
                futureLUC.this.gm(regset.class).clearoldregions(qq);
            }
            futureLUC.this.histluc = futureLUC.this.cle.lucsource.chosen.equals("Houghton") ? LUCdata.lucCO2CAIT1 : futureLUC.this.cle.lucemit;
            futureLUC.this.fu = futureLUC.this.cle.lucsource.chosen.equals("Houghton") ? 1.0f : 1000.0f;
        }

        public void calcstep() {
            if (year < fsyluc) {
                for (region r : futureLUC.this.regset.reg) {
                    futureLUC.this.emitlucquota.set(r, futureLUC.this.emitlucbase.get(r));
                }
                futureLUC.this.emitlucbase.calctot();
                futureLUC.this.emitlucquota.calctot();
            }
            if (year == fsyluc - 1) {
                futureLUC.this.histpotluc();
                futureLUC.this.setupweights();
            }
        }
    };
    public loopcalc base = new loopcalc("futluc-base"){

        public void precalc() {
            futureLUC.this.sreslucinterpolator = new interpolator(new Object[]{sresdata.sres4luc, "SRES4", 1990, 10, futureLUC.this.gm(controller.class).scre, Float.valueOf(1000.0f)});
            futureLUC.this.nopolicy = futureLUC.this.gm(controller.class).objective.chosen.equals("nopolicy");
        }

        public void calcstep() {
            if (year == fsyluc - 1) {
                futureLUC.this.initfut();
            }
            if (year >= fsyluc) {
                for (region r : futureLUC.this.regset.reg) {
                    futureLUC.this.potlucregbase.put(r, Float.valueOf(futureLUC.this.potlucregbase.get(r).floatValue() + futureLUC.this.emitlucbase.get(r, year - 1) * futureLUC.this.gc.plf));
                    futureLUC.this.potlucregbasecurves.set(r, futureLUC.this.potlucregbase.get(r).floatValue());
                    futureLUC.this.emitlucbase.set(r, futureLUC.this.potlucregbase.get(r).floatValue());
                }
                float totsres4 = 0.0f;
                for (region sr : futureLUC.this.sresreg.reg) {
                    if (sr.name.equals("TOTAL")) continue;
                    if (year <= 2100) {
                        lucscenario.set(sr, futureLUC.this.sreslucinterpolator.getdata(sr, year));
                        futureLUC.this.sreslucemit.put(sr, Float.valueOf((float)((double)lucscenario.get(sr) + (1.0 - futureLUC.this.gc.lucconv.getval() / 100.0) * (double)(futureLUC.this.sreslucemit.get(sr).floatValue() - lucscenario.get(sr, year - 1)))));
                    } else {
                        float convfac = futureLUC.this.sreslucemit.get(sr).floatValue() < futureLUC.this.srespotluc.get(sr).floatValue() ? 1.0f : (float)futureLUC.this.gc.potlucconvergence.getval() / 100.0f;
                        futureLUC.this.sreslucemit.put(sr, Float.valueOf(convfac * futureLUC.this.srespotluc.get(sr).floatValue() + (1.0f - convfac) * futureLUC.this.sreslucemit.get(sr).floatValue()));
                    }
                    totsres4 += futureLUC.this.sreslucemit.get(sr).floatValue();
                }
                if (totsres4 > 10.0f || totsres4 < -10.0f) {
                    futureLUC.this.corrfac = futureLUC.this.gc.lucfbase.get() / totsres4;
                }
                for (region sr : futureLUC.this.sresreg.reg) {
                    if (sr.name.equals("TOTAL")) continue;
                    futureLUC.this.sreslucemit.put(sr, Float.valueOf(futureLUC.this.sreslucemit.get(sr).floatValue() * futureLUC.this.corrfac));
                    futureLUC.this.srespotluc.put(sr, Float.valueOf(futureLUC.this.srespotluc.get(sr).floatValue() + futureLUC.this.sreslucemit.get(sr).floatValue() * futureLUC.this.gc.plf));
                    futureLUC.this.trend.set(year, (futureLUC.this.sreslucemit.get(sr).floatValue() - futureLUC.this.srespotluc.get(sr).floatValue()) / futureLUC.this.srinitial.get(sr).floatValue());
                    for (region r : futureLUC.this.regset.reg) {
                        futureLUC.this.emitlucbase.set(r, futureLUC.this.emitlucbase.get(r) + futureLUC.this.weight.get(r).get(sr).floatValue() * futureLUC.this.trend.get(year));
                    }
                }
                futureLUC.this.emitlucbase.calctot();
            }
        }
    };
    public loopcalc quota = new loopcalc("futluc-quota"){

        public void calcstep() {
            if (year == fsyluc - 1) {
                for (region r : futureLUC.this.regset.reg) {
                    futureLUC.this.potlucregquota.put(r, futureLUC.this.potlucregquota_init.get(r));
                }
            }
            if (year >= fsyluc) {
                for (region r : futureLUC.this.regset.reg) {
                    futureLUC.this.potlucregquota.put(r, Float.valueOf(futureLUC.this.potlucregquota.get(r).floatValue() + futureLUC.this.emitlucquota.get(r, year - 1) * futureLUC.this.gc.plf));
                    futureLUC.this.potlucregquotacurves.set(r, futureLUC.this.potlucregquota.get(r).floatValue());
                    futureLUC.this.emitlucquota.set(r, futureLUC.this.potlucregquota.get(r).floatValue());
                }
                float divisor = year <= fsyluc ? futureLUC.this.gc.lucquota.get(year - 1) - futureLUC.this.gc.potlucquota.get(year - 1) : futureLUC.this.gc.lucfbase.get(year - 1) - futureLUC.this.gc.potlucbase.get(year - 1);
                float scaledownquota = (futureLUC.this.gm(carboncycle.class).lucf.get(year - 1) - futureLUC.this.gc.potlucquota.get(year - 1)) / divisor;
                if (year == fsyluc) {
                    scaledownquota = 1.0f;
                }
                for (region sr : futureLUC.this.sresreg.reg) {
                    if (sr.name.equals("TOTAL")) continue;
                    for (region r : futureLUC.this.regset.reg) {
                        futureLUC.this.emitlucquota.set(r, futureLUC.this.emitlucquota.get(r) + futureLUC.this.weight.get(r).get(sr).floatValue() * scaledownquota * futureLUC.this.trend.get(year));
                    }
                }
                futureLUC.this.emitlucquota.calctot();
            }
        }
    };

    public void initsetup() {
        this.sresreg = regman.allreg.findreg("SRES4");
        this.cle = this.gm(CalcLucEmit.class);
        this.gc = this.gm(globco2emit.class);
        this.emitlucbase = this.gm(emitbase.class).emitlucbase;
        this.emitlucquota = this.gm(shares.class).emitlucquota;
        futureLUC.lucscenario.getOrAddCurve((Object)regman.allreg.findreg((String)"TOTAL")).type = curve.Type.total;
        this.history.follows(this.cle);
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.base.follows(this.history);
        this.base.setaffectedby(this.gm(controller.class).scenario);
        this.base.setaffectedby(this.gc.lucconv, this.gc.potlucconvergence, this.gc.potlucfrac);
        this.base.setaffectedby(this.gm(sresext.class));
        this.quota.follows(this.base);
        this.quota.follows(this.gc);
    }

    void initfut() {
        for (region sr : this.sresreg.reg) {
            Set<region> srsubnat = sr.subreg(regman.nations);
            this.srespotluc.put(sr, Float.valueOf(0.0f));
            float srli = 0.0f;
            for (region rr : srsubnat) {
                this.srespotluc.put(sr, Float.valueOf(this.srespotluc.get(sr).floatValue() + this.potluchist.get(rr).floatValue() * this.gc.plf));
                for (int i = -5; i < 0; ++i) {
                    srli += this.histluc.get(rr, fsyluc + i) / (this.fu * 5.0f);
                }
            }
            this.sreslucemit.put(sr, Float.valueOf(srli));
            for (region rr : srsubnat) {
                this.srinitial.put(sr, Float.valueOf(srli - this.srespotluc.get(sr).floatValue()));
            }
        }
        for (region r : this.regset.reg) {
            this.potlucregbase.put(r, Float.valueOf(0.0f));
            for (region rr : r.subreg(regman.nations)) {
                this.potlucregbase.put(r, Float.valueOf(this.potlucregbase.get(r).floatValue() + this.potluchist.get(rr).floatValue() * this.gc.plf));
            }
            this.potlucregquota_init.put(r, this.potlucregbase.get(r));
        }
    }

    void setupweights() {
        for (region r : this.regset.reg) {
            this.weight.put(r, new HashMap());
            for (region sr : this.sresreg.reg) {
                this.weight.get(r).put(sr, Float.valueOf(0.0f));
            }
            for (region rr : r.subreg(regman.nations)) {
                for (region sr : this.sresreg.reg) {
                    if (!sr.contains(rr)) continue;
                    this.weight.get(r).put(sr, Float.valueOf(this.weight.get(r).get(sr).floatValue() + this.histluc.get(rr, fsyluc - 1) / this.fu - this.potluchist.get(rr).floatValue() * this.gc.plf));
                }
            }
        }
    }

    void histpotluc() {
        for (region r : regman.nations.reg) {
            int y;
            this.potluchist.put(r, Float.valueOf(0.0f));
            if (this.cle.lucsource.chosen.equals("IVIGmodel")) {
                for (y = 1700; y < fsyluc; ++y) {
                    this.potluchist.put(r, Float.valueOf(this.potluchist.get(r).floatValue() + this.cle.lucemit.get(r, y) / 1000.0f));
                }
            }
            if (!this.cle.lucsource.chosen.equals("Houghton")) continue;
            for (y = 1850; y < fsyluc; ++y) {
                this.potluchist.put(r, Float.valueOf(this.potluchist.get(r).floatValue() + LUCdata.lucCO2CAIT1.get(r, y)));
            }
        }
    }
}

