/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.data.loadtable;
import jcm.core.data.pngdata;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;

public class LUCdata
extends module
implements dataholder {
    public static curveset lucCO2Houghton = new curveset("Houghton LUC emit", "mega&ton&carbon", 1750, 2002);
    public static curveset lucCO2UNFCCC = new curveset("UNFCCC LUC emit", "mega&ton&carbon", 1990, 2002);
    public static curveset lucCO2CAIT = new curveset("CAIT LUC emit", "mega&ton&carbon", 1950, 2000);
    public static curveset lucCO2CAIT1 = new curveset("CAIT/Houghton LUC emit", "mega&ton&carbon", 1850, 2000);
    public static curveset faoagr = new curveset("FAO Agriculture Area", "mega&m2", 1961, 2002);
    public static curveset faopast = new curveset("FAO Pasture Area", "mega&m2", 1961, 2002);
    public static curveset edgarff = new curveset(new Object[]{"EDGAR fossil", "mega&ton&carbon", 1890, 2000, complexity.experimental});
    public static curveset edgarluc = new curveset(new Object[]{"EDGAR LUC", "mega&ton&carbon", 1890, 2000, complexity.experimental});
    static boolean loadeddata = false;
    static boolean loadingdata = false;
    static Map<region, Float> countryArcviewAreas = new HashMap<region, Float>();
    static int[] periods = new int[]{1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990, 2002};
    static byte[][][][] luTables = new byte[2][periods.length - 1][][];
    public static biomeclassification defaultBC = biomeclassification.B;

    public void initsetup() {
        if (!loadeddata) {
            LUCdata.getdata();
        }
    }

    public static void getdata() {
        if (loadingdata) {
            while (!loadeddata) {
                Thread.yield();
            }
        }
        if (loadeddata) {
            return;
        }
        loadingdata = true;
        LUCdata.reporttime("begin make region polygons");
        for (region r : regman.nations.reg) {
            r.makepolys();
        }
        LUCdata.reporttime("loading static LUCdata curve sets");
        LUCdata.loadStaticData();
        LUCdata.reporttime("Loading LUC Biome Data");
        LUCdata.loadHYDEdata(defaultBC);
        LUCdata.reporttime("end CLE loaddata");
        loadeddata = true;
        loadingdata = false;
    }

    static void loadStaticData() {
        loadtable.loaddata(faopast, "lucdata/FAO_pasture.csv", "\t", true, 1.0f, 1961, 2002, 1961);
        loadtable.loaddata(faoagr, "lucdata/FAO_agriculture.csv", "\t", true, 1.0f, 1961, 2002, 1961);
        loadtable.loaddata(lucCO2Houghton, "lucdata/houghtondata2000.csv", ";", true, 1.0f, 1850, 2000, 1850);
        String[][] countrya = fileio.loadtab("lucdata/Country_areas.csv", "\t");
        for (int y = 3; y < countrya.length; ++y) {
            region r = regman.allreg.findormakereg(countrya[y][0], "LUC countryareas ");
            float area = Float.parseFloat(countrya[y][1]);
            countryArcviewAreas.put(r, Float.valueOf(!countryArcviewAreas.containsKey(r) ? area : countryArcviewAreas.get(r).floatValue() + area));
        }
        loadtable.loaddata(lucCO2UNFCCC, "lucdata/UNFCCC_LUC_emit_v1.tab", "\t", true, 1.0f, 1990, 2002, 1990);
        loadtable.loaddata(lucCO2CAIT, "lucdata/CAIT_LUC_emit.tab", "\t", true, 0.001f, 1950, 2000, 1950);
        for (region r : regman.allreg.findormakereg((String)"HOUGHTON").reg) {
            for (int y = 1750; y < 1850; ++y) {
                lucCO2Houghton.set(r, y, lucCO2Houghton.get(r, 1850) * (float)(y - 1700) / 150.0f);
            }
        }
        new interpolator(lucCO2Houghton, "HOUGHTON", 1950, Float.valueOf(1.0f)).fill(lucCO2CAIT1, regman.nations, 1850, 2000, lucCO2CAIT);
    }

    static void loadHYDEdata(biomeclassification AB) {
        for (int p = 0; p < periods.length - 1; ++p) {
            String filename = "lu_" + (Object)((Object)AB) + "_" + periods[p];
            LUCdata.luTables[AB.ordinal()][p] = pngdata.load("lucdata/" + filename + ".png", AB.colors);
        }
        AB.loaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum biomeclassification {
        A(new String[]{"Ocean", "Cultivated land", "Pasture", "X", "X", "Ice", "Tundra", "Wooded tundra", "Boreal forest", "Cool conifer forest", "Temperate mixed forest", "Temperate deciduous forest", "Warm mixed forest", "Grassland/Steppe", "Hot desert", "Scrubland", "Savanna", "Tropical woodland", "Tropical forest"}, new Color[]{colfont.black, colfont.red, colfont.pink, colfont.black, colfont.black, colfont.white, colfont.cyan, colfont.dkcyan, colfont.browngreen, colfont.dkredgreen, colfont.dkyellowgreen, colfont.yellowgreen, colfont.olive, colfont.orange, colfont.yellow, colfont.brown, colfont.ltgreen, colfont.green, colfont.dkgreen}),
        B(new String[]{"Ocean", "Cultivated land", "Pasture", "Tropical Evergreen Forest/Woodland", "Tropical Deciduous Forest/Woodland", "Temperate Broadleafed Evergreen Forest/Woodland", "Temperate Needleleafed Evergreen Forest/Woodland", "Temperate Decidous Forest/Woodland", "Boreal Evergreen Forest/Woodland", "Boreal Deciduous Forest/Woodland", "Evergreen/Deciduous Mixed Forest/Woodland", "Savanna", "Grassland/Steppe", "Dense Shrubland", "Open Shrubland", "Tundra", "Hot Desert", "Polar Deser/Rock/Ice"}, new Color[]{colfont.black, colfont.red, colfont.pink, colfont.dkgreen, colfont.green, colfont.dkgrey, colfont.olive, colfont.yellowgreen, colfont.dkredgreen, colfont.dkyellowgreen, colfont.browngreen, colfont.ltgreen, colfont.orange, colfont.brown, colfont.dkbrown, colfont.cyan, colfont.yellow, colfont.white, colfont.black});

        public String[] names;
        public Color[] colors;
        boolean loaded = false;

        private biomeclassification(String[] n2, Color[] c) {
            this.names = n2;
            this.colors = c;
        }
    }
}

