/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jama.EigenvalueDecomposition;
import jama.Matrix;
import java.awt.Color;
import java.util.EnumMap;
import java.util.EnumSet;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;

public class udebclimod
extends module {
    static cp[] ar4p = new cp[]{cp.rfco2double, cp.climsens_effective, cp.climsens_gcm, cp.transientclimateresponse, cp.heatdiffusivity, cp.landoceantempratio};
    static cp[] tarp = new cp[]{cp.rfco2double, cp.climsens, cp.heatdiffusivity, cp.landoceantempratio, cp.zeroupwelltemp, cp.knorthsouth, cp.klandocean};
    static cp[] sarp = new cp[]{cp.rfco2double, cp.climsens, cp.heatdiffusivity, cp.landoceantempratio, cp.zeroupwelltemp, cp.knorthsouth, cp.klandocean, cp.mixlaydepth, cp.polarsinktempratio, cp.seaice};
    EnumMap<cp, param> gp = new EnumMap(cp.class);
    public param<gcmset> climodtype = new param(new Object[]{"climodtype", gcmset.values(), gcmset.all_GCMs}){

        public void precalc() {
            udebclimod.this.climod.setlist((gcm[])((gcmset)((Object)this.chosen)).gcmlist());
        }
    };
    public param<gcm> climod;
    public param varupwell;
    public param<csopts> csopt;
    public static final int nhl = 39;
    public static final int nhb = 40;
    public double[][] hiq;
    public double[][] hiqi;
    public double[][] hiq99;
    public double[][] hpropf;
    public double[][] hrML;
    public double[][] shicML;
    public double[][] rhicML;
    public double[][] hrsl;
    public double[] frac;
    double fracl;
    double fraco;
    double[][] khi;
    double[] khir;
    public double tstart;
    public double kls;
    public double kos;
    public double klo;
    public double kns;
    public double nstd;
    public double nstdold;
    public double dqin;
    public double qpt;
    public double sl;
    public double cice;
    double[] qin;
    double[] qinbase;
    double[] qinold;
    double[] qinold99;
    double[] mlt;
    public double[] spaceflux;
    double totrf99;
    double nstd99;
    double nstdold99;
    double dt;
    double hu;
    double pi;
    double diffu;
    double dml;
    double rvu;
    double rv;
    double rjff;
    double polsink;
    double mlbaserate;
    double hiquc;
    double reftemp;
    double[] dl;
    double[] vec;
    double[][] rate;
    public double[][] hiqstart;
    Matrix M;
    Matrix U;
    Matrix[] MV;
    Matrix[] MVI;
    double[][][] upwellstep;
    int startyear;
    int tstep;
    double guess;
    double nit;
    double ciqr;
    double diff;
    public double sealevteinit;

    public udebclimod() {
        this.climod = new param(new Object[]{"climodmenu", ((gcmset)((Object)this.climodtype.chosen)).gcmlist(), gcm.AR4_average, complexity.simplest}){

            public void precalc() {
                gcm g = (gcm)((Object)this.chosen);
                for (cp p : cp.values()) {
                    if (p == cp.climsens) continue;
                    udebclimod.this.gp.get((Object)p).putval(g.val.containsKey((Object)p) ? g.val.get((Object)p) : p.def);
                }
                if (udebclimod.this.csopt.chosen == csopts.user_cs) {
                    // empty if block
                }
                if (udebclimod.this.csopt.chosen == csopts.use_effective_cs && g.val.containsKey((Object)cp.climsens_effective)) {
                    udebclimod.this.gp.get((Object)cp.climsens).putval(g.val.get((Object)cp.climsens_effective));
                }
                if (udebclimod.this.csopt.chosen == csopts.use_gcm_cs && g.val.containsKey((Object)cp.climsens_gcm)) {
                    udebclimod.this.gp.get((Object)cp.climsens).putval(g.val.get((Object)cp.climsens_gcm));
                }
                udebclimod.this.setupfluxes();
                udebclimod.this.gm(sealevel.class).seticecaptomod((gcm)((Object)this.chosen));
            }
        };
        this.varupwell = new param(new Object[]{"tufbopt", true, colfont.magenta, complexity.expert});
        this.csopt = new param(new Object[]{"cs_source", csopts.values(), csopts.user_cs, colfont.dkred, complexity.expert}){

            public void precalc() {
                udebclimod.this.climod.precalc();
            }
        };
        this.hiq = this.hbox();
        this.hiqi = this.hbox();
        this.hiq99 = this.hbox();
        this.hpropf = this.hbox();
        this.hrML = this.hbox();
        this.shicML = this.hbox();
        this.rhicML = this.hbox();
        this.hrsl = this.hbox();
        this.frac = new double[]{0.199, 0.301, 0.406, 0.094};
        this.fracl = this.frac[0] + this.frac[3];
        this.fraco = 1.0 - this.fracl;
        this.khi = new double[4][4];
        this.khir = new double[4];
        this.tstart = 18.17;
        this.qin = new double[2];
        this.qinbase = new double[2];
        this.qinold = new double[2];
        this.qinold99 = new double[2];
        this.mlt = new double[2];
        this.spaceflux = new double[2];
        this.reftemp = 0.0;
        this.hiqstart = new double[2][40];
        this.MV = new Matrix[2];
        this.MVI = new Matrix[2];
        this.upwellstep = new double[2][40][40];
    }

    public void initsetup() {
        this.makeparams();
        this.gp.get((Object)cp.rfco2double).setaffects(this.gm(radfor.class));
    }

    public void setinteractions() {
        this.setaffectedby((interacob)this.gp.get((Object)cp.zeroupwelltemp), this.varupwell.istrue());
        this.setaffectedby((interacob)this.gp.get((Object)cp.upwellreducefrac), this.varupwell.istrue());
        this.setaffectedby((interacob)this.gp.get((Object)cp.upwellbaserate), this.varupwell.istrue());
    }

    public double val(cp p) {
        return this.gp.get((Object)p).getval();
    }

    void test() {
        udebclimod ud = this.gm(udebclimod.class);
    }

    void makeparams() {
        gcm g = (gcm)((Object)this.climod.chosen);
        for (cp c : cp.values()) {
            param p = new param(new Object[]{c.lab, c.units, g.val.containsKey((Object)c) ? g.val.get((Object)c) : c.def, c.min, c.max, c.co, c.cx});
            this.gp.put(c, p);
            p.priority -= 0.2;
            this.allparam.add(p);
            p.setaffects(this);
            p.owner = this;
            this.addOb(p);
            p.setaffectedby(this.climod);
        }
    }

    public void precalc() {
        if (!this.climod.changed) {
            this.setupfluxes();
        }
    }

    double[][] hbox() {
        return new double[2][40];
    }

    public void setupfluxes() {
        int n;
        int j;
        int i;
        double clotr;
        this.dt = 1.0;
        this.dml = this.val(cp.mixlaydepth);
        this.dl = new double[39];
        for (int n2 = 0; n2 < 39; ++n2) {
            this.dl[n2] = (n2 < 20 ? 49.0 : 196.0) * 0.8717948717948718;
        }
        this.diffu = this.val(cp.heatdiffusivity) * 3.1536E7 / 10000.0;
        this.hu = this.val(cp.upwellbaserate);
        this.pi = this.val(cp.polarsinktempratio);
        double cw = 0.1300101471334348;
        this.qpt = cw * this.dml;
        this.klo = this.val(cp.klandocean);
        this.kns = this.val(cp.knorthsouth);
        double lotr = this.val(cp.landoceantempratio);
        this.cice = this.val(cp.seaice);
        double oldclotr = 1.0;
        double oldkos = -99.0;
        this.kos = 0.9;
        do {
            this.kls = this.val(cp.rfco2double) / this.val(cp.climsens) * (lotr * this.fracl + this.fraco) / (lotr * this.fracl) - this.kos * this.fraco / (lotr * this.fracl);
            this.khi = new Matrix(new double[][]{{this.frac[0] * this.kls + this.klo, -this.klo, 0.0, 0.0}, {-this.klo, this.frac[1] * this.kos + this.klo + this.kns, -this.kns, 0.0}, {0.0, -this.kns, this.frac[2] * this.kos + this.klo + this.kns, -this.klo}, {0.0, 0.0, -this.klo, this.frac[3] * this.kls + this.klo}}, 4, 4).inverse().getArray();
            for (i = 0; i < 4; ++i) {
                this.khir[i] = 0.0;
                for (j = 0; j < 4; ++j) {
                    double[] dArray = this.khi[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] * this.frac[j];
                    int n4 = i;
                    this.khir[n4] = this.khir[n4] + this.khi[i][j];
                }
            }
            clotr = (this.frac[0] * this.khir[0] + this.frac[3] * this.khir[3]) / this.fracl / ((this.frac[1] * this.khir[1] + this.frac[2] * this.khir[2]) / this.fraco);
            double newkos = oldkos == -99.0 ? 1.0 : this.kos + (lotr - clotr) * (this.kos - oldkos) / (clotr - oldclotr);
            oldkos = this.kos;
            this.kos = newkos;
            oldclotr = clotr;
        } while (Math.abs(lotr - clotr) > 1.0E-4);
        this.rate = new double[40][40];
        for (i = 0; i < 40; ++i) {
            for (j = 0; j < 40; ++j) {
                this.rate[i][j] = 0.0;
            }
        }
        int n5 = 1;
        while (n5 < 39) {
            this.rvu = (2.0 * this.diffu - this.hu * this.dl[n5]) / (this.dl[n5 - 1] * (this.dl[n5 - 1] + this.dl[n5]));
            this.rv = (2.0 * this.diffu + this.hu * this.dl[n5 - 1]) / (this.dl[n5] * (this.dl[n5 - 1] + this.dl[n5]));
            double[] dArray = this.rate[n5];
            int n6 = n5 - 1;
            dArray[n6] = dArray[n6] + this.rvu;
            double[] dArray2 = this.rate[n5 - 1];
            int n7 = n5 - 1;
            dArray2[n7] = dArray2[n7] - this.rvu;
            double[] dArray3 = this.rate[n5 - 1];
            int n8 = n5;
            dArray3[n8] = dArray3[n8] + this.rv;
            double[] dArray4 = this.rate[n5];
            int n9 = n5++;
            dArray4[n9] = dArray4[n9] - this.rv;
        }
        this.rvu = 8.0 * this.diffu / (3.0 * this.dl[0] * this.dml) - this.hu / this.dml;
        this.rv = 3.0 * this.diffu / (this.dl[0] * this.dl[0]);
        this.rjff = this.diffu / (3.0 * this.dl[0] * this.dl[0]);
        double[] dArray = this.rate[0];
        dArray[39] = dArray[39] + this.rvu;
        double[] dArray5 = this.rate[39];
        dArray5[39] = dArray5[39] - this.rvu;
        double[] dArray6 = this.rate[39];
        dArray6[0] = dArray6[0] + this.rv;
        double[] dArray7 = this.rate[0];
        dArray7[0] = dArray7[0] - this.rv;
        double[] dArray8 = this.rate[0];
        dArray8[1] = dArray8[1] + this.rjff;
        double[] dArray9 = this.rate[39];
        dArray9[1] = dArray9[1] - this.rjff;
        this.polsink = this.pi * this.hu / this.dml;
        double[] dArray10 = this.rate[38];
        dArray10[39] = dArray10[39] + this.polsink;
        double[] dArray11 = this.rate[39];
        dArray11[39] = dArray11[39] - this.polsink;
        this.mlbaserate = this.rate[39][39];
        this.M = new Matrix(this.rate, 40, 40);
        if (this.varupwell.istrue()) {
            int n10;
            double[][] urate = new double[40][40];
            for (n10 = 0; n10 < 40; ++n10) {
                for (int m = 0; m < 40; ++m) {
                    urate[n10][m] = 0.0;
                }
            }
            n10 = 1;
            while (n10 < 39) {
                this.rvu = -this.hu * this.dl[n10] / (this.dl[n10 - 1] * (this.dl[n10 - 1] + this.dl[n10]));
                this.rv = this.hu * this.dl[n10 - 1] / (this.dl[n10] * (this.dl[n10 - 1] + this.dl[n10]));
                double[] dArray12 = urate[n10];
                int n11 = n10 - 1;
                dArray12[n11] = dArray12[n11] + this.rvu;
                double[] dArray13 = urate[n10 - 1];
                int n12 = n10 - 1;
                dArray13[n12] = dArray13[n12] - this.rvu;
                double[] dArray14 = urate[n10 - 1];
                int n13 = n10;
                dArray14[n13] = dArray14[n13] + this.rv;
                double[] dArray15 = urate[n10];
                int n14 = n10++;
                dArray15[n14] = dArray15[n14] - this.rv;
            }
            this.rvu = -this.hu / this.dml;
            double[] dArray16 = urate[0];
            dArray16[39] = dArray16[39] + this.rvu;
            double[] dArray17 = urate[39];
            dArray17[39] = dArray17[39] - this.rvu;
            this.polsink = this.pi * this.hu / this.dml;
            double[] dArray18 = urate[38];
            dArray18[39] = dArray18[39] + this.polsink;
            double[] dArray19 = urate[39];
            dArray19[39] = dArray19[39] - this.polsink;
            this.U = new Matrix(urate, 40, 40);
        }
        double mlstart = this.tstart * this.qpt;
        Matrix veclay = this.M.getMatrix(0, 38, 0, 38).inverse().times(this.M.getMatrix(0, 38, 39, 39)).times(-mlstart);
        double[] hss = veclay.transpose().getArray()[0];
        double[] tss = new double[40];
        tss[39] = this.tstart;
        for (int n15 = 0; n15 < 39; ++n15) {
            tss[n15] = hss[n15] / (cw * this.dl[n15]);
        }
        double[] pr = new double[40];
        double pz = 5071.5;
        pr[39] = 101325.0 + pz * this.dml;
        pr[0] = pr[39] + pz * (this.dml + this.dl[0]);
        for (n = 1; n < 39; ++n) {
            pr[n] = pr[n - 1] + pz * (this.dl[n - 1] + this.dl[n]);
        }
        this.vec = new double[40];
        for (n = 0; n < 40; ++n) {
            this.vec[n] = 1.0 / cw * (1.0E-4 * (0.5 + 0.12 * tss[n] - 8.0E-4 * tss[n] * tss[n] + 2.8 * (1.0 - 0.027 * tss[n]) * (pr[n] * 1.0E-8 - 0.24 * pr[n] * pr[n] * 1.0E-16)));
        }
        double[] Eig = new double[40];
        double[] stepf = new double[40];
        double[] rampf = new double[40];
        double[] hicML = new double[40];
        for (int o = 0; o < 2; ++o) {
            int m;
            int n16;
            this.spaceflux[o] = 1.0 / this.qpt * this.cice * (this.kos + this.klo / this.frac[o + 1] * (this.kls * this.frac[o * 3] / (this.kls * this.frac[o * 3] + this.klo)));
            this.M.set(39, 39, this.mlbaserate - this.spaceflux[o]);
            EigenvalueDecomposition ED = new EigenvalueDecomposition(this.M);
            this.MV[o] = ED.getV();
            this.MVI[o] = this.MV[o].inverse();
            for (n16 = 0; n16 < 40; ++n16) {
                this.hiqstart[o][n16] = 0.0;
                for (m = 0; m < 40; ++m) {
                    double[] dArray20 = this.hiqstart[o];
                    int n17 = n16;
                    dArray20[n17] = dArray20[n17] + this.MVI[o].getArray()[n16][m] * (m < 39 ? hss[m] : mlstart);
                }
            }
            Eig = ED.getRealEigenvalues();
            for (n16 = 0; n16 < 40; ++n16) {
                this.hpropf[o][n16] = Math.exp(Eig[n16] * this.dt);
                if (Math.abs(Eig[n16]) < 1.0E-6) {
                    stepf[n16] = this.dt;
                    rampf[n16] = this.dt / 2.0;
                    continue;
                }
                stepf[n16] = (this.hpropf[o][n16] - 1.0) / Eig[n16];
                rampf[n16] = (stepf[n16] - this.dt) / (Eig[n16] * this.dt);
            }
            this.hrML[o] = this.MV[o].getArray()[39];
            hicML = this.MVI[o].transpose().getArray()[39];
            for (n16 = 0; n16 < 40; ++n16) {
                this.rhicML[o][n16] = rampf[n16] * hicML[n16];
                this.shicML[o][n16] = stepf[n16] * hicML[n16];
            }
            n16 = 0;
            while (n16 < 40) {
                for (int i2 = 1; i2 < 40; ++i2) {
                    double[] dArray21 = this.hrsl[o];
                    int n18 = n16;
                    dArray21[n18] = dArray21[n18] + this.MV[o].getArray()[i2][n16];
                }
                double[] dArray22 = this.hrsl[o];
                int n19 = n16;
                dArray22[n19] = dArray22[n19] * this.vec[n16];
                double[] dArray23 = this.hrsl[o];
                int n20 = n16++;
                dArray23[n20] = dArray23[n20] * (this.frac[o + 1] / (this.frac[1] + this.frac[2]));
            }
            if (!this.varupwell.istrue()) continue;
            this.upwellstep[o] = this.MVI[o].times(this.U.times(this.MV[o])).getArray();
            for (n16 = 0; n16 < 40; ++n16) {
                for (m = 0; m < 40; ++m) {
                    double[] dArray24 = this.upwellstep[o][n16];
                    int n21 = m;
                    dArray24[n21] = dArray24[n21] * (stepf[m] / this.val(cp.zeroupwelltemp));
                }
            }
        }
        Eig = null;
        rampf = null;
        stepf = null;
        hicML = null;
    }

    public void startstate(int startyear) {
        this.startyear = startyear;
        if (startyear == 1750) {
            this.nstd = 0.0;
            this.nstdold = 0.0;
            for (int o = 0; o < 2; ++o) {
                this.qinold[o] = this.spaceflux[o] * this.qpt * this.tstart;
                for (int n = 0; n < 40; ++n) {
                    this.hiq[o][n] = this.hiqstart[o][n];
                }
            }
        } else {
            startyear = 2000;
            this.nstd = this.nstd99;
            this.nstdold = this.nstdold99;
            this.qinold[0] = this.qinold99[0];
            this.qinold[1] = this.qinold99[1];
            for (int o = 0; o < 2; ++o) {
                for (int n = 0; n < 40; ++n) {
                    this.hiq[o][n] = this.hiq99[o][n];
                }
            }
        }
    }

    public void save99() {
        for (int o = 0; o < 2; ++o) {
            this.nstd99 = this.nstd;
            this.nstdold99 = this.nstdold;
            this.qinold99[o] = this.qinold[o];
            for (int n = 0; n < 40; ++n) {
                this.hiq99[o][n] = this.hiq[o][n];
            }
        }
    }

    public float adjust(float[] rf) {
        int n;
        int o;
        this.nstdold = this.nstd = (this.guess = this.nstd + (this.nstd - this.nstdold));
        for (o = 0; o < 2; ++o) {
            for (n = 0; n < 40; ++n) {
                this.hiq[o][n] = this.hpropf[o][n] * this.hiq[o][n] + this.shicML[o][n] * this.qinold[o];
            }
            this.qinbase[o] = rf[o + 1];
            int n2 = o;
            this.qinbase[n2] = this.qinbase[n2] + (double)rf[o * 3] * (this.frac[o * 3] / this.frac[o + 1]) * this.klo / (this.kls * this.frac[o * 3] + this.klo);
            int n3 = o;
            this.qinbase[n3] = this.qinbase[n3] + this.spaceflux[o] * this.qpt * this.tstart;
        }
        this.nit = 0.0;
        do {
            o = 0;
            while (o < 2) {
                this.qin[o] = this.qinbase[o] + (o == 0 ? -1.0 : 1.0) * this.nstd * this.kns / this.frac[o + 1];
                this.dqin = this.qin[o] - this.qinold[o];
                this.mlt[o] = 0.0;
                for (n = 0; n < 40; ++n) {
                    this.hiqi[o][n] = this.hiq[o][n] + this.rhicML[o][n] * this.dqin;
                    int n4 = o;
                    this.mlt[n4] = this.mlt[n4] + this.hrML[o][n] * this.hiqi[o][n];
                }
                int n5 = o++;
                this.mlt[n5] = this.mlt[n5] / this.qpt;
            }
            this.diff = (this.mlt[0] - this.mlt[1]) * this.cice - this.nstd;
            this.nstd += this.diff;
            this.nit += 1.0;
        } while (Math.abs(this.diff) > 0.001 && this.nit < 10.0);
        this.hiq = this.hiqi;
        this.qinold = this.qin;
        o = 0;
        while (o < 2) {
            int n6 = o++;
            this.mlt[n6] = this.mlt[n6] - this.tstart;
        }
        curve[] bt = this.gm(glotemp.class).boxtempqt;
        bt[0].set(year, (float)((this.mlt[0] * this.cice * this.klo + this.frac[0] * (double)rf[0]) / (this.kls * this.frac[0] + this.klo)));
        bt[3].set(year, (float)((this.mlt[1] * this.cice * this.klo + this.frac[3] * (double)rf[3]) / (this.kls * this.frac[3] + this.klo)));
        bt[1].set(year, (float)(this.mlt[0] * this.cice));
        bt[2].set(year, (float)(this.mlt[1] * this.cice));
        float globavtemp = 0.0f;
        for (int i = 0; i < 4; ++i) {
            globavtemp += (float)((double)bt[i].get(year) * this.frac[i]);
        }
        return globavtemp;
    }

    float thermalexpansion() {
        float thermexp = 0.0f;
        for (int o = 0; o < 2; ++o) {
            for (int n = 0; n < 40; ++n) {
                thermexp = (float)((double)thermexp + this.hrsl[o][n] * this.hiq[o][n]);
            }
        }
        if (year == gsy) {
            this.sealevteinit = thermexp;
        }
        thermexp = (float)((double)thermexp - this.sealevteinit);
        return thermexp;
    }

    void tempupwellfb(double ut) {
        if (this.varupwell.istrue()) {
            if (ut > this.val(cp.zeroupwelltemp)) {
                ut = this.val(cp.zeroupwelltemp);
            }
            for (int o = 0; o < 2; ++o) {
                int n = 0;
                while (n < 40) {
                    this.hiquc = 0.0;
                    for (int m = 0; m < 40; ++m) {
                        this.hiquc += this.hiq[o][m] * this.upwellstep[o][n][m];
                    }
                    double[] dArray = this.hiq[o];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] - this.hiquc * ut * this.val(cp.upwellreducefrac);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum csopts {
        use_effective_cs,
        use_gcm_cs,
        user_cs;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum gcmset {
        AR4(EnumSet.range(gcm.AR4_average, gcm.HadGEM1)),
        AR4_selection(EnumSet.of(gcm.HadGEM1, new gcm[]{gcm.MIROC3_2_MED, gcm.ECHAM5_MPIOM, gcm.HadCM3, gcm.CSIRO_Mk3, gcm.GISS_EH})),
        TAR(EnumSet.range(gcm.GFDL_TAR, gcm.DOE)),
        SAR(EnumSet.of(gcm.IPCCSAR)),
        all_GCMs(EnumSet.allOf(gcm.class));

        EnumSet<gcm> gcms;

        private gcmset(EnumSet<gcm> eg) {
            this.gcms = eg;
        }

        gcm[] gcmlist() {
            return this.gcms.toArray(new gcm[this.gcms.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum gcm {
        AR4_average(3.642, 2.925, 3.211, 1.763, 1.899, 1.391),
        CCS_M3(3.95, 2.37, 2.7, 1.5, 1.73, 1.18),
        CGC_M31_T47(3.32, 3.02, 3.4, 1.9, 1.57, 1.58),
        CNRM_CM3(3.71, 2.45, 2.45, 1.6, 1.21, 1.1),
        CSIRO_Mk3(3.47, 2.21, 3.1, 1.4, 2.03, 1.33),
        ECHAM5_MPIOM(4.01, 3.86, 3.4, 2.2, 1.22, 1.41),
        ECHO_G(3.71, 3.01, 3.2, 1.7, 2.01, 1.65),
        FGOALS_g1(3.71, 1.97, 2.3, 1.2, 4.57, 1.64),
        GFDL_CM2(3.5, 2.35, 2.9, 1.6, 1.42, 1.47),
        GFDL_CM2_1(3.5, 2.28, 3.4, 1.5, 2.23, 1.58),
        GISS_EH(4.06, 3.04, 2.7, 1.6, 2.35, 1.21),
        GISS_ER(4.06, 2.57, 2.7, 1.5, 4.42, 1.44),
        INM_CM3(3.71, 2.28, 2.1, 1.6, 0.79, 1.1),
        IPSL_CM4(3.48, 3.83, 4.4, 2.1, 1.94, 1.26),
        MIROC3_2_HI(3.14, 5.87, 4.3, 2.6, 1.18, 1.15),
        MIROC3_2_MED(3.09, 3.93, 4.0, 2.1, 2.29, 1.58),
        MRI_CGCM_232(3.47, 2.97, 3.2, 2.2, 1.22, 1.45),
        PCM(3.71, 1.88, 2.1, 1.3, 1.57, 1.45),
        HadCM3(3.81, 3.06, 3.3, 2.0, 1.01, 1.65),
        HadGEM1(3.78, 2.63, 4.4, 1.9, 1.32, 1.2),
        GFDL_TAR(tarp, 3.71, 4.2, 2.3, 1.2, 8.0, 1.0, 1.0),
        CSIRO_TAR(tarp, 3.45, 3.7, 1.6, 1.2, 5.0, 1.0, 1.0),
        HadCM3_TAR(tarp, 3.74, 3.0, 1.9, 1.4, 25.0, 0.5, 0.5),
        HadCM2(tarp, 3.47, 2.5, 1.7, 1.4, 12.0, 0.5, 0.5),
        ECHAM4(tarp, 3.8, 2.6, 9.0, 1.4, 20.0, 0.5, 0.5),
        CSM(tarp, 3.6, 1.9, 2.3, 1.4, 9999.0, 0.5, 0.5),
        DOE(tarp, 3.6, 1.7, 2.3, 1.4, 14.0, 0.5, 0.5),
        IPCCSAR(sarp, 4.37, 2.5, 1.0, 1.3, 7.0, 1.0, 1.0, 90.0, 0.2, 1.0);

        EnumMap<cp, Double> val = new EnumMap(cp.class);

        private gcm(double ... x) {
            this(ar4p, x);
        }

        private gcm(cp[] pars, double ... x) {
            int i = 0;
            for (cp p : pars) {
                this.val.put(p, x[i]);
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum cp {
        rfco2double("rfco2d", "w&per&m2", 3.71, 3.0, 5.0, colfont.black, complexity.normal),
        climsens("climsens", "degc", 3.0, 1.5, 7.5, colfont.red, complexity.simplest),
        climsens_gcm("cs_gcm", "degc", 3.21, 1.5, 7.5, colfont.red, complexity.expert),
        climsens_effective("cs_effective", "degc", 2.925, 1.5, 7.5, colfont.dkred, complexity.expert),
        transientclimateresponse("tcr", "degc", 1.8, 1.0, 3.0, colfont.purple, complexity.experimental),
        heatdiffusivity("teddydiff", "cm2&per&s", 1.9, 0.05, 4.0, colfont.dkblue, complexity.normal),
        landoceantempratio("lotr", "", 1.4, 0.7, 2.1, colfont.orange, complexity.expert),
        zeroupwelltemp("tnoupwell", "degc", 8.0, 0.0, 30.0, colfont.lilac, complexity.expert),
        knorthsouth("kns", "", 1.0, 0.0, 4.0, colfont.dkgreen, complexity.expert),
        klandocean("klo", "", 1.0, 0.0, 2.0, colfont.yellowgreen, complexity.expert),
        mixlaydepth("tmixlay", "metres", 60.0, 1.0, 120.0, colfont.grey, complexity.expert),
        polarsinktempratio("psi", "", 0.2, 0.0, 1.0, colfont.blue, complexity.expert),
        seaice("seaice", "", 1.25, 0.8, 1.6, colfont.cyan, complexity.expert),
        upwellreducefrac("uwredfrac", "", 0.3, 0.0, 1.0, colfont.dkpurple, complexity.expert),
        upwellbaserate("uwbaserate", "m&per&yr", 4.0, 0.0, 8.0, colfont.pink, complexity.expert);

        String lab;
        String units;
        double def;
        double min;
        double max;
        Color co;
        complexity cx;

        private cp(String l, String u, double d, double a, double b, Color c, complexity x) {
            this.lab = l;
            this.units = u;
            this.def = d;
            this.min = a;
            this.max = b;
            this.co = c;
            this.cx = x;
        }
    }
}

