/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.anno.cut.bug;
import jcm.core.anno.cut.update;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.udebclimod;

@update(value="Thermal expansion should be consistent with AR4 GCMs, but  ice-melting is still to be updated")
public class sealevel
extends module {
    double[] glsens = new double[]{0.12, 0.16, 0.09, 0.1, 0.03, 0.15, 0.14, 0.3};
    double[] ansens = new double[]{-0.18, -0.37, -0.35, -0.21, -0.48, -0.31, -0.48, -0.21};
    public param greenlandsens = new param(new Object[]{"greenland_sensitivity", "", this.glsens[2], -0.5, 0.5, colfont.green, complexity.expert});
    public param antarcticasens = new param(new Object[]{"antarctica_sensitivity", "", this.ansens[2], -0.5, 0.5, colfont.cyan, complexity.expert});
    public curve thermexp = new curve("thermexp", colfont.red);
    public curve glacier = new curve("glaciers", colfont.grey);
    public curve longterm = new curve("rfia", colfont.black);
    public curve antarctica = new curve("antarctica", colfont.cyan);
    public curve greenland = new curve("greenland", colfont.green);
    public curve freshwater = new curve(new Object[]{"freshwater", colfont.dkgreen, complexity.expert});
    public curve other = new curve("Other", colfont.brown);
    public curve total = new curve(new Object[]{"totsl", colfont.dkblue, complexity.simplest, curve.Type.total});
    public curveset sealevel = new curveset(new Object[]{this.thermexp, this.glacier, this.greenland, this.antarctica, this.longterm, this.freshwater, this.other, this.total, "sealevelrise", "metres", complexity.simplest});
    float totglac = 0.5f;
    float taul = 70.0f;
    float tauh = 130.0f;
    float deltatl = 0.7f;
    float deltath = 3.0f;
    int ng = 10;
    int n;
    float eqglac;
    float[] glac = new float[this.ng];
    float[] glac99 = new float[this.ng];
    float[] tau = new float[this.ng];
    float[] deltat = new float[this.ng];

    @bug(value="ice-melt parameters don't respond to AR4 GCMs")
    public void seticecaptomod(udebclimod.gcm g) {
        int m = 2;
        this.greenlandsens.putval(this.glsens[m]);
        this.antarcticasens.putval(this.ansens[m]);
    }

    public void initsetup() {
        this.follows(this.gm(glotemp.class));
        this.follows(this.gm(udebclimod.class));
        this.greenlandsens.setaffectedby(this.gm(udebclimod.class).climod);
        this.antarcticasens.setaffectedby(this.gm(udebclimod.class).climod);
    }

    public void precalc() {
        this.glaciersetup();
    }

    public void calcstep() {
        if (year > gsy) {
            this.glaciermelt();
            this.polarmelt();
            this.longterm.set(year, (float)((double)this.longterm.get(year - 1) + 2.5E-4));
            this.other.set(year, (float)((double)this.other.get(year - 1) + (year < 1990 ? 5.0E-5 : 1.7E-4)));
            this.freshwater.set(year, 0.0f);
        }
        this.total.set(year, this.thermexp.get(year) + this.glacier.get(year) + this.longterm.get(year) + this.antarctica.get(year) + this.greenland.get(year) + this.freshwater.get(year) + this.other.get(year));
    }

    public void save99() {
        this.n = 0;
        while (this.n < this.ng) {
            this.glac99[this.n] = this.glac[this.n];
            ++this.n;
        }
    }

    public void startstate(int startyear) {
        this.longterm.set(gsy, 0.0f);
        this.antarctica.set(gsy, 0.0f);
        this.greenland.set(gsy, 0.0f);
        this.freshwater.set(gsy, 0.0f);
        this.glacier.set(gsy, 0.0f);
        this.other.set(gsy, 0.0f);
        if (startyear == 2000) {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.glac99[this.n];
                ++this.n;
            }
        } else {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.totglac / (float)this.ng;
                ++this.n;
            }
        }
    }

    void glaciersetup() {
        this.n = 0;
        while (this.n < this.ng) {
            this.tau[this.n] = this.taul + (this.tauh - this.taul) * (float)this.n / (float)(this.ng - 1);
            this.deltat[this.n] = this.deltatl + (this.deltath - this.deltatl) * (float)this.n / (float)(this.ng - 1);
            ++this.n;
        }
    }

    void glaciermelt() {
        this.glacier.set(year, this.totglac);
        this.n = 0;
        while (this.n < this.ng) {
            this.eqglac = this.totglac / (float)this.ng * (1.0f - this.gm(glotemp.class).avchange.get(year) / this.deltat[this.n]);
            if (this.eqglac < 0.0f) {
                this.eqglac = 0.0f;
            }
            int n = this.n;
            this.glac[n] = (float)((double)this.glac[n] - 0.3 * (double)(this.glac[this.n] - this.eqglac) / (double)this.tau[this.n]);
            this.glacier.set(year, this.glacier.get(year) - this.glac[this.n]);
            ++this.n;
        }
    }

    void polarmelt() {
        double glsensfac = 1.0 + ((double)this.gm(glotemp.class).avchange.get(year) - 1.5) * 0.3;
        double ansensfac = (double)this.gm(glotemp.class).avchange.get(year) * 0.05;
        this.antarctica.set(year, (float)((double)this.antarctica.get(year - 1) + ((year > 2100 ? ansensfac : 0.0) + this.antarcticasens.getval()) * (double)this.gm(glotemp.class).avchange.get(year) * 0.001));
        this.greenland.set(year, (float)((double)this.greenland.get(year - 1) + (year > 2100 ? glsensfac : 1.0) * this.greenlandsens.getval() * (double)this.gm(glotemp.class).avchange.get(year) * 0.001));
    }
}

