/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.cli.histtemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.cli.udebclimod;

public class glotemp
extends module {
    public static param baseyear = new param("baseyear", "", 1850, 1760, 2000, colfont.blue);
    public static param baserange = new param(new Object[]{"baseyearrange", "", 15, 0, 25, colfont.blue, complexity.expert});
    public boolean usehisttempdata = false;
    public double error = 0.0;
    public curve avchange = new curve(new Object[]{"tempavfrom1750", colfont.brown, complexity.experimental});
    public curve avchangeby = new curve(new Object[]{"tempav", colfont.brown, complexity.simplest});
    public curve tempnl = new curve(new Object[]{"tempnl", colfont.red, complexity.expert});
    public curve tempno = new curve(new Object[]{"tempno", colfont.blue, complexity.expert});
    public curve tempso = new curve(new Object[]{"tempso", colfont.cyan, complexity.expert});
    public curve tempsl = new curve(new Object[]{"tempsl", colfont.orange, complexity.expert});
    public curveset temp = new curveset(new Object[]{this.avchange, this.avchangeby, histtemp.temptrend, histtemp.proxytemp, histtemp.tempdataGISS, histtemp.tempdataCRU, "glotempcurves", "degcbase", complexity.simplest});
    public curveset boxtemp = new curveset(this.tempnl, this.tempno, this.tempsl, this.tempso, "Box Temperature", "degcbase");
    public double offset = 0.0;
    public double oldoffset = 1.0;
    float[] boxoffset = new float[4];
    curve[] boxtempqt = new curve[]{this.tempnl, this.tempno, this.tempso, this.tempsl};

    public void setinteractions() {
        this.follows(this.gm(radfor.class));
        this.follows(this.gm(histtemp.class));
        this.setaffectedby(this.gm(udebclimod.class));
    }

    public void initsetup() {
        this.temp.associate(baseyear);
        this.boxtemp.associate(baseyear);
    }

    public void startstate(int startyear) {
        this.gm(udebclimod.class).startstate(startyear);
    }

    public void save99() {
        this.gm(udebclimod.class).save99();
    }

    public void precalc() {
        if (baserange.getval() + baseyear.getval() > 2005.0) {
            baseyear.set(2005.0 - baserange.getval());
        }
    }

    public void calcstep() {
        udebclimod udeb = this.gm(udebclimod.class);
        radfor rf = this.gm(radfor.class);
        this.avchange.set(year, udeb.adjust(new float[]{rf.splitrf[0].get(year), rf.splitrf[1].get(year), rf.splitrf[2].get(year), rf.splitrf[3].get(year)}));
        udeb.tempupwellfb(this.avchange.get(year));
        if ((double)year == (double)((int)baseyear.getval()) + baserange.getval()) {
            this.calcoffset();
        }
        this.gm(sealevel.class).thermexp.set(year, udeb.thermalexpansion());
    }

    public void postcalc() {
        this.applyoffset();
        this.calcerror();
    }

    public void calcoffset() {
        this.oldoffset = this.offset;
        this.offset = 0.0;
        for (int b = 0; b < 4; ++b) {
            this.boxoffset[b] = 0.0f;
        }
        int r = (int)baserange.getval();
        int rw = 1 + r * 2;
        for (int i = 0; i < rw; ++i) {
            int dy = (int)baseyear.getval() + i - r;
            if (dy < gsy) {
                dy = gsy;
            }
            this.offset += (double)(this.avchange.get(dy) / (float)rw);
            for (int b = 0; b < 4; ++b) {
                int n = b;
                this.boxoffset[n] = this.boxoffset[n] + this.boxtempqt[b].get(dy) / (float)rw;
            }
        }
    }

    void applyoffset() {
        for (int y = 0; y <= gey; ++y) {
            for (int b = 0; b < 4; ++b) {
                this.boxtempqt[b].set(y, this.boxtempqt[b].get(y) - this.boxoffset[b]);
            }
            this.avchangeby.set(y, (float)((double)this.avchange.get(y) - this.offset));
        }
    }

    double gettemprise(int b) {
        if (this.usehisttempdata && year < 2007) {
            float nfac = 0.0f;
            for (int s = 1848; s < 1853; ++s) {
                nfac += histtemp.proxytemp.get(s) / 5.0f;
            }
            float temprise = (year < 1850 ? histtemp.proxytemp.get(year) : histtemp.tempdataCRU.get(year)) - nfac;
            return (double)temprise * (b == 0 ? 1.356 : 0.847);
        }
        return year > 1750 ? (double)(this.boxtempqt[b].get(year - 1) + this.boxtempqt[3 - b].get(year - 1) + (loop.calcfutureonly && year <= 2000 || !this.changed ? this.boxoffset[b] + this.boxoffset[3 - b] : 0.0f)) / 2.0 : 0.0;
    }

    public double getoceantemprise() {
        return this.gettemprise(1);
    }

    public double getlandtemprise() {
        return this.gettemprise(0);
    }

    public void calcerror() {
        float sumdiff = 0.0f;
        float sumdata = 0.0f;
        float sumcalc = 0.0f;
        float n = 0.0f;
        for (int y = gsy; y < 2007; ++y) {
            float e;
            float mt;
            float ct = this.avchangeby.get(y);
            if (y < 1850) {
                mt = histtemp.proxytemp.get(y);
                e = 0.5f;
            } else {
                mt = histtemp.tempdataCRU.get(y);
                e = 0.05f + 0.0015f * (float)(y < 1950 ? 1950 - y : 0);
            }
            sumdiff += (ct - mt) * (ct - mt) / e;
            sumcalc += ct / e;
            sumdata += mt / e;
            n += 1.0f / e;
        }
        this.error = Math.pow(sumdiff / n - (sumcalc / n - sumdata / n) * (sumcalc / n - sumdata / n), 0.5);
    }
}

