/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.register;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;

public class histoplot
extends baseplot {
    param year;
    List regs = new ArrayList();
    curveset qqx;
    curveset qqy;
    curvar qqv;
    Comparator comp = new Comparator(){

        public int compare(Object a, Object b) {
            return histoplot.this.calcratio(a) > histoplot.this.calcratio(b) ? 1 : (histoplot.this.calcratio(a) < histoplot.this.calcratio(b) ? -1 : 0);
        }
    };

    public histoplot(curveset qq) {
        this(new Object[]{qq});
    }

    public histoplot(Object[] args) {
        for (Object o : args) {
            if (o instanceof curvar) {
                this.qqv = (curvar)o;
                this.qq = this.qqv;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(o.toString())));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.qqy = this.qqv.linkqq.get(0);
        this.qqx = this.qqv.linkqq.get(1);
        double minsy = Math.max(this.qqy.sy, this.qqx.sy);
        double maxey = Math.min(this.qqy.ey, this.qqx.ey);
        this.year = new param("year", 2002, minsy, maxey, "year");
        register.addlink(this, this.year);
        this.setup();
        this.sort();
        this.plot.add((Component)new paramValueChooser(this.year, new Object[0]), "North");
    }

    void makeplot() {
        this.plot = new histo();
    }

    public void doplot() {
        this.sort();
        super.repaint();
    }

    void makescales() {
        for (Object o : this.qqx.mapwithouttotal().keySet()) {
            this.regs.add(o);
        }
        float sum = 0.0f;
        float max = 0.0f;
        for (Object o : this.regs) {
            sum += this.qqx.getOrAddCurve(o).get((int)this.year.val);
            float f = this.calcratiotot(o);
            if (!(f > max)) continue;
            max = f;
        }
        this.yscale = new param(new Object[]{param.Type.Yscale, "Yscale", this.qqy.units + "&per&" + this.qqx.units, 0, 0, Float.valueOf(max)});
        this.xscale = new param(new Object[]{param.Type.Xscale, "Xscale", this.qqx.units, 0, 0, Float.valueOf(sum)});
    }

    public void fillMenu(jcmMenu popup) {
        popup.add(makederiv.makeDerivMenu(curve.Type.extra, this.qq));
        popup.addSeparator();
        super.fillMenu(popup);
    }

    float calcratio(Object o) {
        return this.calcratio(o, this.qqy);
    }

    float calcratio(Object o, curveset qqy) {
        float fr = this.qqx.getOrAddCurve(o).get((int)this.year.val);
        if (fr <= 0.0f) {
            return 0.0f;
        }
        return qqy.getOrAddCurve(o).get((int)this.year.val) / fr;
    }

    float calcratiotot(Object o) {
        float f = 0.0f;
        for (curveset qqy : this.qqv.linkqq) {
            if (qqy == this.qqx) continue;
            f += this.calcratio(o, qqy);
        }
        return f;
    }

    void sort() {
        Collections.sort(this.regs, this.comp);
    }

    class histo
    extends JPanel
    implements MouseMotionListener {
        public histo() {
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            int w = this.getSize().width;
            int h = this.getSize().height;
            float xx = -histoplot.this.xscale.min() * (float)w / histoplot.this.xscale.range();
            for (Object o : histoplot.this.regs) {
                if (o instanceof infob) {
                    g.setColor(((infob)o).getColor());
                }
                float x = histoplot.this.qqx.getOrAddCurve(o).get((int)histoplot.this.year.val) * (float)w / histoplot.this.xscale.range();
                float yy = h;
                for (curveset qqy : histoplot.this.qqv.linkqq) {
                    if (qqy == histoplot.this.qqx) continue;
                    float y = (int)(histoplot.this.calcratio(o, qqy) * (float)h / histoplot.this.yscale.max());
                    if (y < 0.0f) {
                        g.setColor(Color.white);
                        g.fillRect((int)xx + 1, (int)yy + 1, (int)x - 2, (int)(-y) - 1);
                    } else {
                        g.fillRect((int)xx, (int)(yy - y) - 1, (int)x, (int)y - 1);
                    }
                    g.setColor(histoplot.this.variant(g.getColor()));
                    yy -= y;
                }
                xx += x;
            }
            histoplot.this.ready = true;
        }

        public void mouseMoved(MouseEvent e) {
            float xx = 0.0f;
            for (Object o : histoplot.this.regs) {
                float x = histoplot.this.qqx.getOrAddCurve(o).get((int)histoplot.this.year.val) * (float)this.getSize().width / histoplot.this.xscale.max();
                if (xx + x > (float)e.getX() && o instanceof infob) {
                    String s = "<html>" + ((infob)o).hashcolor() + ((infob)o).getName();
                    for (curveset qqy : histoplot.this.qqv.linkqq) {
                        if (qqy == histoplot.this.qqx) continue;
                        s = s + " " + histoplot.this.calcratio(o, qqy);
                    }
                    this.setToolTipText(s);
                    return;
                }
                xx += x;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

