/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.event.MouseInputListener;
import jcm.core.ob.interacob;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.plot.colormap;
import jcm.gui.plot.scaleview;
import jcm.mod.regimp.mapdata;

public class colorscale
extends scaleview
implements MouseInputListener {
    colormap cm;
    JButton reset;
    jcmAction resetAction;
    static int r;
    static int g;
    static int b;
    public static Color[] c;

    public colorscale(colormap source) {
        this.cm = source;
        this.cm.resetscale();
        this.sp = new param(new Object[]{param.Type.Xscale, "Xscale", "", 0, this.cm.getmin(), this.cm.getrange() + this.cm.getmin()}){

            public void precalc() {
                report.deb("sp precalc");
                if (colorscale.this.cm.hasresetscale()) {
                    colorscale.this.resetcols();
                }
            }
        };
        this.resetAction = new jcmAction("Reset Colors"){

            public void act() {
                colorscale.this.cm.resetscale();
                colorscale.this.resetcols();
                colorscale.this.sp.changed = true;
                colorscale.this.sp.respond(true);
            }
        };
        this.reset = new JButton(this.resetAction);
        this.origin = this.cm.getmin() + this.cm.getrange() / 2.0;
        this.setBackground(colfont.white);
        this.setPreferredSize(new Dimension(400, 32));
        this.setToolTipText(labman.getTitle(this.sp.getstate()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(11));
        if (this.cm instanceof interacob) {
            this.sp.setaffectedby((interacob)((Object)this.cm));
        }
    }

    public void resetcols() {
        this.sp.min = this.cm.getmin();
        this.sp.max = this.cm.getrange() + this.cm.getmin();
        this.origin = this.cm.getmin() + this.cm.getrange() / 2.0;
        this.sp.units.checkunitfac(this.sp.range());
        this.repaint();
        report.deb("sp adjusted " + this.sp.min + "-" + this.sp.max);
    }

    public void paintComponent(Graphics g) {
        lookandfeel.setAntiAlias(g);
        this.lw = 20;
        this.w = this.getWidth() - 2 * this.lw;
        this.h = this.getHeight();
        g.clearRect(0, 0, this.w + 2 * this.lw, this.h);
        for (int x = 0; x <= this.w; ++x) {
            float f = this.sp.min() + (float)x * this.sp.range() / (float)this.w;
            g.setColor(this.getColor(f));
            g.drawLine(x + this.lw, 0, x + this.lw, this.h / 2);
        }
        g.setFont(colfont.normalfont);
        this.drawnums(g);
    }

    public float sptocm(float f) {
        return (float)(this.cm.getmin() + (double)(f - this.sp.min()) * this.cm.getrange() / (double)this.sp.range());
    }

    public Color getColor(float f) {
        return colorscale.getColor(f, this.sp.min(), this.sp.range());
    }

    public static void makerainbow() {
        for (int i = 0; i < 256; ++i) {
            b = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 43) / 256.0));
            g = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 128) / 256.0));
            r = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 213) / 256.0));
            colorscale.c[i] = new Color(r, g, b);
        }
    }

    public static Color getColor(double f, double min, double range) {
        if (mapdata.dud((float)f)) {
            return colfont.white;
        }
        int q = (int)(256.0 * (f - (min - (double)0.1f * range)) / (range * (double)1.2f) + 4096.0) % 256;
        if (q > 0) {
            return c[q];
        }
        return colfont.white;
    }

    static {
        c = new Color[256];
        colorscale.makerainbow();
    }
}

