/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jcm.core.complexity;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;

public class imagesaver {
    public static jcmAction copyaction(final Component painter) {
        return new jcmAction("Copy image"){

            public void act() {
                imagesaver.copy(painter);
            }
        };
    }

    public static jcmMenu saveimagemenu(final Component painter, final String name) {
        jcmMenu saveimage = new jcmMenu(new Object[]{"Save image", complexity.simplest});
        for (final String s : new String[]{"png", "png-transparent", "jpg"}) {
            saveimage.add(new jcmAction(s, complexity.simplest){

                public void act() {
                    imagesaver.saveimage(painter, name, s);
                }
            });
        }
        return saveimage;
    }

    static BufferedImage getimage(Component c, boolean transparent) {
        BufferedImage bi = new BufferedImage(c.getSize().width, c.getSize().height, transparent ? 6 : 5);
        c.paintAll(bi.getGraphics());
        return transparent ? imagesaver.maketrans(bi) : bi;
    }

    static BufferedImage maketrans(BufferedImage bi) {
        try {
            BufferedImage bi2 = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            int mask = bi.getRGB(0, 0);
            for (int x = 0; x < bi.getWidth(); ++x) {
                for (int y = 0; y < bi.getHeight(); ++y) {
                    bi2.setRGB(x, y, bi.getRGB(x, y) == mask ? 0 : bi.getRGB(x, y));
                }
            }
            return bi2;
        }
        catch (Exception e) {
            return null;
        }
    }

    static String converttype(String type2) {
        String type22 = type2.substring(0, 3);
        if (type22.equals("jpg")) {
            type22 = "jpeg";
        }
        return type22;
    }

    static boolean transparent(String type2) {
        return type2.endsWith("transparent");
    }

    public static void saveimage(Component painter, String name, String type2) {
        fileio f = new fileio("images", name, type2.substring(0, 3), "Save Image", "save");
        imagesaver.saveimage(painter, type2, f);
    }

    public static void saveimage(Component painter, String type2, File f) {
        imagesaver.saveimage(painter, type2, new fileio(f));
    }

    public static void saveimage(Component painter, String type2, fileio f) {
        try {
            BufferedImage b = imagesaver.getimage(painter, imagesaver.transparent(type2));
            ImageIO.write((RenderedImage)b, imagesaver.converttype(type2), f.os);
            f.save();
        }
        catch (Exception e) {
            report.deb(e, "Couldn't Save Image");
        }
    }

    public static void copy(final Component c) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.imageFlavor};
                }

                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(DataFlavor.imageFlavor);
                }

                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return imagesaver.getimage(c, false);
                }
            }, new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
            report.log("copied image");
        }
        catch (Exception ex) {
            report.deb(ex, "Error copying " + c);
        }
    }
}

