/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jcm.core.ob.infob;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.doc.docview;
import jcm.gui.nav.jcmTree;

public class iconFinder {
    private static Map<URL, ImageIcon> icons;
    private static Map<String, String> iconalias;

    public static String get(String s) {
        return s == null ? null : iconalias.get(s.toLowerCase());
    }

    public static String findAlias(String s) {
        String s2 = iconFinder.get(s);
        if (s2 == null) {
            s2 = iconFinder.get(infob.removepackagename(s));
        }
        return iconFinder.get(s2);
    }

    public static String findAlias(infob io) {
        String s = iconFinder.get(io.name.toLowerCase());
        if (s == null && io.name.indexOf("&") > 0) {
            for (String s2 : txt.split(io.name, "&")) {
                s = iconFinder.get(s2.toLowerCase());
            }
        }
        if (s == null) {
            s = iconFinder.get(io.type());
        }
        return s;
    }

    public static String findAlias(Object c) {
        String s;
        if (c instanceof infob) {
            return iconFinder.findAlias((infob)c);
        }
        if (c instanceof String) {
            return iconFinder.findAlias((String)c);
        }
        if (c instanceof Enum) {
            return iconFinder.findAlias(c.toString());
        }
        String string = c instanceof jcmTree ? iconFinder.get(((jcmTree)c).getRoot().name) : (s = c instanceof docview ? iconFinder.get(((docview)c).page) : null);
        if (s == null) {
            s = iconFinder.findAlias(c.getClass().getSimpleName());
        }
        return s;
    }

    public static Icon findIcon(String s) {
        return iconFinder.getIcon(iconFinder.findAlias(s));
    }

    public static Icon findIcon(infob io) {
        return iconFinder.getIcon(iconFinder.findAlias(io));
    }

    public static Icon findIcon(Object c) {
        return iconFinder.getIcon(iconFinder.findAlias(c));
    }

    public static Icon getIcon(String alias) {
        try {
            URL u = fileio.getURL("png/" + alias + ".png");
            if (u != null) {
                return iconFinder.filter(u);
            }
            if (alias != null) {
                return iconFinder.texticon(alias);
            }
        }
        catch (Exception e) {
            report.deb(e, "can't make icon " + alias);
        }
        return null;
    }

    public static Icon texticon(final String s) {
        int w = 20;
        int h = 20;
        return new Icon(){

            public int getIconHeight() {
                return 20;
            }

            public int getIconWidth() {
                return 20;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.drawRoundRect(x + 1, y + 1, 18, 18, 6, 6);
                Rectangle r = g.getClipBounds();
                g.setClip(0, 0, 20, 20);
                g.drawString(s, x + 2, y + 16);
                g.setClip(r);
            }
        };
    }

    static ImageIcon filter(URL u) {
        if (icons.get(u) == null) {
            try {
                BufferedImage bi = ImageIO.read(u);
                BufferedImage bi2 = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
                int mask = bi.getRGB(0, 0);
                for (int x = 0; x < bi.getWidth(); ++x) {
                    for (int y = 0; y < bi.getHeight(); ++y) {
                        bi2.setRGB(x, y, bi.getRGB(x, y) == mask ? 0 : bi.getRGB(x, y));
                    }
                }
                icons.put(u, new ImageIcon(bi2));
            }
            catch (Exception e) {
                report.deb(e);
                return null;
            }
        }
        return icons.get(u);
    }

    static {
        String[][] sss;
        icons = new HashMap<URL, ImageIcon>();
        iconalias = new HashMap<String, String>();
        String[][] arr$ = sss = fileio.loadtab("png/iconnames.txt", ",");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] ss;
            for (String s : ss = arr$[i$]) {
                iconalias.put(s.toLowerCase(), ss[0]);
            }
        }
    }
}

