/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.ob;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import jcm.core.complexity;
import jcm.core.itf.dataholder;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.ob.packageob;
import jcm.core.ob.root;
import jcm.core.report;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;
import jcm.indata.loaddata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class world
extends packageob {
    public static String defname = "World 1";
    public static List<world> worlds = new LinkedList<world>();
    public static packageob worldsob = new packageob("Worlds");
    static Icon wi = iconFinder.findIcon("world");
    static boolean spareworld = false;
    static boolean incdataholder = true;
    public List<module> mods = new LinkedList<module>();
    Map<Class, module> modmap = new LinkedHashMap<Class, module>();

    public world(String s) {
        this(s, s.equals(defname) ? Color.black : world.rcol());
    }

    public world(String s, Color col) {
        super(new Object[0]);
        this.name = s;
        this.color = col;
        this.mycomplexity = complexity.simplest;
        worlds.add(this);
        worldsob.addOb(this);
        this.addAction(filter.filtertype.Worlds, new jcmAction("RemoveWorld"){

            public void act() {
                world.this.disposeWorld(true);
            }
        });
        this.addAction(filter.filtertype.Worlds, new jcmAction("ReNameWorld"){

            public void act() {
                world.this.name = JOptionPane.showInputDialog(null, (Object)("Enter new name for " + world.this.name));
                world.update();
            }
        });
        this.addAction(filter.filtertype.Worlds, new jcmAction("SetColorOfWorld"){

            public void act() {
                new JColorChooser();
                world.this.color = JColorChooser.showDialog(showpan.mf, "Choose Colour for " + world.this.name, world.this.color);
                world.update();
            }
        });
        this.addAction(filter.filtertype.Doc);
        this.addAction(filter.filtertype.Tree);
        this.makemods();
    }

    static void update() {
        jcmTree.restruclink.changed = true;
        loop.golater("World Update");
    }

    public static void makeworld(String name, Color color) {
        if (spareworld) {
            world w = worlds.get(0);
            w.name = name;
            w.color = color;
            spareworld = false;
        } else {
            new world(name, color);
        }
    }

    public static void disposeAllButOne() {
        while (worlds.size() > 1) {
            try {
                worlds.get(1).disposeWorld(false);
            }
            catch (Exception ex) {
                report.deb(ex, "setup remove old worlds error ");
            }
        }
        if (worlds.size() > 0) {
            spareworld = true;
        }
    }

    public static jcmAction addWorld() {
        return new jcmAction("AddWorld"){

            public void act() {
                String name = JOptionPane.showInputDialog(null, (Object)"Enter name for new world ");
                new world(name);
                world.update();
            }
        };
    }

    public void disposeWorld(boolean newthread) {
        report.deb("Disposing world: " + this.name);
        world.worldsob.obs.remove(this);
        worlds.remove(this);
        if (newthread) {
            this.disposeLater();
        } else {
            this.disposethis();
            jcmTree.restruclink.changed = true;
            loop.gonow();
        }
    }

    public world gm(String name) {
        for (world w : worlds) {
            if (!w.name.equals(name)) continue;
            return w;
        }
        return null;
    }

    public <T extends module> T gm(Class<T> c) {
        if (dataholder.class.isAssignableFrom(c)) {
            report.deb("can't get instanceof static dataholder module! " + c);
            return null;
        }
        return (T)this.modmap.get(c);
    }

    void makemods() {
        this.obs = this.worldtree((infob)root.rootob.find((String)"jcm.mod")).obs;
        this.setupmods();
        incdataholder = false;
        this.setupmods();
    }

    void setupmods() {
        report.logn("================World Setting up " + (incdataholder ? "data" : "other") + " modules: ====================\n ");
        loopcalc.reporttime("Starting world setup: ");
        if (incdataholder) {
            loaddata.getdata(this);
        }
        for (module mod : this.mods) {
            if (mod instanceof dataholder != incdataholder) continue;
            report.log("Setup " + mod);
            try {
                mod.initsetup();
                mod.register();
            }
            catch (Exception e) {
                report.deb(e, "\n -!-!-!- Error in Initsetup of  " + mod.getName() + " -!-!-!- \n");
            }
        }
        report.logn("==============Finished setup of " + (incdataholder ? "data" : "other") + " modules: ===============\n ");
    }

    public infob worldtree(infob orig) {
        if (orig.getObs() != null) {
            packageob copy = new packageob(orig.getName(), orig.color, orig.priority);
            for (infob o : orig.getObs()) {
                infob hh = this.worldtree(o);
                if (hh != null && (hh instanceof module || hh.getObs() != null && hh.getObs().size() > 0)) {
                    copy.addOb(hh);
                }
                if (!(hh instanceof module)) continue;
                hh.color = copy.color;
            }
            return copy;
        }
        return world.createMod(orig, this);
    }

    public static module createMod(infob orig, world w) {
        Class<?> c = null;
        try {
            c = w.getClass().getClassLoader().loadClass(orig.getName());
        }
        catch (ClassNotFoundException e) {
            report.deb(e, "createMod: " + orig.name);
            return null;
        }
        module mod = w.modmap.get(c);
        if (mod != null) {
            return mod;
        }
        try {
            if (!incdataholder && dataholder.class.isAssignableFrom(c)) {
                return null;
            }
            if (module.class.isAssignableFrom(c)) {
                mod = (module)c.newInstance();
                mod.world = w;
                mod.checkinfo();
                w.mods.add(mod);
                w.modmap.put(mod.getClass(), mod);
                return mod;
            }
        }
        catch (Exception e) {
            report.deb(e, "createMod:" + orig.name);
        }
        return null;
    }

    static {
        worldsob.addAction(filter.filtertype.Worlds, world.addWorld());
        root.rootob.addOb(worldsob);
    }
}

