/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.ob;

import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jcm.core.anno.todo;
import jcm.core.anno.todos;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.itf.hasComplexity;
import jcm.core.itf.menuFiller;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.ob.packageob;
import jcm.core.ob.world;
import jcm.core.par.param;
import jcm.core.report;
import jcm.core.tls.cs;
import jcm.core.tls.ref;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.docview;
import jcm.gui.doc.label;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.colfont;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.interacmap;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;
import jcm.script.calcscript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class infob
implements menuFiller,
Comparable<infob>,
hasComplexity {
    public String name = this.getClass().getSimpleName();
    public infob owner = this;
    public Annotation[] notes = null;
    public Set<infob> obs;
    public Map<jcmAction, filter.filtertype> actions;
    public complexity mycomplexity = complexity.simplest;
    public Color color = Color.black;
    public double priority = 1.0;
    public boolean disposed = false;
    int level = 9999;
    double cump = 0.0;
    boolean expanded = false;
    public static EnumSet singleaction = EnumSet.of(filter.filtertype.Doc, filter.filtertype.Scripts, filter.filtertype.Source, filter.filtertype.Data, filter.filtertype.Maps);

    public infob() {
        this.color = infob.rcol();
    }

    public infob(Object ... args) {
        this.color = null;
        for (Object o : args) {
            if (o instanceof infob) {
                this.owner = (infob)o;
                if (this.color == null) {
                    Color color = this.color = this instanceof world ? infob.rcol() : infob.rcol(this.owner.color);
                }
            }
            if (o instanceof String) {
                this.name = (String)o;
                this.checkinfo();
            }
            if (o instanceof Color) {
                this.color = (Color)o;
            }
            if (o instanceof Number) {
                this.priority = ((Number)o).floatValue();
            }
            if (!(o instanceof complexity)) continue;
            this.mycomplexity = (complexity)((Object)o);
        }
        if (this.color == null) {
            this.color = Color.black;
        }
    }

    void checkinfo() {
        for (Object[] oo : packageob.setupinfo) {
            if (!infob.removepackagename(this.name).equals((String)oo[0])) continue;
            this.priority = (Double)oo[1];
            if (oo.length == 3) {
                this.color = (Color)oo[2];
            }
            return;
        }
    }

    public void addAction(jcmAction a) {
        this.addAction(null, a);
    }

    public void addAction(filter.filtertype f, jcmAction a) {
        if (this.actions == null) {
            this.actions = new LinkedHashMap<jcmAction, filter.filtertype>();
        }
        this.actions.put(a, f);
    }

    public void addAction(filter.filtertype f) {
        if (this.actions != null && this.actions.containsValue((Object)f)) {
            return;
        }
        if (f == filter.filtertype.Doc) {
            this.addAction(f, docview.showdocaction(this));
        }
        if (f == filter.filtertype.Tree) {
            this.addAction(f, showpan.pan("Tree", jcmTree.class, "[" + this + "]"));
        }
        if (f == filter.filtertype.interacmap) {
            this.addAction(f, showpan.pan("interacmap", interacmap.class, this));
        }
        if (f == filter.filtertype.Source) {
            this.addAction(f, showpan.pan("Source", sourceview.class, this.getSourceFileName()));
        }
        if (f == filter.filtertype.Data) {
            this.addAction(f, showpan.pan("Data", sourceview.class, this.getDataFileName()));
        }
    }

    String getDataFileName() {
        String f = this.getName().replace(".", "/");
        int i = f.lastIndexOf("/");
        if (i > 0 && i < f.length()) {
            f = f.substring(0, i) + "." + f.substring(i + 1, f.length());
        }
        return f;
    }

    String getSourceFileName() {
        String s = this instanceof module ? this.getClass().getName() : this.getName();
        return "src/" + s.replace(".", "/") + ".java";
    }

    void addClassActions() {
        try {
            final Class<?> c = Class.forName(this.getName());
            if (Modifier.isPublic(c.getModifiers())) {
                this.addAction(filter.filtertype.Source);
            }
            if (calcscript.class.isAssignableFrom(c)) {
                this.addAction(filter.filtertype.Scripts, new jcmAction(c.getSimpleName()){

                    public void act() {
                        try {
                            ((calcscript)c.newInstance()).start();
                        }
                        catch (Exception ex) {
                            report.deb(ex, "Problem Starting Script");
                        }
                    }
                });
            }
        }
        catch (ClassNotFoundException e) {
            this.addAction(filter.filtertype.Data);
        }
    }

    public boolean hasEnabledActions(Set<filter.filtertype> fs) {
        if (this.actions != null) {
            for (jcmAction a : this.actions.keySet()) {
                if (!this.checkenabled((Action)a, fs)) continue;
                return true;
            }
        }
        return false;
    }

    public filter.filtertype doFirstEnabledAction(Set<filter.filtertype> fs) {
        if (this.actions != null) {
            for (jcmAction a : this.actions.keySet()) {
                if (!this.checkenabled((Action)a, fs)) continue;
                a.act();
                return this.actions.get(a);
            }
        }
        return null;
    }

    public void mincomplexity() {
        this.mincomplexity(this.getObs());
    }

    public void mincomplexity(Collection<? extends infob> obs) {
        if (obs != null) {
            this.mycomplexity = complexity.experimental;
            for (infob infob2 : obs) {
                this.mycomplexity = infob2.getComplexity().compareTo(this.mycomplexity) < 0 ? infob2.getComplexity() : this.mycomplexity;
            }
        }
    }

    @Override
    public complexity getComplexity() {
        return this.mycomplexity != null ? this.mycomplexity : complexity.normal;
    }

    public boolean checkcomplexity() {
        return complexity.check(this.getComplexity());
    }

    public boolean checkenabled(Action a, filter.filtertype f) {
        return this.actions.get(a) == null || this.actions.get(a) == f;
    }

    public boolean checkenabled(Action a, Set<filter.filtertype> fs) {
        for (filter.filtertype f : fs) {
            if (!this.checkenabled(a, f)) continue;
            return true;
        }
        return false;
    }

    public boolean checkenabled(filter.filtertype f) {
        return this.checkenabled(Collections.singleton(f));
    }

    public boolean checkenabled(Set<filter.filtertype> fs) {
        if (!this.checkcomplexity()) {
            return false;
        }
        if (this instanceof param && (fs.contains((Object)filter.filtertype.AllParams) || fs.contains((Object)filter.filtertype.NeededParams) && ((param)this).checkneededforplot())) {
            return true;
        }
        if (this instanceof curveset && fs.contains((Object)filter.filtertype.Curves)) {
            return true;
        }
        if (this.actions != null) {
            for (jcmAction a : this.actions.keySet()) {
                if (!this.checkenabled((Action)a, fs)) continue;
                return true;
            }
        }
        if (this.obs != null) {
            for (infob o : this.obs) {
                if (!o.checkenabled(fs)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void fillMenu(jcmMenu m) {
        this.fillMenu(m, filter.all());
    }

    public void fillMenu(jcmMenu m, Set<filter.filtertype> fs) {
        if (this.actions != null) {
            for (jcmAction a : this.actions.keySet()) {
                if (fs != null && !this.checkenabled((Action)a, fs)) continue;
                m.add(a);
            }
        }
    }

    public void fillTreeMenu(jcmMenu m) {
        List<infob> enabobs = this.getEnabledObs(m.filters);
        if (m.isTopLevelMenu() && enabobs != null && enabobs.size() == 1 && !this.hasEnabledActions(m.filters)) {
            enabobs.get(0).fillTreeMenu(m);
            return;
        }
        this.fillMenu(m, m.filters);
        if (enabobs != null) {
            for (infob i : enabobs) {
                if (m.filters.size() == 1 && singleaction.containsAll(m.filters) && i.getEnabledObs(m.filters) == null && i.actions != null) {
                    for (jcmAction a : i.actions.keySet()) {
                        if (i.actions.get(a) != m.filters.iterator().next()) continue;
                        m.add(a.clone(i.name));
                    }
                    continue;
                }
                m.add(i);
            }
        }
        if (m.filters.size() == 1) {
            m.add(showpan.pan(docview.class, "About&" + (Object)((Object)m.filters.iterator().next()) + "Menu"));
        }
    }

    public world getworld() {
        if (this.owner instanceof world) {
            return (world)this.owner;
        }
        if (this.owner instanceof module) {
            return ((module)this.owner).world;
        }
        if (this.owner == this) {
            return null;
        }
        return this.owner.getworld();
    }

    public module getmodule() {
        if (this.owner instanceof module) {
            return (module)this.owner;
        }
        if (this.owner == this) {
            return null;
        }
        return this.owner.getmodule();
    }

    public infob getOwner() {
        return this.owner;
    }

    public Set<infob> getObs() {
        return this.obs;
    }

    public List<infob> getEnabledObs(Set<filter.filtertype> fs) {
        if (fs.contains((Object)filter.filtertype.Doc) && !this.expanded) {
            this.expandDocTree();
        }
        if (this.obs == null) {
            return null;
        }
        ArrayList<infob> eo = new ArrayList<infob>();
        for (infob o : this.obs) {
            if (o == null || !o.checkenabled(fs)) continue;
            eo.add(o);
        }
        if (eo.size() > 0) {
            return eo;
        }
        return null;
    }

    public void addOb(infob b) {
        if (this.getObs() == null) {
            this.obs = new TreeSet<infob>();
        }
        this.getObs().add(b);
        b.level = this.level + 1;
        b.priority += this.cump;
        this.cump += 0.01;
    }

    @Override
    public int compareTo(infob b) {
        int i = (int)Math.signum(b.priority - this.priority);
        if (i == 0) {
            i = this.name.compareTo(b.name);
        }
        if (i == 0) {
            return this.equals(b) ? 0 : this.hashCode() - b.hashCode();
        }
        return i;
    }

    public void removeOb(Object h) {
        if (this.getObs() != null) {
            this.getObs().remove(h);
        }
    }

    public infob find(String s) {
        return this.find(this, s);
    }

    public infob find(Object orig, String s) {
        String s2 = s.toLowerCase();
        if (this.obs != null) {
            for (infob o : this.obs) {
                if (!o.toString().equals(s)) continue;
                return o;
            }
            for (infob o : this.obs) {
                if (!o.toString().toLowerCase().equals(s2)) continue;
                return o;
            }
            for (infob o : this.obs) {
                infob oo;
                if (o == orig || (oo = o.find(orig, s)) == null) continue;
                return oo;
            }
        }
        return null;
    }

    public void disposeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                loop.waitUntilLoopDone();
                infob.this.disposethis();
                jcmTree.restruclink.changed = true;
                loop.gonow();
            }
        });
    }

    public void disposethis() {
        if (this.disposed || ref.isstatic(this, this.owner)) {
            return;
        }
        this.disposed = true;
        this.name = this.name + "&disposed";
        if (this.obs != null) {
            for (infob i : this.obs) {
                i.disposethis();
            }
            this.obs = null;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String hashcolor() {
        return infob.hashcolor(this.getColor());
    }

    public static String hashcolor(Color c) {
        int fac = c.getRed() + c.getGreen() + c.getBlue() < 512 ? 1 : 2;
        return "<font color=#" + infob.hex2(c.getRed() / fac) + infob.hex2(c.getGreen() / fac) + infob.hex2(c.getBlue() / fac) + " >";
    }

    public static String hex2(int x) {
        return (x < 16 ? "0" : "") + Integer.toHexString(x);
    }

    public static Color rcol() {
        return new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random())).darker();
    }

    public static Color rcol(Color b) {
        if (b == null) {
            return infob.rcol();
        }
        return new Color((int)(127.0 * Math.random() + (double)((float)b.getRed() / 2.0f)), (int)(127.0 * Math.random() + (double)((float)b.getGreen() / 2.0f)), (int)(127.0 * Math.random() + (double)((float)b.getBlue() / 2.0f))).darker();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return (this.owner != this ? this.owner.getFullName() + "&" : "") + this.name;
    }

    public String getNameWithWorld() {
        return world.worlds.size() > 1 ? (this.getworld() != null ? this.getworld().name + "&" : "null&") + this.name : this.name;
    }

    public static String removepackagename(String s) {
        int i = s.indexOf(".");
        return i > 0 ? infob.removepackagename(s.substring(i + 1)) : s;
    }

    public String type() {
        return this.getClass().getSimpleName();
    }

    public String getLabel() {
        return labman.getShort(this.name);
    }

    public String getTitle() {
        return labman.getTitle(this.name);
    }

    public String getExtraDoc() {
        return this.docNotes() + autodoc.javacodeforclass(this.name);
    }

    public String getSpecificDoc(Object ... args) {
        return "<p><b>!specific doc request " + args[0] + " for " + this.name + " no longer implemented!</b><p> ";
    }

    public String docSummary() {
        try {
            this.getClass();
            Class.forName(this.name);
            String n2 = infob.removepackagename(this.name);
            return autodoc.link(n2) + "</font> " + "\u00a3%" + n2 + "<br>";
        }
        catch (ClassNotFoundException e) {
            return autodoc.link(this) + "</font> " + "\u00a3%" + labman.convertkey(this.name) + "<br>";
        }
    }

    public String docOwner() {
        return this.owner != this ? "<nobr>%%\u20ac\u20accogs \u00a3`memberof  " + autodoc.link(this.owner.name) + "%%</nobr><br>" : "";
    }

    public String docNotes() {
        String s = "";
        if (this.notes != null) {
            for (Annotation a : this.notes) {
                s = s + "<hr>  == \u20ac\u20accogs  \u00a3` " + a.annotationType().getSimpleName() + " == ";
                if (a instanceof todos) {
                    for (todo t : ((todos)a).value()) {
                        s = s + this.docNote(t);
                    }
                    continue;
                }
                s = s + this.docNote(a);
            }
        }
        return s;
    }

    public String docNote(Annotation a) {
        String s = "\n";
        try {
            for (Method m : a.annotationType().getMethods()) {
                String n = m.getName();
                if (n.equals("hashCode") || m.invoke((Object)a, new Object[0]).equals(m.getDefaultValue())) continue;
                Class<?> c = m.getReturnType();
                s = s + "<font color=" + (c == String.class ? "blue" : "green") + ">" + (c == String.class || c.isEnum() ? " " : " <i>" + n + "</i>: ") + m.invoke((Object)a, new Object[0]) + "</font>, ";
            }
        }
        catch (Exception e) {
            report.deb(e);
        }
        return s;
    }

    void expandDocTree() {
        int i;
        report.deb(this.name + " expand doc tree");
        ArrayList<String> links = new ArrayList<String>(5);
        cs doc = new cs(labman.getDoc(this.name));
        doc.swap("@", "\u00a3@");
        StringBuilder p = doc.s;
        String openflag = "\u00a3";
        int j = 0;
        int ofl = openflag.length();
        while ((i = p.indexOf(openflag, j)) >= 0) {
            j = doc.nextspace(i + ofl + 1);
            String type2 = p.substring(i + ofl, i + ofl + 1);
            String key = p.substring(i + ofl + 1, j);
            if (!type2.equals("@") && !type2.equals("\u00a3") && !type2.equals("*") && !type2.equals("%")) continue;
            links.add(key);
        }
        for (String link : links) {
            report.deb("-" + link);
            label lab = labman.getLabel(link);
            if (lab == null) continue;
            if (lab.jcmob == null) {
                lab.jcmob = autodoc.findob(link);
            }
            if (lab.jcmob == null) {
                lab.jcmob = new infob(new Object[]{link, complexity.simplest});
                lab.jcmob.addAction(filter.filtertype.Doc);
            }
            infob ob = lab.jcmob;
            boolean onlydoc = ob.actions != null && ob.actions.keySet().size() == 1 && ob.actions.get(ob.actions.keySet().iterator().next()) == filter.filtertype.Doc;
            if (!onlydoc || ob instanceof interacob || ob instanceof packageob || ob.level <= this.level + 1) continue;
            if (ob.owner != null) {
                ob.owner.removeOb(ob);
            }
            this.addOb(ob);
            ob.owner = this;
            report.deb("-ADDED");
        }
        this.expanded = true;
    }

    public JComponent getComponent(Object ... args) {
        Box b = Box.createHorizontalBox();
        JLabel jl = new JLabel(this.getLabel(), this.getIcon(), 2);
        jl.setForeground(this.getColor());
        jl.setFont(this instanceof curveset ? colfont.italic : colfont.normalfont);
        b.add(jl);
        b.addMouseListener(showpan.moulist);
        b.addMouseMotionListener(showpan.moulist);
        showpan.moulist.cimap.put(b, this);
        return b;
    }

    public Icon getIcon() {
        return iconFinder.findIcon(this);
    }
}

