/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.data;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.mod.luc.LUCdata;

public class pngdata {
    public static void save(int[][] table, String filename, Color[] cols) {
        int w = table.length;
        int h = table[0].length;
        byte[] red = new byte[19];
        byte[] green = new byte[19];
        byte[] blue = new byte[19];
        for (int i = 0; i < 19; ++i) {
            red[i] = (byte)cols[i].getRed();
            green[i] = (byte)cols[i].getGreen();
            blue[i] = (byte)cols[i].getBlue();
        }
        IndexColorModel icm = new IndexColorModel(5, 19, red, green, blue);
        BufferedImage bi = new BufferedImage(w, h, 13, icm);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                bi.setRGB(x, y, cols[table[x][y]].getRGB());
            }
        }
        File f = new File(filename);
        if (f != null) {
            try {
                ImageIO.write((RenderedImage)bi, "png", f);
                report.log("saved image: " + f);
            }
            catch (Exception ex) {
                report.log(ex, "Error in saving image file");
            }
        }
    }

    public static byte[][] load(String filename, Color[] cols) {
        int w = 720;
        int h = 360;
        URL u = fileio.getURL(filename);
        byte[][] data = new byte[w][h];
        try {
            BufferedImage bi2 = ImageIO.read(u);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    data[x][y] = pngdata.findbiome(bi2.getRGB(x, y), cols);
                }
            }
        }
        catch (Exception ex) {
            report.log(ex, "Error loading image file");
        }
        return data;
    }

    static byte findbiome(int rgb, Color[] cols) {
        Color ic = new Color(rgb);
        for (byte i = 0; i < cols.length; i = (byte)(i + 1)) {
            if (!cols[i].equals(ic)) continue;
            return i;
        }
        return 0;
    }

    public static void main(String[] args) {
        pngdata.test();
    }

    public static void test() {
        File f = new File("test.png");
        try {
            BufferedImage bi2 = ImageIO.read(f);
            int w = 720;
            int h = 360;
            StringBuffer a = new StringBuffer();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    a.append((char)(96 + pngdata.findbiome(bi2.getRGB(x, y), LUCdata.biomeclassification.A.colors)));
                }
                a.append("\n");
            }
            fileio.savetextfile("test.txt", a.toString());
        }
        catch (Exception ex) {
            report.log(ex, "Error in loading image file");
        }
    }
}

