/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import net.sourceforge.napkinlaf.NapkinKnownTheme;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.AbstractNapkinBorder;
import net.sourceforge.napkinlaf.borders.NapkinWrappedBorder;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;
import net.sourceforge.napkinlaf.util.NapkinBackground;
import net.sourceforge.napkinlaf.util.NapkinConstants;
import net.sourceforge.napkinlaf.util.NapkinDebug;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinTextPainter;

public class NapkinUtil {
    private static final Map<Float, Stroke> strokes = new WeakHashMap<Float, Stroke>();
    private static final BufferedImage textureImage;
    private static final float FOCUS_MARK_WIDTH = 1.5f;
    private static final String BACKGROUND = "background";
    private static final String BORDER = "border";
    private static final String OPAQUE = "opaque";
    private static final PropertyChangeListener BACKGROUND_LISTENER;
    private static final PropertyChangeListener BORDER_LISTENER;
    private static final PropertyChangeListener OPAQUE_LISTENER;
    private static final Insets NO_INSETS;
    private static final AlphaComposite ERASURE_COMPOSITE;
    private static final Stack<NapkinTheme> themeStack;
    private static final Stack<Component> paperStack;

    public static Object property(ComponentUI ui, String prop) {
        String name = ui.getClass().getName();
        String base = ".Napkin";
        int pos = name.lastIndexOf(base) + base.length();
        String pref = name.substring(pos, name.length() - 2);
        return pref + "." + prop;
    }

    private static boolean replaceBackground(Color bgColor) {
        return bgColor == null || bgColor != NapkinConstants.CLEAR && bgColor.getRed() == bgColor.getGreen() && bgColor.getGreen() == bgColor.getBlue();
    }

    public static void installUI(JComponent c) {
        if (c.isOpaque()) {
            c.putClientProperty("net.sourceforge.napkinlaf.wasOpaque", Boolean.TRUE);
            c.setOpaque(false);
        }
        c.addPropertyChangeListener(OPAQUE, OPAQUE_LISTENER);
        if (NapkinUtil.replaceBackground(c.getBackground())) {
            c.setBackground(NapkinConstants.CLEAR);
        }
        c.addPropertyChangeListener(BACKGROUND, BACKGROUND_LISTENER);
        NapkinUtil.setupBorder(c);
        c.addPropertyChangeListener(BORDER, BORDER_LISTENER);
    }

    public static void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(BORDER, BORDER_LISTENER);
        NapkinUtil.unsetupBorder(c);
        c.removePropertyChangeListener(BACKGROUND, BACKGROUND_LISTENER);
        c.removePropertyChangeListener(OPAQUE, OPAQUE_LISTENER);
        if (NapkinUtil.shouldMakeOpaque(c)) {
            c.setOpaque(true);
        }
        for (String clientProp : NapkinConstants.CLIENT_PROPERTIES) {
            c.putClientProperty(clientProp, null);
        }
    }

    private static boolean shouldMakeOpaque(JComponent c) {
        if (NapkinUtil.isGlassPane(c)) {
            return false;
        }
        return c.getClientProperty("net.sourceforge.napkinlaf.wasOpaque") == Boolean.TRUE && !c.isOpaque();
    }

    private static boolean isGlassPane(Component c) {
        if (c instanceof JComponent) {
            return NapkinUtil.isGlassPane((JComponent)c);
        }
        return false;
    }

    private static boolean isGlassPane(JComponent c) {
        JRootPane rootPane = c.getRootPane();
        return rootPane != null && rootPane.getGlassPane() == c;
    }

    public static double leftRight(double x, boolean left) {
        return left ? x : 100.0 - x;
    }

    public static Graphics2D copy(Graphics g) {
        return (Graphics2D)g.create();
    }

    public static Graphics2D lineGraphics(Graphics orig, float w) {
        return NapkinUtil.lineGraphics((Graphics2D)orig, w);
    }

    public static Graphics2D lineGraphics(Graphics2D orig, float w) {
        Graphics2D lineG = NapkinUtil.copy(orig);
        Stroke stroke = strokes.get(Float.valueOf(w));
        if (stroke == null) {
            stroke = new BasicStroke(w, 1, 1);
            strokes.put(Float.valueOf(w), stroke);
        }
        lineG.setStroke(stroke);
        lineG.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        lineG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return lineG;
    }

    public static Graphics2D defaultGraphics(Graphics g1, Component c) {
        Graphics2D g = (Graphics2D)g1;
        NapkinUtil.syncWithTheme(g, c);
        boolean enabled = c.isEnabled();
        if (!enabled && c instanceof JComponent) {
            Rectangle r = g.getClipBounds();
            int w = r.width;
            int h = r.height;
            BufferedImage tmp = new BufferedImage(w, h, 2);
            Graphics2D tg = tmp.createGraphics();
            Composite origComp = tg.getComposite();
            tg.setComposite(AlphaComposite.Clear);
            tg.fillRect(0, 0, w, h);
            tg.setComposite(origComp);
            int offX = -r.x;
            int offY = -r.y;
            tg.translate(offX, offY);
            tg.setBackground(g.getBackground());
            tg.setClip(0, 0, w, h);
            tg.setColor(g.getColor());
            tg.setComposite(g.getComposite());
            tg.setFont(g.getFont());
            tg.setPaint(g.getPaint());
            tg.setRenderingHints(g.getRenderingHints());
            tg.setStroke(g.getStroke());
            JComponent jc = (JComponent)c;
            DisabledMark mark = new DisabledMark(g, tmp, offX, offY);
            jc.putClientProperty("net.sourceforge.napkinlaf.disabledMark", mark);
            g = tg;
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g;
    }

    public static void syncWithTheme(Graphics2D g, Component c) {
        if (NapkinUtil.isPaper(c)) {
            paperStack.push(c);
            themeStack.push((NapkinTheme)((JComponent)c).getClientProperty("net.sourceforge.napkinlaf.theme"));
            NapkinUtil.dumpStacks();
        }
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        Color themePen = theme.getPenColor();
        Color fgColor = NapkinUtil.ifReplace(c.getForeground(), themePen);
        if (!fgColor.equals(c.getForeground())) {
            c.setForeground(fgColor);
            if (g != null) {
                g.setColor(fgColor);
            }
        }
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            Color selColor = NapkinUtil.ifReplace(tc.getSelectedTextColor(), themePen);
            tc.setSelectedTextColor(selColor);
        }
    }

    public static void syncWithTheme(Border border, Component c) {
        if (border instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)border;
            Color pen = NapkinUtil.currentTheme(c).getPenColor();
            tb.setTitleColor(NapkinUtil.ifReplace(tb.getTitleColor(), pen));
        } else if (border instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)border;
            NapkinUtil.syncWithTheme(cb.getInsideBorder(), c);
            NapkinUtil.syncWithTheme(cb.getOutsideBorder(), c);
        }
    }

    public static NapkinTheme currentTheme(Component c) {
        if (themeStack.isEmpty()) {
            return (NapkinTheme)NapkinUtil.themeTopFor(c).getClientProperty("net.sourceforge.napkinlaf.theme");
        }
        return themeStack.peek();
    }

    public static Component currentPaper(Component c) {
        if (paperStack.isEmpty()) {
            return NapkinUtil.themeTopFor(c);
        }
        return paperStack.peek();
    }

    public static void finishGraphics(Graphics g1, Component c) {
        if (c == NapkinUtil.currentPaper(c)) {
            if (!paperStack.isEmpty()) {
                paperStack.pop();
            }
            if (!themeStack.isEmpty()) {
                themeStack.pop();
            }
            NapkinUtil.dumpStacks();
        }
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent jc = (JComponent)c;
        DisabledMark mark = (DisabledMark)jc.getClientProperty("net.sourceforge.napkinlaf.disabledMark");
        if (mark == null) {
            return;
        }
        jc.putClientProperty("net.sourceforge.napkinlaf.disabledMark", null);
        Graphics2D tg = (Graphics2D)g1;
        tg.setComposite(ERASURE_COMPOSITE);
        Point start = NapkinUtil.getStart(jc, null);
        int w = textureImage.getWidth();
        int h = textureImage.getHeight();
        Rectangle anchor = new Rectangle(w - start.x, h - start.y, w, h);
        tg.setPaint(new TexturePaint(textureImage, anchor));
        tg.fillRect(0, 0, mark.image.getWidth(), mark.image.getHeight());
        Graphics2D g = mark.graphics;
        g.drawImage((Image)mark.image, -mark.offX, -mark.offY, jc);
    }

    private static void setupBorder(Component c) {
        JComponent jc;
        Border b;
        if (c instanceof JComponent && (b = (jc = (JComponent)c).getBorder()) != null && !(b instanceof AbstractNapkinBorder)) {
            jc.setBorder(NapkinWrappedBorder.wrap(b));
        }
    }

    private static void unsetupBorder(JComponent c) {
        Border b = c.getBorder();
        if (b instanceof NapkinWrappedBorder) {
            NapkinWrappedBorder nb = (NapkinWrappedBorder)b;
            c.setBorder(nb.getOrigBorder());
        } else if (b instanceof AbstractNapkinBorder) {
            c.setBorder(null);
        }
    }

    static AffineTransform scaleMat(double scale) {
        AffineTransform mat = new AffineTransform();
        mat.scale(scale, scale);
        return mat;
    }

    public static JButton createArrowButton(int pointTowards) {
        int size = 10;
        return NapkinUtil.createArrowButton(pointTowards, size);
    }

    public static JButton createArrowButton(int pointTowards, int size) {
        Icon arrow = NapkinIconFactory.createArrowIcon(pointTowards, size);
        JButton button = new JButton(arrow);
        button.setBorderPainted(false);
        Dimension dim = new Dimension(size + 3, size + 3);
        button.setPreferredSize(dim);
        button.setMinimumSize(dim);
        return button;
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public static DrawnLineHolder paintLine(Graphics g, boolean vertical, DrawnLineHolder holder, Rectangle bounds) {
        if (holder == null) {
            holder = new DrawnLineHolder((AbstractDrawnGenerator)DrawnCubicLineGenerator.INSTANCE, vertical);
        }
        holder.shapeUpToDate(bounds, null);
        Graphics2D lineG = NapkinUtil.copy(g);
        if (vertical) {
            lineG.translate(bounds.x + bounds.width / 2, 0);
        } else {
            lineG.translate(0, bounds.y + bounds.height / 2);
        }
        holder.draw(lineG);
        return holder;
    }

    public static void printPair(Logger logger, Level level, String label, double x, double y) {
        logger.log(level, label + ": " + x + ", " + y);
    }

    public static void setupPaper(JComponent c, NapkinKnownTheme theme) {
        c.setOpaque(true);
        NapkinTheme baseTheme = NapkinTheme.Manager.getCurrentTheme();
        c.putClientProperty("net.sourceforge.napkinlaf.theme", baseTheme.getTheme(theme));
    }

    public static NapkinTheme paintBackground(Graphics g1, Component c) {
        if (NapkinUtil.isGlassPane(c)) {
            return null;
        }
        Graphics2D g = (Graphics2D)g1;
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        NapkinBackground bg = theme.getPaper();
        Rectangle pRect = NapkinUtil.bounds(NapkinUtil.currentPaper(c));
        Rectangle cRect = NapkinUtil.bounds(c);
        bg.paint(c, g, pRect, cRect, NapkinUtil.insets(c));
        return theme;
    }

    private static Rectangle bounds(Component c) {
        Insets in = NapkinUtil.insets(c);
        Point start = NapkinUtil.getStart(c, in);
        int x = start.x;
        int y = start.y;
        int width = c.getWidth() + in.left + in.right;
        int height = c.getHeight() + in.top + in.bottom;
        return new Rectangle(x, y, width, height);
    }

    private static Insets insets(Component c) {
        return c instanceof Container ? ((Container)c).getInsets() : NO_INSETS;
    }

    public static JComponent themeTopFor(Component c) {
        if (c == null) {
            return null;
        }
        if (!(c instanceof JComponent)) {
            return NapkinUtil.themeTopFor(c.getParent());
        }
        JComponent jc = (JComponent)c;
        if (jc.getClientProperty("net.sourceforge.napkinlaf.theme") != null) {
            return jc;
        }
        JComponent themeTop = NapkinUtil.themeTopFor(jc.getParent());
        if (themeTop == null) {
            NapkinUtil.setupPaper(jc, NapkinKnownTheme.BASIC_THEME);
            return jc;
        }
        return themeTop;
    }

    private static Point getStart(Component c, Insets insets) {
        Point start = new Point();
        if (insets != null) {
            start.setLocation(-insets.left, -insets.top);
        }
        Component paper = NapkinUtil.currentPaper(c);
        while (c != null && c != paper) {
            start.x += c.getX();
            start.y += c.getY();
            c = c.getParent();
        }
        return start;
    }

    private static boolean isPaper(Component c) {
        if (c instanceof JComponent) {
            return ((JComponent)c).getClientProperty("net.sourceforge.napkinlaf.theme") != null;
        }
        return false;
    }

    public static void paintButtonText(Graphics g, JComponent c, Rectangle textRect, String text, int textOffset, DrawnLineHolder line, boolean isDefault, NapkinTextPainter helper) {
        AbstractButton button;
        ButtonModel model;
        if (isDefault) {
            if (line == null) {
                line = new DrawnLineHolder(new DrawnCubicLineGenerator());
            }
            Graphics2D ulG = NapkinUtil.copy(g);
            FontMetrics fm = ulG.getFontMetrics();
            line.shapeUpToDate(textRect, fm);
            ulG.translate(textOffset, textOffset);
            ulG.setColor(NapkinUtil.currentTheme(c).getCheckColor());
            line.setWidth(1.5f);
            line.draw(ulG);
        }
        Color textColor = c.getForeground();
        if (c instanceof AbstractButton && ((model = (button = (AbstractButton)c).getModel()).isArmed() || c instanceof JMenu && model.isSelected())) {
            textColor = NapkinUtil.currentTheme(c).getSelectionColor();
        }
        g.setColor(textColor);
        helper.superPaintText(g, c, textRect, text);
    }

    public static Object getProperty(JComponent c, String key, PropertyFactory factory) {
        Object value = c.getClientProperty(key);
        if (value == null) {
            value = factory.createPropertyValue();
            c.putClientProperty(key, value);
        }
        return value;
    }

    public static boolean replace(Object current, Object candidate) {
        if (current == null) {
            return true;
        }
        return !current.equals(candidate) && current instanceof UIResource;
    }

    public static Color ifReplace(Color current, Color candidate) {
        return NapkinUtil.replace(current, candidate) ? candidate : current;
    }

    public static void drawStroke(GeneralPath path, AffineTransform matrix, double x1, double y1, double x2, double y2, double baseAngle, AbstractDrawnGenerator lineGen) {
        if (matrix == null) {
            matrix = new AffineTransform();
        }
        double xDelta = x1 - x2;
        double yDelta = y1 - y2;
        double angle = Math.atan2(xDelta, yDelta);
        AffineTransform mat = (AffineTransform)matrix.clone();
        mat.translate(x1, y1);
        mat.rotate(baseAngle + angle);
        double len = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        mat.scale(len / 100.0, 1.0);
        AbstractDrawnGenerator.addLine(path, mat, lineGen);
    }

    public static void update(Graphics g, JComponent c, NapkinPainter painter) {
        if ((c instanceof JButton || c instanceof JLabel) && !Boolean.FALSE.equals(c.getClientProperty("net.sourceforge.napkinlaf.revalidated"))) {
            c.putClientProperty("net.sourceforge.napkinlaf.revalidated", false);
            c.revalidate();
        }
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinTheme theme = NapkinUtil.paintBackground(g, c);
        painter.superPaint(g, c, theme);
        NapkinUtil.finishGraphics(g, c);
    }

    private static void dumpStacks() {
        if (!Logs.paper.isLoggable(Level.FINER)) {
            return;
        }
        if (themeStack.size() != paperStack.size()) {
            System.out.println("!!!");
        }
        StringBuilder dump = new StringBuilder(NapkinDebug.count).append(":\t");
        ++NapkinDebug.count;
        for (int i = 0; i < paperStack.size(); ++i) {
            dump.append(". ");
        }
        if (!themeStack.isEmpty()) {
            dump.append(themeStack.peek()).append(" / ").append(NapkinDebug.descFor(paperStack.peek()));
        }
        Logs.paper.log(Level.FINER, dump.toString());
    }

    public static IOException tryClose(Closeable fonts) {
        try {
            fonts.close();
            return null;
        }
        catch (IOException e) {
            return e;
        }
    }

    static {
        BACKGROUND_LISTENER = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JComponent c = (JComponent)event.getSource();
                c.removePropertyChangeListener(NapkinUtil.BACKGROUND, BACKGROUND_LISTENER);
                Color newColor = (Color)event.getNewValue();
                if (NapkinUtil.replaceBackground(newColor)) {
                    c.setBackground(NapkinConstants.CLEAR);
                }
                c.addPropertyChangeListener(NapkinUtil.BACKGROUND, BACKGROUND_LISTENER);
            }
        };
        BORDER_LISTENER = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JComponent c = (JComponent)event.getSource();
                c.removePropertyChangeListener(NapkinUtil.BORDER, BORDER_LISTENER);
                NapkinUtil.setupBorder(c);
                c.addPropertyChangeListener(NapkinUtil.BORDER, BORDER_LISTENER);
            }
        };
        OPAQUE_LISTENER = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JComponent c = (JComponent)event.getSource();
                boolean val = (Boolean)event.getNewValue();
                c.putClientProperty("net.sourceforge.napkinlaf.wasOpaque", val ? Boolean.TRUE : null);
                if (val && c.getBackground() == NapkinConstants.CLEAR) {
                    c.removePropertyChangeListener(NapkinUtil.OPAQUE, OPAQUE_LISTENER);
                    c.setOpaque(false);
                    c.addPropertyChangeListener(NapkinUtil.OPAQUE, OPAQUE_LISTENER);
                }
            }
        };
        NO_INSETS = new Insets(0, 0, 0, 0);
        ERASURE_COMPOSITE = AlphaComposite.getInstance(8, 0.9f);
        themeStack = new Stack();
        paperStack = new Stack();
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        ImageIcon icon = theme.getErasureMask().getIcon();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        textureImage = new BufferedImage(w, h, 2);
        Graphics2D gi = textureImage.createGraphics();
        gi.setColor(new Color(0, 0, 0, 0));
        gi.fillRect(0, 0, w, h);
        gi.drawImage(icon.getImage(), 0, 0, icon.getImageObserver());
    }

    public static interface Logs {
        public static final Logger paper = Logger.getLogger("net.sourceforge.napkinlaf.paper");
    }

    public static class DisabledMark {
        public final BufferedImage image;
        public final int offX;
        public final int offY;
        public final Graphics2D graphics;

        public DisabledMark(Graphics2D graphics, BufferedImage image, int offX, int offY) {
            this.graphics = NapkinUtil.copy(graphics);
            this.image = image;
            this.offX = offX;
            this.offY = offY;
        }
    }

    public static interface PropertyFactory {
        public Object createPropertyValue();
    }
}

