/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.sketchers;

import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;
import net.sourceforge.napkinlaf.util.NapkinRandom;

public class DraftSketcher
extends AbstractSketcher {
    private static final double DEFORM_FACTOR = 0.05;

    public SketchShape deformLine(StraightLine l) {
        StraightLine ret = new StraightLine(l);
        double scale = l.length() * 0.05;
        if (l.slope() == Double.POSITIVE_INFINITY) {
            if (ret.y2 < ret.y1) {
                scale = -scale;
            }
            ret.y2 += Math.abs(NapkinRandom.gaussian() + 1.0) * scale;
            ret.y1 -= Math.abs(NapkinRandom.gaussian() + 1.0) * scale;
        } else {
            if (ret.x2 < ret.x1) {
                scale = -scale;
            }
            double bonusL = Math.abs(NapkinRandom.gaussian() + 1.0) * scale;
            double bonusR = Math.abs(NapkinRandom.gaussian() + 1.0) * scale;
            double cos = Math.cos(l.angle());
            ret.x1 -= bonusL / cos;
            ret.x2 += bonusR / cos;
            double intercept = l.yIntercept();
            ret.y1 = l.slope() * l.x1 + intercept;
            ret.y2 = l.slope() * l.x2 + intercept;
        }
        return ret;
    }

    public SketchShape deformQuad(QuadLine q) {
        if (q.getFlatness() < q.approximateLength() * 0.05) {
            return new StraightLine(q.getP1(), q.getP2()).deform(this);
        }
        return q;
    }

    public SketchShape deformCubic(CubicLine c) {
        if (c.getFlatness() < c.approximateLength() * 0.05 * 0.5) {
            return new StraightLine(c.getP1(), c.getP2()).deform(this);
        }
        return c;
    }

    public SketchShape deformPath(Path p) {
        SketchShape[] elements;
        Path ret = new Path();
        for (SketchShape element : elements = p.simplify()) {
            ret.append(element.deform(this), false);
        }
        return ret;
    }
}

