/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.geometry;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.XMLUtility;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.Point;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.XMLStraightLine;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;

public class StraightLine
extends Line2D.Double
implements SketchShape {
    public StraightLine() {
    }

    public StraightLine(Line2D l) {
        super(l.getP1(), l.getP2());
    }

    public StraightLine(Point2D p1, Point2D p2) {
        super(p1, p2);
    }

    public StraightLine(Point2D start, double angle, double length) {
        super(start, new Point2D.Double(start.getX() + length * Math.cos(angle), start.getY() + length * Math.sin(angle)));
    }

    public StraightLine(double x1, double y1, double angle, double length) {
        this(new Point2D.Double(x1, y1), angle, length);
    }

    public double length() {
        return Math.sqrt(Math.pow(this.x2 - this.x1, 2.0) + Math.pow(this.y2 - this.y1, 2.0));
    }

    public double slope() {
        return this.x2 - this.x1 == 0.0 ? Double.POSITIVE_INFINITY : (this.y2 - this.y1) / (this.x2 - this.x1);
    }

    public double yIntercept() {
        return this.slope() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : this.y1 - this.slope() * this.x1;
    }

    public double angle() {
        return Math.atan(this.slope());
    }

    public Element produceXML() {
        DefaultJDOMFactory f = new DefaultJDOMFactory();
        Element ret = f.element("straightLine");
        ret.addContent(XMLUtility.pointToXML(this.getP1(), "start"));
        ret.addContent(XMLUtility.pointToXML(this.getP2(), "end"));
        return ret;
    }

    public SketchShape magnify(double scaleFactor) {
        return new XMLStraightLine(new Point(this.x1 * scaleFactor, this.y1 * scaleFactor), new Point(this.x2 * scaleFactor, this.y2 * scaleFactor));
    }

    public CubicLine transformToCubic() {
        return new CubicLine(this.getP1(), this.getP1(), this.getP2(), this.getP2());
    }

    public Path transformToPath() {
        Path ret = new Path();
        Point s = new Point(this.getP1());
        Point f = new Point(this.getP2());
        ret.moveTo(s.floatX(), s.floatY());
        ret.lineTo(f.floatX(), f.floatY());
        return ret;
    }

    public StraightLine[] transformToLine() {
        StraightLine[] ret = new StraightLine[]{new StraightLine(this)};
        return ret;
    }

    public QuadLine[] transformToQuad() {
        QuadLine[] ret = new QuadLine[]{new QuadLine(this.getP1(), this.midpoint(), this.getP2())};
        return ret;
    }

    public Point intersects(StraightLine o) {
        double y;
        double x;
        if (!this.intersectsLine(o)) {
            return null;
        }
        double slope = this.slope();
        double slopeprime = o.slope();
        double b = this.y1 - slope * this.x1;
        double bprime = o.y1 - slopeprime * o.x1;
        if (slope == Double.POSITIVE_INFINITY) {
            x = this.x1;
            y = slopeprime * x + bprime;
        } else if (slopeprime == Double.POSITIVE_INFINITY) {
            x = o.x1;
            y = slope * x + b;
        } else {
            x = (b - bprime) / (slopeprime - slope);
            y = (slope * x + b + (slopeprime * x + bprime)) / 2.0;
        }
        return new Point(x, y);
    }

    public Point midpoint() {
        return new Point((this.x2 + this.x1) / 2.0, (this.y2 + this.y1) / 2.0);
    }

    public SketchShape deform(AbstractSketcher r) {
        return r.deformLine(this);
    }

    public double approximateLength() {
        return this.length();
    }

    public CubicLine[] transformToCubicList() {
        CubicLine[] ret = new CubicLine[]{this.transformToCubic()};
        return ret;
    }

    public StraightLine clone() {
        return (StraightLine)super.clone();
    }
}

